/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.Convertors_jvmKt$WhenMappings;
import org.jetbrains.skiko.DirectDataBuffer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u00a8\u0006\u0006"}, d2={"toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "skiko"})
public final class Convertors_jvmKt {
    public static final BufferedImage toBufferedImage(Bitmap object) {
        int[] nArray;
        int[] nArray2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Pixmap pixmap = ((Bitmap)object).peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long l = pixmap.getAddr();
        Object object2 = BufferUtil.INSTANCE.getByteBufferFromPointer(l, ((Bitmap)object).getRowBytes() * ((Bitmap)object).getHeight());
        switch (Convertors_jvmKt$WhenMappings.$EnumSwitchMapping$0[((Bitmap)object).getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray3 = new int[4];
                nArray2 = nArray3;
                nArray3[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray4 = new int[4];
                nArray2 = nArray4;
                nArray4[0] = 2;
                nArray2[1] = 1;
                nArray2[2] = 0;
                nArray2[3] = 3;
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + (Object)((Object)((Bitmap)object).getColorInfo().getColorType()));
            }
        }
        nArray2 = nArray;
        object = Raster.createInterleavedRaster(new DirectDataBuffer((ByteBuffer)object2), ((Bitmap)object).getWidth(), ((Bitmap)object).getHeight(), ((Bitmap)object).getWidth() << 2, 4, nArray2, null);
        object2 = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel = (ColorModel)object2;
        Object object3 = object;
        Intrinsics.checkNotNull((Object)object3);
        return new BufferedImage(colorModel, (WritableRaster)object3, false, null);
    }

    public static final Bitmap toBitmap(BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"");
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() << 2];
        int n = 0;
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            int n3 = bufferedImage.getWidth();
            for (int j = 0; j < n3; ++j) {
                int n4 = bufferedImage.getRGB(j, i);
                int n5 = n4 >>> 24;
                int n6 = n4 >> 16 & 0xFF;
                int n7 = n4 >> 8 & 0xFF;
                byArray[n++] = (byte)(n4 &= 0xFF);
                byArray[n++] = (byte)n7;
                byArray[n++] = (byte)n6;
                byArray[n++] = (byte)n5;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32(bufferedImage.getWidth(), bufferedImage.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(byArray);
        return bitmap;
    }

    public static final Image toImage(BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap(bufferedImage));
    }
}

