/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.swing.SkiaSwingLayer$Companion;
import org.jetbrains.skiko.swing.SkiaSwingLayer$redrawerManager$1;
import org.jetbrains.skiko.swing.SkiaSwingLayer$renderDelegateWithClipping$1;
import org.jetbrains.skiko.swing.SkiaSwingLayer$swingLayerProperties$1;
import org.jetbrains.skiko.swing.SwingRedrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u001c\u001f\b\u0017\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\"J\u0012\u0010$\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010,R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 \u00a8\u0006."}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "Ljavax/swing/JComponent;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "isDisposed", "", "isInitialized", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "redrawer", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "getRedrawer", "()Lorg/jetbrains/skiko/swing/SwingRedrawer;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "renderDelegateWithClipping", "org/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1;", "swingLayerProperties", "org/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "addNotify", "", "dispose", "init", "recreation", "paint", "g", "Ljava/awt/Graphics;", "removeNotify", "requestNativeFocusOnAccessible", "accessible", "Ljavax/accessibility/Accessible;", "Companion", "skiko"})
public class SkiaSwingLayer
extends JComponent {
    public static final SkiaSwingLayer$Companion Companion = new SkiaSwingLayer$Companion(null);
    private final SkiaLayerProperties properties;
    private boolean isInitialized;
    private volatile boolean isDisposed;
    private final SkiaSwingLayer$renderDelegateWithClipping$1 renderDelegateWithClipping;
    private final SkiaSwingLayer$swingLayerProperties$1 swingLayerProperties;
    private final RedrawerManager<SwingRedrawer> redrawerManager;

    public SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        this.properties = new SkiaLayerProperties(false, false, null, null, 15, null);
        this.renderDelegateWithClipping = new SkiaSwingLayer$renderDelegateWithClipping$1(skikoRenderDelegate, this);
        this.swingLayerProperties = new SkiaSwingLayer$swingLayerProperties$1(this);
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), new SkiaSwingLayer$redrawerManager$1(this, skiaLayerAnalytics));
        this.setOpaque(false);
        this.setLayout(null);
    }

    public /* synthetic */ SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        this(skikoRenderDelegate, skiaLayerAnalytics);
    }

    public final List<ClipRectangle> getClipComponents() {
        return new ArrayList();
    }

    private final SwingRedrawer getRedrawer() {
        return this.redrawerManager.getRedrawer();
    }

    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    @Override
    public void removeNotify() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("SkiaSwingLayer.awt#removeNotify " + this);
        }
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("SkiaSwingLayer.awt#addNotify " + this);
        }
        super.addNotify();
        SkiaSwingLayer skiaSwingLayer = this;
        skiaSwingLayer.init(skiaSwingLayer.isInitialized);
    }

    private final void init(boolean bl) {
        this.isDisposed = false;
        this.redrawerManager.findNextWorkingRenderApi(bl);
        this.isInitialized = true;
    }

    static /* synthetic */ void init$default(SkiaSwingLayer skiaSwingLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaSwingLayer.init(bl);
    }

    public final void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInitialized && !this.isDisposed) {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.dispose();
            }
            this.redrawerManager.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"");
        try {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.redraw((Graphics2D)graphics);
                return;
            }
            return;
        }
        catch (RenderException renderException) {
            if (!this.isDisposed) {
                Object object = Logger.INSTANCE;
                if (((Logger)object).getLoggerImpl().isWarnEnabled()) {
                    SkikoLoggerInterface skikoLoggerInterface = ((Logger)object).getLoggerImpl();
                    object = renderException;
                    SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface2.warn((Throwable)object, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                this.repaint();
            }
            return;
        }
    }

    public final void requestNativeFocusOnAccessible(Accessible accessible) {
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaSwingLayer skiaSwingLayer) {
        return skiaSwingLayer.properties;
    }

    public static final /* synthetic */ SkiaSwingLayer$swingLayerProperties$1 access$getSwingLayerProperties$p(SkiaSwingLayer skiaSwingLayer) {
        return skiaSwingLayer.swingLayerProperties;
    }

    public static final /* synthetic */ SkiaSwingLayer$renderDelegateWithClipping$1 access$getRenderDelegateWithClipping$p(SkiaSwingLayer skiaSwingLayer) {
        return skiaSwingLayer.renderDelegateWithClipping;
    }

    static {
        Library.INSTANCE.load();
    }
}

