/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.JsonEscapeUtil;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.event.KeyValuePair;

public class JsonEncoder
extends EncoderBase<ILoggingEvent> {
    static final boolean DO_NOT_ADD_QUOTE_KEY = false;
    static final boolean ADD_QUOTE_KEY = true;
    static int DEFAULT_SIZE = 1024;
    static int DEFAULT_SIZE_WITH_THROWABLE = 1024 << 3;
    static byte[] EMPTY_BYTES = new byte[0];
    public static final String CONTEXT_ATTR_NAME = "context";
    public static final String NAME_ATTR_NAME = "name";
    public static final String BIRTHDATE_ATTR_NAME = "birthdate";
    public static final String CONTEXT_PROPERTIES_ATTR_NAME = "properties";
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String NANOSECONDS_ATTR_NAME = "nanoseconds";
    public static final String SEQUENCE_NUMBER_ATTR_NAME = "sequenceNumber";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String MARKERS_ATTR_NAME = "markers";
    public static final String THREAD_NAME_ATTR_NAME = "threadName";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "loggerName";
    public static final String MESSAGE_ATTR_NAME = "message";
    public static final String ARGUMENT_ARRAY_ATTR_NAME = "arguments";
    public static final String KEY_VALUE_PAIRS_ATTR_NAME = "kvpList";
    public static final String THROWABLE_ATTR_NAME = "throwable";
    private static final String CYCLIC_THROWABLE_ATTR_NAME = "cyclic";
    public static final String CAUSE_ATTR_NAME = "cause";
    public static final String SUPPRESSED_ATTR_NAME = "suppressed";
    public static final String COMMON_FRAMES_COUNT_ATTR_NAME = "commonFramesCount";
    public static final String CLASS_NAME_ATTR_NAME = "className";
    public static final String METHOD_NAME_ATTR_NAME = "methodName";
    private static final String FILE_NAME_ATTR_NAME = "fileName";
    private static final String LINE_NUMBER_ATTR_NAME = "lineNumber";
    public static final String STEP_ARRAY_NAME_ATTRIBUTE = "stepArray";
    private static final char OPEN_OBJ = '{';
    private static final char CLOSE_OBJ = '}';
    private static final char OPEN_ARRAY = '[';
    private static final char CLOSE_ARRAY = ']';
    private static final char QUOTE = '\"';
    private static final char SP = ' ';
    private static final char ENTRY_SEPARATOR = ':';
    private static final String COL_SP = ": ";
    private static final String QUOTE_COL = "\":";
    private static final char VALUE_SEPARATOR = ',';

    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    public byte[] encode(ILoggingEvent iLoggingEvent) {
        int n = iLoggingEvent.getThrowableProxy() == null ? DEFAULT_SIZE : DEFAULT_SIZE_WITH_THROWABLE;
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append('{');
        this.appenderMemberWithLongValue(stringBuilder, SEQUENCE_NUMBER_ATTR_NAME, iLoggingEvent.getSequenceNumber());
        stringBuilder.append(',');
        this.appenderMemberWithLongValue(stringBuilder, TIMESTAMP_ATTR_NAME, iLoggingEvent.getTimeStamp());
        stringBuilder.append(',');
        this.appenderMemberWithLongValue(stringBuilder, NANOSECONDS_ATTR_NAME, iLoggingEvent.getNanoseconds());
        stringBuilder.append(',');
        String string = iLoggingEvent.getLevel() != null ? iLoggingEvent.getLevel().levelStr : "null";
        this.appenderMember(stringBuilder, LEVEL_ATTR_NAME, string);
        stringBuilder.append(',');
        this.appenderMember(stringBuilder, THREAD_NAME_ATTR_NAME, this.jsonEscape(iLoggingEvent.getThreadName()));
        stringBuilder.append(',');
        this.appenderMember(stringBuilder, LOGGER_ATTR_NAME, iLoggingEvent.getLoggerName());
        stringBuilder.append(',');
        this.appendLoggerContext(stringBuilder, iLoggingEvent.getLoggerContextVO());
        stringBuilder.append(',');
        this.appendMarkers(stringBuilder, iLoggingEvent);
        this.appendMDC(stringBuilder, iLoggingEvent);
        this.appendKeyValuePairs(stringBuilder, iLoggingEvent);
        this.appenderMember(stringBuilder, MESSAGE_ATTR_NAME, this.jsonEscape(iLoggingEvent.getMessage()));
        stringBuilder.append(',');
        this.appendArgumentArray(stringBuilder, iLoggingEvent);
        this.appendThrowableProxy(stringBuilder, THROWABLE_ATTR_NAME, iLoggingEvent.getThrowableProxy());
        stringBuilder.append('}');
        stringBuilder.append('\n');
        return stringBuilder.toString().getBytes(CoreConstants.UTF_8_CHARSET);
    }

    private void appendLoggerContext(StringBuilder stringBuilder, LoggerContextVO loggerContextVO) {
        stringBuilder.append('\"').append("context\":");
        if (loggerContextVO == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        this.appenderMember(stringBuilder, NAME_ATTR_NAME, this.nullSafeStr(loggerContextVO.getName()));
        stringBuilder.append(',');
        this.appenderMemberWithLongValue(stringBuilder, BIRTHDATE_ATTR_NAME, loggerContextVO.getBirthTime());
        stringBuilder.append(',');
        this.appendMap(stringBuilder, CONTEXT_PROPERTIES_ATTR_NAME, loggerContextVO.getPropertyMap());
        stringBuilder.append('}');
    }

    private void appendMap(StringBuilder stringBuilder, String string, Map<String, String> iterator) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL);
        if (iterator == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        boolean bl = false;
        iterator = iterator.entrySet();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            this.appenderMember(stringBuilder, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
        }
        stringBuilder.append('}');
    }

    private void appendThrowableProxy(StringBuilder stringBuilder, String iThrowableProxyArray, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxyArray != null) {
            stringBuilder.append('\"').append((String)iThrowableProxyArray).append(QUOTE_COL);
            if (iThrowableProxy == null) {
                stringBuilder.append("null");
                return;
            }
        }
        stringBuilder.append('{');
        this.appenderMember(stringBuilder, CLASS_NAME_ATTR_NAME, this.nullSafeStr(iThrowableProxy.getClassName()));
        stringBuilder.append(',');
        this.appenderMember(stringBuilder, MESSAGE_ATTR_NAME, this.jsonEscape(iThrowableProxy.getMessage()));
        if (iThrowableProxy.isCyclic()) {
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, CYCLIC_THROWABLE_ATTR_NAME, this.jsonEscape("true"));
        }
        stringBuilder.append(',');
        this.appendSTEPArray(stringBuilder, iThrowableProxy.getStackTraceElementProxyArray(), iThrowableProxy.getCommonFrames());
        if (iThrowableProxy.getCommonFrames() != 0) {
            stringBuilder.append(',');
            this.appenderMemberWithIntValue(stringBuilder, COMMON_FRAMES_COUNT_ATTR_NAME, iThrowableProxy.getCommonFrames());
        }
        if ((iThrowableProxyArray = iThrowableProxy.getCause()) != null) {
            stringBuilder.append(',');
            this.appendThrowableProxy(stringBuilder, CAUSE_ATTR_NAME, (IThrowableProxy)iThrowableProxyArray);
        }
        if ((iThrowableProxyArray = iThrowableProxy.getSuppressed()) != null && iThrowableProxyArray.length != 0) {
            stringBuilder.append(',');
            stringBuilder.append('\"').append("suppressed\":");
            stringBuilder.append('[');
            boolean bl = true;
            for (IThrowableProxy iThrowableProxy2 : iThrowableProxyArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                this.appendThrowableProxy(stringBuilder, null, iThrowableProxy2);
            }
            stringBuilder.append(']');
        }
        stringBuilder.append('}');
    }

    private void appendSTEPArray(StringBuilder stringBuilder, StackTraceElementProxy[] stackTraceElementProxyArray, int n) {
        int n2;
        stringBuilder.append('\"').append("stepArray\":").append('[');
        int n3 = n2 = stackTraceElementProxyArray != null ? stackTraceElementProxyArray.length : 0;
        if (n >= n2) {
            n = 0;
        }
        for (int i = 0; i < n2 - n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            Serializable serializable = stackTraceElementProxyArray[i];
            stringBuilder.append('{');
            serializable = ((StackTraceElementProxy)serializable).getStackTraceElement();
            this.appenderMember(stringBuilder, CLASS_NAME_ATTR_NAME, this.nullSafeStr(((StackTraceElement)serializable).getClassName()));
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, METHOD_NAME_ATTR_NAME, this.nullSafeStr(((StackTraceElement)serializable).getMethodName()));
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, FILE_NAME_ATTR_NAME, this.nullSafeStr(((StackTraceElement)serializable).getFileName()));
            stringBuilder.append(',');
            this.appenderMemberWithIntValue(stringBuilder, LINE_NUMBER_ATTR_NAME, ((StackTraceElement)serializable).getLineNumber());
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
    }

    private void appenderMember(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('\"').append(string).append("\":\"").append(string2).append('\"');
    }

    private void appenderMemberWithIntValue(StringBuilder stringBuilder, String string, int n) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append(n);
    }

    private void appenderMemberWithLongValue(StringBuilder stringBuilder, String string, long l) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append(l);
    }

    private void appendKeyValuePairs(StringBuilder stringBuilder, ILoggingEvent object) {
        if ((object = object.getKeyValuePairs()) == null || object.isEmpty()) {
            return;
        }
        stringBuilder.append('\"').append("kvpList\":").append(' ').append('[');
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            KeyValuePair keyValuePair = (KeyValuePair)object.get(i);
            stringBuilder.append('{');
            this.appenderMember(stringBuilder, this.jsonEscapedToString(keyValuePair.key), this.jsonEscapedToString(keyValuePair.value));
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
        stringBuilder.append(',');
    }

    private void appendArgumentArray(StringBuilder stringBuilder, ILoggingEvent objectArray) {
        if ((objectArray = objectArray.getArgumentArray()) == null) {
            return;
        }
        stringBuilder.append('\"').append("arguments\":").append(' ').append('[');
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(this.jsonEscapedToString(objectArray[i])).append('\"');
        }
        stringBuilder.append(']');
        stringBuilder.append(',');
    }

    private void appendMarkers(StringBuilder stringBuilder, ILoggingEvent object) {
        if ((object = object.getMarkerList()) == null) {
            return;
        }
        stringBuilder.append('\"').append("markers\":").append(' ').append('[');
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(this.jsonEscapedToString(object.get(i))).append('\"');
        }
        stringBuilder.append(']');
        stringBuilder.append(',');
    }

    private String jsonEscapedToString(Object object) {
        if (object == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString((String)object.toString());
    }

    private String nullSafeStr(String string) {
        if (string == null) {
            return "null";
        }
        return string;
    }

    private String jsonEscape(String string) {
        if (string == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString((String)string);
    }

    private void appendMDC(StringBuilder stringBuilder, ILoggingEvent object) {
        object = object.getMDCPropertyMap();
        stringBuilder.append('\"').append("mdc\":").append(' ').append('{');
        if (this.isNotEmptyMap((Map)object)) {
            object = object.entrySet();
            int n = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if (n != 0) {
                    stringBuilder.append(',');
                }
                this.appenderMember(stringBuilder, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
                ++n;
            }
        }
        stringBuilder.append('}');
        stringBuilder.append(',');
    }

    boolean isNotEmptyMap(Map map) {
        if (map == null) {
            return false;
        }
        return !map.isEmpty();
    }

    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }
}

