/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.NamedConverter$NameCache;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;

public abstract class NamedConverter
extends ClassicConverter {
    private static final String DISABLE_CACHE_SYSTEM_PROPERTY = "logback.namedConverter.disableCache";
    private static final int INITIAL_CACHE_SIZE = 512;
    private static final double LOAD_FACTOR = 0.75;
    private static final int MAX_ALLOWED_REMOVAL_THRESHOLD = 1536;
    private static final double CACHE_MISSRATE_TRIGGER = 0.3;
    private static final int MIN_SAMPLE_SIZE = 1024;
    private static final double NEGATIVE = -1.0;
    private volatile boolean cacheEnabled = true;
    private final NamedConverter$NameCache cache = new NamedConverter$NameCache(this, 512);
    private Abbreviator abbreviator = null;
    private volatile int cacheMisses = 0;
    private volatile int totalCalls = 0;

    protected abstract String getFullyQualifiedName(ILoggingEvent var1);

    public void start() {
        String string;
        String string2 = OptionHelper.getSystemProperty((String)DISABLE_CACHE_SYSTEM_PROPERTY);
        boolean bl = OptionHelper.toBoolean((String)string2, (boolean)false);
        if (bl) {
            this.addInfo("Disabling name cache via System.properties");
            this.cacheEnabled = false;
        }
        if ((string = this.getFirstOption()) != null) {
            try {
                int n = Integer.parseInt(string);
                if (n == 0) {
                    this.abbreviator = new ClassNameOnlyAbbreviator();
                } else if (n > 0) {
                    this.abbreviator = new TargetLengthBasedClassNameAbbreviator(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("failed to parse integer string [" + string + "]", numberFormatException);
            }
        }
        super.start();
    }

    public String convert(ILoggingEvent object) {
        object = this.getFullyQualifiedName((ILoggingEvent)object);
        if (this.abbreviator == null) {
            return object;
        }
        if (this.cacheEnabled) {
            return this.viaCache((String)object);
        }
        return this.abbreviator.abbreviate((String)object);
    }

    private synchronized String viaCache(String string) {
        ++this.totalCalls;
        String string2 = (String)this.cache.get(string);
        if (string2 == null) {
            ++this.cacheMisses;
            string2 = this.abbreviator.abbreviate(string);
            this.cache.put(string, string2);
        }
        return string2;
    }

    private void disableCache() {
        if (!this.cacheEnabled) {
            return;
        }
        this.cacheEnabled = false;
        this.cache.clear();
        NamedConverter namedConverter = this;
        namedConverter.addInfo("Disabling cache at totalCalls=" + namedConverter.totalCalls);
    }

    public double getCacheMissRate() {
        return this.cache.cacheMissCalculator.getCacheMissRate();
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }
}

