/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter$ReconfiguringThread;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.spi.FilterReply;
import java.net.URL;
import java.util.List;
import org.slf4j.Marker;

public class ReconfigureOnChangeFilter
extends TurboFilter {
    public static final long DEFAULT_REFRESH_PERIOD = 60000L;
    long refreshPeriod = 60000L;
    URL mainConfigurationURL;
    protected volatile long nextCheck;
    ConfigurationWatchList configurationWatchList;
    private long invocationCounter = 0L;
    private volatile long mask = 15L;
    private volatile long lastMaskCheck = System.currentTimeMillis();
    private static final int MAX_MASK = 65535;
    private static final long MASK_INCREASE_THRESHOLD = 100L;
    private static final long MASK_DECREASE_THRESHOLD = 800L;

    @Override
    public void start() {
        this.configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        if (this.configurationWatchList != null) {
            this.mainConfigurationURL = this.configurationWatchList.getMainURL();
            if (this.mainConfigurationURL == null) {
                this.addWarn("Due to missing top level configuration file, automatic reconfiguration is impossible.");
                return;
            }
            List list = this.configurationWatchList.getCopyOfFileWatchList();
            long l = this.refreshPeriod / 1000L;
            this.addInfo("Will scan for changes in [" + String.valueOf(list) + "] every " + l + " seconds. ");
            list = this.configurationWatchList;
            synchronized (list) {
                this.updateNextCheck(System.currentTimeMillis());
            }
            super.start();
            return;
        }
        this.addWarn("Empty ConfigurationWatchList in context");
    }

    public String toString() {
        return "ReconfigureOnChangeFilter{invocationCounter=" + this.invocationCounter + "}";
    }

    @Override
    public FilterReply decide(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if ((this.invocationCounter++ & this.mask) != this.mask) {
            return FilterReply.NEUTRAL;
        }
        long l = System.currentTimeMillis();
        marker = this.configurationWatchList;
        synchronized (marker) {
            this.updateMaskIfNecessary(l);
            if (this.changeDetected(l)) {
                this.disableSubsequentReconfiguration();
                this.detachReconfigurationToNewThread();
            }
        }
        return FilterReply.NEUTRAL;
    }

    private void updateMaskIfNecessary(long l) {
        long l2 = l - this.lastMaskCheck;
        this.lastMaskCheck = l;
        if (l2 < 100L && this.mask < 65535L) {
            this.mask = this.mask << 1 | 1L;
            return;
        }
        if (l2 > 800L) {
            this.mask >>>= 2;
        }
    }

    void detachReconfigurationToNewThread() {
        ReconfigureOnChangeFilter reconfigureOnChangeFilter = this;
        reconfigureOnChangeFilter.addInfo("Detected change in [" + String.valueOf(reconfigureOnChangeFilter.configurationWatchList.getCopyOfFileWatchList()) + "]");
        this.context.getExecutorService().submit(new ReconfigureOnChangeFilter$ReconfiguringThread(this));
    }

    void updateNextCheck(long l) {
        this.nextCheck = l + this.refreshPeriod;
    }

    protected boolean changeDetected(long l) {
        if (l >= this.nextCheck) {
            this.updateNextCheck(l);
            return this.configurationWatchList.changeDetected();
        }
        return false;
    }

    void disableSubsequentReconfiguration() {
        this.nextCheck = Long.MAX_VALUE;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(long l) {
        this.refreshPeriod = l;
    }

    static /* synthetic */ Context access$000(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$100(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$200(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$300(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$400(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$500(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$600(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }
}

