/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.extractmediametadata.mediainfo;

import com.ustadmobile.core.domain.extractmediametadata.mediainfo.json.MediaInfoResult;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/core/domain/extractmediametadata/mediainfo/ExecuteMediaInfoUseCase;", "", "mediaInfoPath", "", "workingDir", "Ljava/io/File;", "json", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/String;Ljava/io/File;Lkotlinx/serialization/json/Json;)V", "invoke", "Lcom/ustadmobile/core/domain/extractmediametadata/mediainfo/json/MediaInfoResult;", "file", "core"})
@SourceDebugExtension(value={"SMAP\nExecuteMediaInfoUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecuteMediaInfoUseCase.kt\ncom/ustadmobile/core/domain/extractmediametadata/mediainfo/ExecuteMediaInfoUseCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class ExecuteMediaInfoUseCase {
    @NotNull
    private final String mediaInfoPath;
    @NotNull
    private final File workingDir;
    @NotNull
    private final Json json;

    public ExecuteMediaInfoUseCase(@NotNull String mediaInfoPath, @NotNull File workingDir, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)mediaInfoPath, (String)"mediaInfoPath");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.mediaInfoPath = mediaInfoPath;
        this.workingDir = workingDir;
        this.json = json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MediaInfoResult invoke(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new String[]{this.mediaInfoPath, "--Output=JSON", file.getAbsolutePath()};
        Process process = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).redirectOutput(ProcessBuilder.Redirect.PIPE).directory(this.workingDir).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object processOutput = object2;
        int processResult = process.waitFor();
        if (processResult != 0) {
            throw new IllegalStateException("ExecuteMediaInfoUseCase: MediaInfo exited with non-zero status code: " + processResult);
        }
        return (MediaInfoResult)this.json.decodeFromString((DeserializationStrategy)MediaInfoResult.Companion.serializer(), (String)processOutput);
    }
}

