package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Report;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ReportDao_Impl extends ReportDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Report> __insertionAdapterOfReport;

  private final EntityInsertionAdapter<Report> __insertionAdapterOfReport_1;

  private final EntityDeletionOrUpdateAdapter<Report> __updateAdapterOfReport;

  public ReportDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfReport = new EntityInsertionAdapter<Report>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Report` (`reportUid`,`reportOwnerUid`,`xAxis`,`reportDateRangeSelection`,`fromDate`,`fromRelTo`,`fromRelOffSet`,`fromRelUnit`,`toDate`,`toRelTo`,`toRelOffSet`,`toRelUnit`,`reportTitle`,`reportDescription`,`reportSeries`,`reportInactive`,`isTemplate`,`priority`,`reportTitleId`,`reportDescId`,`reportMasterChangeSeqNum`,`reportLocalChangeSeqNum`,`reportLastChangedBy`,`reportLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Report entity) {
        statement.bindLong(1, entity.getReportUid());
        statement.bindLong(2, entity.getReportOwnerUid());
        statement.bindLong(3, entity.getXAxis());
        statement.bindLong(4, entity.getReportDateRangeSelection());
        statement.bindLong(5, entity.getFromDate());
        statement.bindLong(6, entity.getFromRelTo());
        statement.bindLong(7, entity.getFromRelOffSet());
        statement.bindLong(8, entity.getFromRelUnit());
        statement.bindLong(9, entity.getToDate());
        statement.bindLong(10, entity.getToRelTo());
        statement.bindLong(11, entity.getToRelOffSet());
        statement.bindLong(12, entity.getToRelUnit());
        if (entity.getReportTitle() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getReportTitle());
        }
        if (entity.getReportDescription() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getReportDescription());
        }
        if (entity.getReportSeries() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getReportSeries());
        }
        final int _tmp = entity.getReportInactive() ? 1 : 0;
        statement.bindLong(16, _tmp);
        final int _tmp_1 = entity.isTemplate() ? 1 : 0;
        statement.bindLong(17, _tmp_1);
        statement.bindLong(18, entity.getPriority());
        statement.bindLong(19, entity.getReportTitleId());
        statement.bindLong(20, entity.getReportDescId());
        statement.bindLong(21, entity.getReportMasterChangeSeqNum());
        statement.bindLong(22, entity.getReportLocalChangeSeqNum());
        statement.bindLong(23, entity.getReportLastChangedBy());
        statement.bindLong(24, entity.getReportLct());
      }
    };
    this.__insertionAdapterOfReport_1 = new EntityInsertionAdapter<Report>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `Report` (`reportUid`,`reportOwnerUid`,`xAxis`,`reportDateRangeSelection`,`fromDate`,`fromRelTo`,`fromRelOffSet`,`fromRelUnit`,`toDate`,`toRelTo`,`toRelOffSet`,`toRelUnit`,`reportTitle`,`reportDescription`,`reportSeries`,`reportInactive`,`isTemplate`,`priority`,`reportTitleId`,`reportDescId`,`reportMasterChangeSeqNum`,`reportLocalChangeSeqNum`,`reportLastChangedBy`,`reportLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Report entity) {
        statement.bindLong(1, entity.getReportUid());
        statement.bindLong(2, entity.getReportOwnerUid());
        statement.bindLong(3, entity.getXAxis());
        statement.bindLong(4, entity.getReportDateRangeSelection());
        statement.bindLong(5, entity.getFromDate());
        statement.bindLong(6, entity.getFromRelTo());
        statement.bindLong(7, entity.getFromRelOffSet());
        statement.bindLong(8, entity.getFromRelUnit());
        statement.bindLong(9, entity.getToDate());
        statement.bindLong(10, entity.getToRelTo());
        statement.bindLong(11, entity.getToRelOffSet());
        statement.bindLong(12, entity.getToRelUnit());
        if (entity.getReportTitle() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getReportTitle());
        }
        if (entity.getReportDescription() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getReportDescription());
        }
        if (entity.getReportSeries() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getReportSeries());
        }
        final int _tmp = entity.getReportInactive() ? 1 : 0;
        statement.bindLong(16, _tmp);
        final int _tmp_1 = entity.isTemplate() ? 1 : 0;
        statement.bindLong(17, _tmp_1);
        statement.bindLong(18, entity.getPriority());
        statement.bindLong(19, entity.getReportTitleId());
        statement.bindLong(20, entity.getReportDescId());
        statement.bindLong(21, entity.getReportMasterChangeSeqNum());
        statement.bindLong(22, entity.getReportLocalChangeSeqNum());
        statement.bindLong(23, entity.getReportLastChangedBy());
        statement.bindLong(24, entity.getReportLct());
      }
    };
    this.__updateAdapterOfReport = new EntityDeletionOrUpdateAdapter<Report>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Report` SET `reportUid` = ?,`reportOwnerUid` = ?,`xAxis` = ?,`reportDateRangeSelection` = ?,`fromDate` = ?,`fromRelTo` = ?,`fromRelOffSet` = ?,`fromRelUnit` = ?,`toDate` = ?,`toRelTo` = ?,`toRelOffSet` = ?,`toRelUnit` = ?,`reportTitle` = ?,`reportDescription` = ?,`reportSeries` = ?,`reportInactive` = ?,`isTemplate` = ?,`priority` = ?,`reportTitleId` = ?,`reportDescId` = ?,`reportMasterChangeSeqNum` = ?,`reportLocalChangeSeqNum` = ?,`reportLastChangedBy` = ?,`reportLct` = ? WHERE `reportUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Report entity) {
        statement.bindLong(1, entity.getReportUid());
        statement.bindLong(2, entity.getReportOwnerUid());
        statement.bindLong(3, entity.getXAxis());
        statement.bindLong(4, entity.getReportDateRangeSelection());
        statement.bindLong(5, entity.getFromDate());
        statement.bindLong(6, entity.getFromRelTo());
        statement.bindLong(7, entity.getFromRelOffSet());
        statement.bindLong(8, entity.getFromRelUnit());
        statement.bindLong(9, entity.getToDate());
        statement.bindLong(10, entity.getToRelTo());
        statement.bindLong(11, entity.getToRelOffSet());
        statement.bindLong(12, entity.getToRelUnit());
        if (entity.getReportTitle() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getReportTitle());
        }
        if (entity.getReportDescription() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getReportDescription());
        }
        if (entity.getReportSeries() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getReportSeries());
        }
        final int _tmp = entity.getReportInactive() ? 1 : 0;
        statement.bindLong(16, _tmp);
        final int _tmp_1 = entity.isTemplate() ? 1 : 0;
        statement.bindLong(17, _tmp_1);
        statement.bindLong(18, entity.getPriority());
        statement.bindLong(19, entity.getReportTitleId());
        statement.bindLong(20, entity.getReportDescId());
        statement.bindLong(21, entity.getReportMasterChangeSeqNum());
        statement.bindLong(22, entity.getReportLocalChangeSeqNum());
        statement.bindLong(23, entity.getReportLastChangedBy());
        statement.bindLong(24, entity.getReportLct());
        statement.bindLong(25, entity.getReportUid());
      }
    };
  }

  @Override
  public long insert(final Report entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfReport.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Report entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfReport.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Report> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfReport.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void replaceList(final List<? extends Report> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfReport_1.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Report entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfReport.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Report entity, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfReport.handle(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, Report> findAllActiveReport(final String searchBit,
      final long personUid, final int sortOrder, final boolean isTemplate) {
    final String _sql = "SELECT * FROM REPORT WHERE NOT reportInactive \n"
            + "        AND reportOwnerUid = ?\n"
            + "        AND isTemplate = ?\n"
            + "        AND reportTitle LIKE ?\n"
            + "        ORDER BY priority, CASE(?)\n"
            + "            WHEN 1 THEN Report.reportTitle\n"
            + "            ELSE ''\n"
            + "        END ASC,\n"
            + "        CASE(?)\n"
            + "            WHEN 2 THEN Report.reportTitle\n"
            + "            ELSE ''\n"
            + "        END DESC\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    final int _tmp = isTemplate ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 3;
    _statement.bindString(_argIndex, searchBit);
    _argIndex = 4;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 5;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<Report>(_statement, __db, "REPORT") {
      @Override
      @NonNull
      protected List<Report> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(cursor, "reportUid");
        final int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow(cursor, "reportOwnerUid");
        final int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow(cursor, "xAxis");
        final int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow(cursor, "reportDateRangeSelection");
        final int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow(cursor, "fromDate");
        final int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow(cursor, "fromRelTo");
        final int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow(cursor, "fromRelOffSet");
        final int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow(cursor, "fromRelUnit");
        final int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow(cursor, "toDate");
        final int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow(cursor, "toRelTo");
        final int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow(cursor, "toRelOffSet");
        final int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow(cursor, "toRelUnit");
        final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(cursor, "reportTitle");
        final int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow(cursor, "reportDescription");
        final int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow(cursor, "reportSeries");
        final int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow(cursor, "reportInactive");
        final int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow(cursor, "isTemplate");
        final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(cursor, "priority");
        final int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow(cursor, "reportTitleId");
        final int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow(cursor, "reportDescId");
        final int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "reportMasterChangeSeqNum");
        final int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "reportLocalChangeSeqNum");
        final int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "reportLastChangedBy");
        final int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow(cursor, "reportLct");
        final List<Report> _result = new ArrayList<Report>(cursor.getCount());
        while (cursor.moveToNext()) {
          final Report _item;
          _item = new Report();
          final long _tmpReportUid;
          _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
          _item.setReportUid(_tmpReportUid);
          final long _tmpReportOwnerUid;
          _tmpReportOwnerUid = cursor.getLong(_cursorIndexOfReportOwnerUid);
          _item.setReportOwnerUid(_tmpReportOwnerUid);
          final int _tmpXAxis;
          _tmpXAxis = cursor.getInt(_cursorIndexOfXAxis);
          _item.setXAxis(_tmpXAxis);
          final int _tmpReportDateRangeSelection;
          _tmpReportDateRangeSelection = cursor.getInt(_cursorIndexOfReportDateRangeSelection);
          _item.setReportDateRangeSelection(_tmpReportDateRangeSelection);
          final long _tmpFromDate;
          _tmpFromDate = cursor.getLong(_cursorIndexOfFromDate);
          _item.setFromDate(_tmpFromDate);
          final int _tmpFromRelTo;
          _tmpFromRelTo = cursor.getInt(_cursorIndexOfFromRelTo);
          _item.setFromRelTo(_tmpFromRelTo);
          final int _tmpFromRelOffSet;
          _tmpFromRelOffSet = cursor.getInt(_cursorIndexOfFromRelOffSet);
          _item.setFromRelOffSet(_tmpFromRelOffSet);
          final int _tmpFromRelUnit;
          _tmpFromRelUnit = cursor.getInt(_cursorIndexOfFromRelUnit);
          _item.setFromRelUnit(_tmpFromRelUnit);
          final long _tmpToDate;
          _tmpToDate = cursor.getLong(_cursorIndexOfToDate);
          _item.setToDate(_tmpToDate);
          final int _tmpToRelTo;
          _tmpToRelTo = cursor.getInt(_cursorIndexOfToRelTo);
          _item.setToRelTo(_tmpToRelTo);
          final int _tmpToRelOffSet;
          _tmpToRelOffSet = cursor.getInt(_cursorIndexOfToRelOffSet);
          _item.setToRelOffSet(_tmpToRelOffSet);
          final int _tmpToRelUnit;
          _tmpToRelUnit = cursor.getInt(_cursorIndexOfToRelUnit);
          _item.setToRelUnit(_tmpToRelUnit);
          final String _tmpReportTitle;
          if (cursor.isNull(_cursorIndexOfReportTitle)) {
            _tmpReportTitle = null;
          } else {
            _tmpReportTitle = cursor.getString(_cursorIndexOfReportTitle);
          }
          _item.setReportTitle(_tmpReportTitle);
          final String _tmpReportDescription;
          if (cursor.isNull(_cursorIndexOfReportDescription)) {
            _tmpReportDescription = null;
          } else {
            _tmpReportDescription = cursor.getString(_cursorIndexOfReportDescription);
          }
          _item.setReportDescription(_tmpReportDescription);
          final String _tmpReportSeries;
          if (cursor.isNull(_cursorIndexOfReportSeries)) {
            _tmpReportSeries = null;
          } else {
            _tmpReportSeries = cursor.getString(_cursorIndexOfReportSeries);
          }
          _item.setReportSeries(_tmpReportSeries);
          final boolean _tmpReportInactive;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfReportInactive);
          _tmpReportInactive = _tmp_1 != 0;
          _item.setReportInactive(_tmpReportInactive);
          final boolean _tmpIsTemplate;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfIsTemplate);
          _tmpIsTemplate = _tmp_2 != 0;
          _item.setTemplate(_tmpIsTemplate);
          final int _tmpPriority;
          _tmpPriority = cursor.getInt(_cursorIndexOfPriority);
          _item.setPriority(_tmpPriority);
          final int _tmpReportTitleId;
          _tmpReportTitleId = cursor.getInt(_cursorIndexOfReportTitleId);
          _item.setReportTitleId(_tmpReportTitleId);
          final int _tmpReportDescId;
          _tmpReportDescId = cursor.getInt(_cursorIndexOfReportDescId);
          _item.setReportDescId(_tmpReportDescId);
          final long _tmpReportMasterChangeSeqNum;
          _tmpReportMasterChangeSeqNum = cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
          _item.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
          final long _tmpReportLocalChangeSeqNum;
          _tmpReportLocalChangeSeqNum = cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
          _item.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
          final int _tmpReportLastChangedBy;
          _tmpReportLastChangedBy = cursor.getInt(_cursorIndexOfReportLastChangedBy);
          _item.setReportLastChangedBy(_tmpReportLastChangedBy);
          final long _tmpReportLct;
          _tmpReportLct = cursor.getLong(_cursorIndexOfReportLct);
          _item.setReportLct(_tmpReportLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findByUid(final long entityUid, final Continuation<? super Report> $completion) {
    final String _sql = "SELECT * FROM Report WHERE reportUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Report>() {
      @Override
      @Nullable
      public Report call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
          final int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerUid");
          final int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow(_cursor, "xAxis");
          final int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDateRangeSelection");
          final int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow(_cursor, "fromDate");
          final int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelTo");
          final int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelOffSet");
          final int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelUnit");
          final int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow(_cursor, "toDate");
          final int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelTo");
          final int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelOffSet");
          final int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelUnit");
          final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
          final int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescription");
          final int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow(_cursor, "reportSeries");
          final int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "reportInactive");
          final int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "isTemplate");
          final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
          final int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitleId");
          final int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescId");
          final int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportMasterChangeSeqNum");
          final int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLocalChangeSeqNum");
          final int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastChangedBy");
          final int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLct");
          final Report _result;
          if (_cursor.moveToFirst()) {
            _result = new Report();
            final long _tmpReportUid;
            _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
            _result.setReportUid(_tmpReportUid);
            final long _tmpReportOwnerUid;
            _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
            _result.setReportOwnerUid(_tmpReportOwnerUid);
            final int _tmpXAxis;
            _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
            _result.setXAxis(_tmpXAxis);
            final int _tmpReportDateRangeSelection;
            _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
            _result.setReportDateRangeSelection(_tmpReportDateRangeSelection);
            final long _tmpFromDate;
            _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
            _result.setFromDate(_tmpFromDate);
            final int _tmpFromRelTo;
            _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
            _result.setFromRelTo(_tmpFromRelTo);
            final int _tmpFromRelOffSet;
            _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
            _result.setFromRelOffSet(_tmpFromRelOffSet);
            final int _tmpFromRelUnit;
            _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
            _result.setFromRelUnit(_tmpFromRelUnit);
            final long _tmpToDate;
            _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
            _result.setToDate(_tmpToDate);
            final int _tmpToRelTo;
            _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
            _result.setToRelTo(_tmpToRelTo);
            final int _tmpToRelOffSet;
            _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
            _result.setToRelOffSet(_tmpToRelOffSet);
            final int _tmpToRelUnit;
            _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
            _result.setToRelUnit(_tmpToRelUnit);
            final String _tmpReportTitle;
            if (_cursor.isNull(_cursorIndexOfReportTitle)) {
              _tmpReportTitle = null;
            } else {
              _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
            }
            _result.setReportTitle(_tmpReportTitle);
            final String _tmpReportDescription;
            if (_cursor.isNull(_cursorIndexOfReportDescription)) {
              _tmpReportDescription = null;
            } else {
              _tmpReportDescription = _cursor.getString(_cursorIndexOfReportDescription);
            }
            _result.setReportDescription(_tmpReportDescription);
            final String _tmpReportSeries;
            if (_cursor.isNull(_cursorIndexOfReportSeries)) {
              _tmpReportSeries = null;
            } else {
              _tmpReportSeries = _cursor.getString(_cursorIndexOfReportSeries);
            }
            _result.setReportSeries(_tmpReportSeries);
            final boolean _tmpReportInactive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfReportInactive);
            _tmpReportInactive = _tmp != 0;
            _result.setReportInactive(_tmpReportInactive);
            final boolean _tmpIsTemplate;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsTemplate);
            _tmpIsTemplate = _tmp_1 != 0;
            _result.setTemplate(_tmpIsTemplate);
            final int _tmpPriority;
            _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
            _result.setPriority(_tmpPriority);
            final int _tmpReportTitleId;
            _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
            _result.setReportTitleId(_tmpReportTitleId);
            final int _tmpReportDescId;
            _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
            _result.setReportDescId(_tmpReportDescId);
            final long _tmpReportMasterChangeSeqNum;
            _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
            _result.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
            final long _tmpReportLocalChangeSeqNum;
            _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
            _result.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
            final int _tmpReportLastChangedBy;
            _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
            _result.setReportLastChangedBy(_tmpReportLastChangedBy);
            final long _tmpReportLct;
            _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
            _result.setReportLct(_tmpReportLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Report> findByUidLive(final long uid) {
    final String _sql = "SELECT * From Report WHERE  reportUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Report"}, new Callable<Report>() {
      @Override
      @Nullable
      public Report call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
          final int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerUid");
          final int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow(_cursor, "xAxis");
          final int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDateRangeSelection");
          final int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow(_cursor, "fromDate");
          final int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelTo");
          final int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelOffSet");
          final int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelUnit");
          final int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow(_cursor, "toDate");
          final int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelTo");
          final int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelOffSet");
          final int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelUnit");
          final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
          final int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescription");
          final int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow(_cursor, "reportSeries");
          final int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "reportInactive");
          final int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "isTemplate");
          final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
          final int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitleId");
          final int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescId");
          final int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportMasterChangeSeqNum");
          final int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLocalChangeSeqNum");
          final int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastChangedBy");
          final int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLct");
          final Report _result;
          if (_cursor.moveToFirst()) {
            _result = new Report();
            final long _tmpReportUid;
            _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
            _result.setReportUid(_tmpReportUid);
            final long _tmpReportOwnerUid;
            _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
            _result.setReportOwnerUid(_tmpReportOwnerUid);
            final int _tmpXAxis;
            _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
            _result.setXAxis(_tmpXAxis);
            final int _tmpReportDateRangeSelection;
            _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
            _result.setReportDateRangeSelection(_tmpReportDateRangeSelection);
            final long _tmpFromDate;
            _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
            _result.setFromDate(_tmpFromDate);
            final int _tmpFromRelTo;
            _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
            _result.setFromRelTo(_tmpFromRelTo);
            final int _tmpFromRelOffSet;
            _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
            _result.setFromRelOffSet(_tmpFromRelOffSet);
            final int _tmpFromRelUnit;
            _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
            _result.setFromRelUnit(_tmpFromRelUnit);
            final long _tmpToDate;
            _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
            _result.setToDate(_tmpToDate);
            final int _tmpToRelTo;
            _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
            _result.setToRelTo(_tmpToRelTo);
            final int _tmpToRelOffSet;
            _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
            _result.setToRelOffSet(_tmpToRelOffSet);
            final int _tmpToRelUnit;
            _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
            _result.setToRelUnit(_tmpToRelUnit);
            final String _tmpReportTitle;
            if (_cursor.isNull(_cursorIndexOfReportTitle)) {
              _tmpReportTitle = null;
            } else {
              _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
            }
            _result.setReportTitle(_tmpReportTitle);
            final String _tmpReportDescription;
            if (_cursor.isNull(_cursorIndexOfReportDescription)) {
              _tmpReportDescription = null;
            } else {
              _tmpReportDescription = _cursor.getString(_cursorIndexOfReportDescription);
            }
            _result.setReportDescription(_tmpReportDescription);
            final String _tmpReportSeries;
            if (_cursor.isNull(_cursorIndexOfReportSeries)) {
              _tmpReportSeries = null;
            } else {
              _tmpReportSeries = _cursor.getString(_cursorIndexOfReportSeries);
            }
            _result.setReportSeries(_tmpReportSeries);
            final boolean _tmpReportInactive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfReportInactive);
            _tmpReportInactive = _tmp != 0;
            _result.setReportInactive(_tmpReportInactive);
            final boolean _tmpIsTemplate;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsTemplate);
            _tmpIsTemplate = _tmp_1 != 0;
            _result.setTemplate(_tmpIsTemplate);
            final int _tmpPriority;
            _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
            _result.setPriority(_tmpPriority);
            final int _tmpReportTitleId;
            _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
            _result.setReportTitleId(_tmpReportTitleId);
            final int _tmpReportDescId;
            _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
            _result.setReportDescId(_tmpReportDescId);
            final long _tmpReportMasterChangeSeqNum;
            _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
            _result.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
            final long _tmpReportLocalChangeSeqNum;
            _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
            _result.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
            final int _tmpReportLastChangedBy;
            _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
            _result.setReportLastChangedBy(_tmpReportLastChangedBy);
            final long _tmpReportLct;
            _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
            _result.setReportLct(_tmpReportLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<Report>> findAllActiveReportLive(final boolean isTemplate) {
    final String _sql = "SELECT * FROM REPORT WHERE NOT reportInactive \n"
            + "        AND isTemplate = ?\n"
            + "        ORDER BY priority ASC\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = isTemplate ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"REPORT"}, new Callable<List<Report>>() {
      @Override
      @NonNull
      public List<Report> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
          final int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerUid");
          final int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow(_cursor, "xAxis");
          final int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDateRangeSelection");
          final int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow(_cursor, "fromDate");
          final int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelTo");
          final int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelOffSet");
          final int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelUnit");
          final int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow(_cursor, "toDate");
          final int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelTo");
          final int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelOffSet");
          final int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelUnit");
          final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
          final int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescription");
          final int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow(_cursor, "reportSeries");
          final int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "reportInactive");
          final int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "isTemplate");
          final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
          final int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitleId");
          final int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescId");
          final int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportMasterChangeSeqNum");
          final int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLocalChangeSeqNum");
          final int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastChangedBy");
          final int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLct");
          final List<Report> _result = new ArrayList<Report>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Report _item;
            _item = new Report();
            final long _tmpReportUid;
            _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
            _item.setReportUid(_tmpReportUid);
            final long _tmpReportOwnerUid;
            _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
            _item.setReportOwnerUid(_tmpReportOwnerUid);
            final int _tmpXAxis;
            _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
            _item.setXAxis(_tmpXAxis);
            final int _tmpReportDateRangeSelection;
            _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
            _item.setReportDateRangeSelection(_tmpReportDateRangeSelection);
            final long _tmpFromDate;
            _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
            _item.setFromDate(_tmpFromDate);
            final int _tmpFromRelTo;
            _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
            _item.setFromRelTo(_tmpFromRelTo);
            final int _tmpFromRelOffSet;
            _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
            _item.setFromRelOffSet(_tmpFromRelOffSet);
            final int _tmpFromRelUnit;
            _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
            _item.setFromRelUnit(_tmpFromRelUnit);
            final long _tmpToDate;
            _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
            _item.setToDate(_tmpToDate);
            final int _tmpToRelTo;
            _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
            _item.setToRelTo(_tmpToRelTo);
            final int _tmpToRelOffSet;
            _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
            _item.setToRelOffSet(_tmpToRelOffSet);
            final int _tmpToRelUnit;
            _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
            _item.setToRelUnit(_tmpToRelUnit);
            final String _tmpReportTitle;
            if (_cursor.isNull(_cursorIndexOfReportTitle)) {
              _tmpReportTitle = null;
            } else {
              _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
            }
            _item.setReportTitle(_tmpReportTitle);
            final String _tmpReportDescription;
            if (_cursor.isNull(_cursorIndexOfReportDescription)) {
              _tmpReportDescription = null;
            } else {
              _tmpReportDescription = _cursor.getString(_cursorIndexOfReportDescription);
            }
            _item.setReportDescription(_tmpReportDescription);
            final String _tmpReportSeries;
            if (_cursor.isNull(_cursorIndexOfReportSeries)) {
              _tmpReportSeries = null;
            } else {
              _tmpReportSeries = _cursor.getString(_cursorIndexOfReportSeries);
            }
            _item.setReportSeries(_tmpReportSeries);
            final boolean _tmpReportInactive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfReportInactive);
            _tmpReportInactive = _tmp_1 != 0;
            _item.setReportInactive(_tmpReportInactive);
            final boolean _tmpIsTemplate;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfIsTemplate);
            _tmpIsTemplate = _tmp_2 != 0;
            _item.setTemplate(_tmpIsTemplate);
            final int _tmpPriority;
            _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
            _item.setPriority(_tmpPriority);
            final int _tmpReportTitleId;
            _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
            _item.setReportTitleId(_tmpReportTitleId);
            final int _tmpReportDescId;
            _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
            _item.setReportDescId(_tmpReportDescId);
            final long _tmpReportMasterChangeSeqNum;
            _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
            _item.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
            final long _tmpReportLocalChangeSeqNum;
            _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
            _item.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
            final int _tmpReportLastChangedBy;
            _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
            _item.setReportLastChangedBy(_tmpReportLastChangedBy);
            final long _tmpReportLct;
            _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
            _item.setReportLct(_tmpReportLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Report> findAllActiveReportList(final boolean isTemplate) {
    final String _sql = "SELECT * FROM REPORT WHERE NOT reportInactive \n"
            + "        AND isTemplate = ?\n"
            + "        ORDER BY priority ASC\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = isTemplate ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
      final int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerUid");
      final int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow(_cursor, "xAxis");
      final int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDateRangeSelection");
      final int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow(_cursor, "fromDate");
      final int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelTo");
      final int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelOffSet");
      final int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "fromRelUnit");
      final int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow(_cursor, "toDate");
      final int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelTo");
      final int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelOffSet");
      final int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow(_cursor, "toRelUnit");
      final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
      final int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescription");
      final int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow(_cursor, "reportSeries");
      final int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "reportInactive");
      final int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "isTemplate");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "priority");
      final int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitleId");
      final int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow(_cursor, "reportDescId");
      final int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportMasterChangeSeqNum");
      final int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLocalChangeSeqNum");
      final int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastChangedBy");
      final int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLct");
      final List<Report> _result = new ArrayList<Report>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Report _item;
        _item = new Report();
        final long _tmpReportUid;
        _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
        _item.setReportUid(_tmpReportUid);
        final long _tmpReportOwnerUid;
        _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
        _item.setReportOwnerUid(_tmpReportOwnerUid);
        final int _tmpXAxis;
        _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
        _item.setXAxis(_tmpXAxis);
        final int _tmpReportDateRangeSelection;
        _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
        _item.setReportDateRangeSelection(_tmpReportDateRangeSelection);
        final long _tmpFromDate;
        _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
        _item.setFromDate(_tmpFromDate);
        final int _tmpFromRelTo;
        _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
        _item.setFromRelTo(_tmpFromRelTo);
        final int _tmpFromRelOffSet;
        _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
        _item.setFromRelOffSet(_tmpFromRelOffSet);
        final int _tmpFromRelUnit;
        _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
        _item.setFromRelUnit(_tmpFromRelUnit);
        final long _tmpToDate;
        _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
        _item.setToDate(_tmpToDate);
        final int _tmpToRelTo;
        _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
        _item.setToRelTo(_tmpToRelTo);
        final int _tmpToRelOffSet;
        _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
        _item.setToRelOffSet(_tmpToRelOffSet);
        final int _tmpToRelUnit;
        _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
        _item.setToRelUnit(_tmpToRelUnit);
        final String _tmpReportTitle;
        if (_cursor.isNull(_cursorIndexOfReportTitle)) {
          _tmpReportTitle = null;
        } else {
          _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
        }
        _item.setReportTitle(_tmpReportTitle);
        final String _tmpReportDescription;
        if (_cursor.isNull(_cursorIndexOfReportDescription)) {
          _tmpReportDescription = null;
        } else {
          _tmpReportDescription = _cursor.getString(_cursorIndexOfReportDescription);
        }
        _item.setReportDescription(_tmpReportDescription);
        final String _tmpReportSeries;
        if (_cursor.isNull(_cursorIndexOfReportSeries)) {
          _tmpReportSeries = null;
        } else {
          _tmpReportSeries = _cursor.getString(_cursorIndexOfReportSeries);
        }
        _item.setReportSeries(_tmpReportSeries);
        final boolean _tmpReportInactive;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfReportInactive);
        _tmpReportInactive = _tmp_1 != 0;
        _item.setReportInactive(_tmpReportInactive);
        final boolean _tmpIsTemplate;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfIsTemplate);
        _tmpIsTemplate = _tmp_2 != 0;
        _item.setTemplate(_tmpIsTemplate);
        final int _tmpPriority;
        _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
        _item.setPriority(_tmpPriority);
        final int _tmpReportTitleId;
        _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
        _item.setReportTitleId(_tmpReportTitleId);
        final int _tmpReportDescId;
        _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
        _item.setReportDescId(_tmpReportDescId);
        final long _tmpReportMasterChangeSeqNum;
        _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
        _item.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
        final long _tmpReportLocalChangeSeqNum;
        _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
        _item.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
        final int _tmpReportLastChangedBy;
        _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
        _item.setReportLastChangedBy(_tmpReportLastChangedBy);
        final long _tmpReportLct;
        _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
        _item.setReportLct(_tmpReportLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<Long> findByUidList(final List<Long> uidList) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT reportUid FROM Report WHERE reportUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Long _item_1;
        _item_1 = _cursor.getLong(0);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object toggleVisibilityReportItems(final boolean toggleVisibility,
      final List<Long> selectedItem, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE Report ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           SET reportInactive = ");
        _stringBuilder.append("?");
        _stringBuilder.append(",");
        _stringBuilder.append("\n");
        _stringBuilder.append("               reportLct = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE reportUid IN (");
        final int _inputSize = selectedItem.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final int _tmp = toggleVisibility ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        for (long _item : selectedItem) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public List<Report> getResults(final SupportSQLiteQuery query) {
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, query, false, null);
    try {
      final List<Report> _result = new ArrayList<Report>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Report _item;
        _item = __entityCursorConverter_comUstadmobileLibDbEntitiesReport(_cursor);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private Report __entityCursorConverter_comUstadmobileLibDbEntitiesReport(
      @NonNull final Cursor cursor) {
    final Report _entity;
    final int _cursorIndexOfReportUid = CursorUtil.getColumnIndex(cursor, "reportUid");
    final int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndex(cursor, "reportOwnerUid");
    final int _cursorIndexOfXAxis = CursorUtil.getColumnIndex(cursor, "xAxis");
    final int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndex(cursor, "reportDateRangeSelection");
    final int _cursorIndexOfFromDate = CursorUtil.getColumnIndex(cursor, "fromDate");
    final int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndex(cursor, "fromRelTo");
    final int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndex(cursor, "fromRelOffSet");
    final int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndex(cursor, "fromRelUnit");
    final int _cursorIndexOfToDate = CursorUtil.getColumnIndex(cursor, "toDate");
    final int _cursorIndexOfToRelTo = CursorUtil.getColumnIndex(cursor, "toRelTo");
    final int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndex(cursor, "toRelOffSet");
    final int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndex(cursor, "toRelUnit");
    final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndex(cursor, "reportTitle");
    final int _cursorIndexOfReportDescription = CursorUtil.getColumnIndex(cursor, "reportDescription");
    final int _cursorIndexOfReportSeries = CursorUtil.getColumnIndex(cursor, "reportSeries");
    final int _cursorIndexOfReportInactive = CursorUtil.getColumnIndex(cursor, "reportInactive");
    final int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndex(cursor, "isTemplate");
    final int _cursorIndexOfPriority = CursorUtil.getColumnIndex(cursor, "priority");
    final int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndex(cursor, "reportTitleId");
    final int _cursorIndexOfReportDescId = CursorUtil.getColumnIndex(cursor, "reportDescId");
    final int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndex(cursor, "reportMasterChangeSeqNum");
    final int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndex(cursor, "reportLocalChangeSeqNum");
    final int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndex(cursor, "reportLastChangedBy");
    final int _cursorIndexOfReportLct = CursorUtil.getColumnIndex(cursor, "reportLct");
    _entity = new Report();
    if (_cursorIndexOfReportUid != -1) {
      final long _tmpReportUid;
      _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
      _entity.setReportUid(_tmpReportUid);
    }
    if (_cursorIndexOfReportOwnerUid != -1) {
      final long _tmpReportOwnerUid;
      _tmpReportOwnerUid = cursor.getLong(_cursorIndexOfReportOwnerUid);
      _entity.setReportOwnerUid(_tmpReportOwnerUid);
    }
    if (_cursorIndexOfXAxis != -1) {
      final int _tmpXAxis;
      _tmpXAxis = cursor.getInt(_cursorIndexOfXAxis);
      _entity.setXAxis(_tmpXAxis);
    }
    if (_cursorIndexOfReportDateRangeSelection != -1) {
      final int _tmpReportDateRangeSelection;
      _tmpReportDateRangeSelection = cursor.getInt(_cursorIndexOfReportDateRangeSelection);
      _entity.setReportDateRangeSelection(_tmpReportDateRangeSelection);
    }
    if (_cursorIndexOfFromDate != -1) {
      final long _tmpFromDate;
      _tmpFromDate = cursor.getLong(_cursorIndexOfFromDate);
      _entity.setFromDate(_tmpFromDate);
    }
    if (_cursorIndexOfFromRelTo != -1) {
      final int _tmpFromRelTo;
      _tmpFromRelTo = cursor.getInt(_cursorIndexOfFromRelTo);
      _entity.setFromRelTo(_tmpFromRelTo);
    }
    if (_cursorIndexOfFromRelOffSet != -1) {
      final int _tmpFromRelOffSet;
      _tmpFromRelOffSet = cursor.getInt(_cursorIndexOfFromRelOffSet);
      _entity.setFromRelOffSet(_tmpFromRelOffSet);
    }
    if (_cursorIndexOfFromRelUnit != -1) {
      final int _tmpFromRelUnit;
      _tmpFromRelUnit = cursor.getInt(_cursorIndexOfFromRelUnit);
      _entity.setFromRelUnit(_tmpFromRelUnit);
    }
    if (_cursorIndexOfToDate != -1) {
      final long _tmpToDate;
      _tmpToDate = cursor.getLong(_cursorIndexOfToDate);
      _entity.setToDate(_tmpToDate);
    }
    if (_cursorIndexOfToRelTo != -1) {
      final int _tmpToRelTo;
      _tmpToRelTo = cursor.getInt(_cursorIndexOfToRelTo);
      _entity.setToRelTo(_tmpToRelTo);
    }
    if (_cursorIndexOfToRelOffSet != -1) {
      final int _tmpToRelOffSet;
      _tmpToRelOffSet = cursor.getInt(_cursorIndexOfToRelOffSet);
      _entity.setToRelOffSet(_tmpToRelOffSet);
    }
    if (_cursorIndexOfToRelUnit != -1) {
      final int _tmpToRelUnit;
      _tmpToRelUnit = cursor.getInt(_cursorIndexOfToRelUnit);
      _entity.setToRelUnit(_tmpToRelUnit);
    }
    if (_cursorIndexOfReportTitle != -1) {
      final String _tmpReportTitle;
      if (cursor.isNull(_cursorIndexOfReportTitle)) {
        _tmpReportTitle = null;
      } else {
        _tmpReportTitle = cursor.getString(_cursorIndexOfReportTitle);
      }
      _entity.setReportTitle(_tmpReportTitle);
    }
    if (_cursorIndexOfReportDescription != -1) {
      final String _tmpReportDescription;
      if (cursor.isNull(_cursorIndexOfReportDescription)) {
        _tmpReportDescription = null;
      } else {
        _tmpReportDescription = cursor.getString(_cursorIndexOfReportDescription);
      }
      _entity.setReportDescription(_tmpReportDescription);
    }
    if (_cursorIndexOfReportSeries != -1) {
      final String _tmpReportSeries;
      if (cursor.isNull(_cursorIndexOfReportSeries)) {
        _tmpReportSeries = null;
      } else {
        _tmpReportSeries = cursor.getString(_cursorIndexOfReportSeries);
      }
      _entity.setReportSeries(_tmpReportSeries);
    }
    if (_cursorIndexOfReportInactive != -1) {
      final boolean _tmpReportInactive;
      final int _tmp;
      _tmp = cursor.getInt(_cursorIndexOfReportInactive);
      _tmpReportInactive = _tmp != 0;
      _entity.setReportInactive(_tmpReportInactive);
    }
    if (_cursorIndexOfIsTemplate != -1) {
      final boolean _tmpIsTemplate;
      final int _tmp_1;
      _tmp_1 = cursor.getInt(_cursorIndexOfIsTemplate);
      _tmpIsTemplate = _tmp_1 != 0;
      _entity.setTemplate(_tmpIsTemplate);
    }
    if (_cursorIndexOfPriority != -1) {
      final int _tmpPriority;
      _tmpPriority = cursor.getInt(_cursorIndexOfPriority);
      _entity.setPriority(_tmpPriority);
    }
    if (_cursorIndexOfReportTitleId != -1) {
      final int _tmpReportTitleId;
      _tmpReportTitleId = cursor.getInt(_cursorIndexOfReportTitleId);
      _entity.setReportTitleId(_tmpReportTitleId);
    }
    if (_cursorIndexOfReportDescId != -1) {
      final int _tmpReportDescId;
      _tmpReportDescId = cursor.getInt(_cursorIndexOfReportDescId);
      _entity.setReportDescId(_tmpReportDescId);
    }
    if (_cursorIndexOfReportMasterChangeSeqNum != -1) {
      final long _tmpReportMasterChangeSeqNum;
      _tmpReportMasterChangeSeqNum = cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
      _entity.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
    }
    if (_cursorIndexOfReportLocalChangeSeqNum != -1) {
      final long _tmpReportLocalChangeSeqNum;
      _tmpReportLocalChangeSeqNum = cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
      _entity.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
    }
    if (_cursorIndexOfReportLastChangedBy != -1) {
      final int _tmpReportLastChangedBy;
      _tmpReportLastChangedBy = cursor.getInt(_cursorIndexOfReportLastChangedBy);
      _entity.setReportLastChangedBy(_tmpReportLastChangedBy);
    }
    if (_cursorIndexOfReportLct != -1) {
      final long _tmpReportLct;
      _tmpReportLct = cursor.getLong(_cursorIndexOfReportLct);
      _entity.setReportLct(_tmpReportLct);
    }
    return _entity;
  }
}
