package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.EditAndViewPermission;
import com.ustadmobile.lib.db.composites.PermissionPair;
import com.ustadmobile.lib.db.entities.SystemPermission;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class SystemPermissionDao_Impl extends SystemPermissionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<SystemPermission> __insertionAdapterOfSystemPermission;

  public SystemPermissionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSystemPermission = new EntityInsertionAdapter<SystemPermission>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `SystemPermission` (`spUid`,`spToPersonUid`,`spToGroupUid`,`spPermissionsFlag`,`spLastModified`,`spIsDeleted`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final SystemPermission entity) {
        statement.bindLong(1, entity.getSpUid());
        statement.bindLong(2, entity.getSpToPersonUid());
        statement.bindLong(3, entity.getSpToGroupUid());
        statement.bindLong(4, entity.getSpPermissionsFlag());
        statement.bindLong(5, entity.getSpLastModified());
        final int _tmp = entity.getSpIsDeleted() ? 1 : 0;
        statement.bindLong(6, _tmp);
      }
    };
  }

  @Override
  public Object upsertAsync(final SystemPermission systemPermissions,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSystemPermission.insert(systemPermissions);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllByPersonUid(final long accountPersonUid, final boolean includeDeleted,
      final Continuation<? super List<SystemPermission>> $completion) {
    final String _sql = "\n"
            + "        SELECT SystemPermission.*\n"
            + "          FROM SystemPermission\n"
            + "         WHERE SystemPermission.spToPersonUid = ?\n"
            + "           AND (CAST(? AS INTEGER) = 1 OR NOT SystemPermission.spIsDeleted)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SystemPermission>>() {
      @Override
      @NonNull
      public List<SystemPermission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spUid");
          final int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToPersonUid");
          final int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToGroupUid");
          final int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "spPermissionsFlag");
          final int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "spLastModified");
          final int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "spIsDeleted");
          final List<SystemPermission> _result = new ArrayList<SystemPermission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final SystemPermission _item;
            final long _tmpSpUid;
            _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
            final long _tmpSpToPersonUid;
            _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
            final long _tmpSpToGroupUid;
            _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
            final long _tmpSpPermissionsFlag;
            _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
            final long _tmpSpLastModified;
            _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
            final boolean _tmpSpIsDeleted;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSpIsDeleted);
            _tmpSpIsDeleted = _tmp_1 != 0;
            _item = new SystemPermission(_tmpSpUid,_tmpSpToPersonUid,_tmpSpToGroupUid,_tmpSpPermissionsFlag,_tmpSpLastModified,_tmpSpIsDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllByPersonUidEntities(final long accountPersonUid,
      final Continuation<? super List<SystemPermission>> $completion) {
    final String _sql = "\n"
            + "        SELECT SystemPermission.*\n"
            + "          FROM SystemPermission\n"
            + "         WHERE SystemPermission.spToPersonUid = ?\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SystemPermission>>() {
      @Override
      @NonNull
      public List<SystemPermission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spUid");
          final int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToPersonUid");
          final int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToGroupUid");
          final int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "spPermissionsFlag");
          final int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "spLastModified");
          final int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "spIsDeleted");
          final List<SystemPermission> _result = new ArrayList<SystemPermission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final SystemPermission _item;
            final long _tmpSpUid;
            _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
            final long _tmpSpToPersonUid;
            _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
            final long _tmpSpToGroupUid;
            _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
            final long _tmpSpPermissionsFlag;
            _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
            final long _tmpSpLastModified;
            _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
            final boolean _tmpSpIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSpIsDeleted);
            _tmpSpIsDeleted = _tmp != 0;
            _item = new SystemPermission(_tmpSpUid,_tmpSpToPersonUid,_tmpSpToGroupUid,_tmpSpPermissionsFlag,_tmpSpLastModified,_tmpSpIsDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<SystemPermission> findByPersonUidAsFlow(final long accountPersonUid) {
    final String _sql = "\n"
            + "        SELECT SystemPermission.*\n"
            + "          FROM SystemPermission\n"
            + "         WHERE SystemPermission.spToPersonUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"SystemPermission"}, new Callable<SystemPermission>() {
      @Override
      @Nullable
      public SystemPermission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spUid");
          final int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToPersonUid");
          final int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToGroupUid");
          final int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "spPermissionsFlag");
          final int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "spLastModified");
          final int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "spIsDeleted");
          final SystemPermission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpSpUid;
            _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
            final long _tmpSpToPersonUid;
            _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
            final long _tmpSpToGroupUid;
            _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
            final long _tmpSpPermissionsFlag;
            _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
            final long _tmpSpLastModified;
            _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
            final boolean _tmpSpIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSpIsDeleted);
            _tmpSpIsDeleted = _tmp != 0;
            _result = new SystemPermission(_tmpSpUid,_tmpSpToPersonUid,_tmpSpToGroupUid,_tmpSpPermissionsFlag,_tmpSpLastModified,_tmpSpIsDeleted);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByPersonUid(final long accountPersonUid,
      final Continuation<? super SystemPermission> $completion) {
    final String _sql = "\n"
            + "        SELECT SystemPermission.*\n"
            + "          FROM SystemPermission\n"
            + "         WHERE SystemPermission.spToPersonUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SystemPermission>() {
      @Override
      @NonNull
      public SystemPermission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spUid");
          final int _cursorIndexOfSpToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToPersonUid");
          final int _cursorIndexOfSpToGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "spToGroupUid");
          final int _cursorIndexOfSpPermissionsFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "spPermissionsFlag");
          final int _cursorIndexOfSpLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "spLastModified");
          final int _cursorIndexOfSpIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "spIsDeleted");
          final SystemPermission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpSpUid;
            _tmpSpUid = _cursor.getLong(_cursorIndexOfSpUid);
            final long _tmpSpToPersonUid;
            _tmpSpToPersonUid = _cursor.getLong(_cursorIndexOfSpToPersonUid);
            final long _tmpSpToGroupUid;
            _tmpSpToGroupUid = _cursor.getLong(_cursorIndexOfSpToGroupUid);
            final long _tmpSpPermissionsFlag;
            _tmpSpPermissionsFlag = _cursor.getLong(_cursorIndexOfSpPermissionsFlag);
            final long _tmpSpLastModified;
            _tmpSpLastModified = _cursor.getLong(_cursorIndexOfSpLastModified);
            final boolean _tmpSpIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSpIsDeleted);
            _tmpSpIsDeleted = _tmp != 0;
            _result = new SystemPermission(_tmpSpUid,_tmpSpToPersonUid,_tmpSpToGroupUid,_tmpSpPermissionsFlag,_tmpSpLastModified,_tmpSpIsDeleted);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object personHasSystemPermission(final long accountPersonUid, final long permission,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT \n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "          ?\n"
            + "        \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, permission);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Boolean> personHasSystemPermissionAsFlow(final long accountPersonUid,
      final long permission) {
    final String _sql = "\n"
            + "        SELECT \n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "          ?\n"
            + "        \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, permission);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"SystemPermission"}, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<PermissionPair> personHasSystemPermissionPairAsFlow(final long accountPersonUid,
      final long firstPermission, final long secondPermission) {
    final String _sql = "\n"
            + "        SELECT (\n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "                ?\n"
            + "                \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    ) as firstPermission,\n"
            + "                (\n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "                ?\n"
            + "                \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    ) as secondPermission\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, secondPermission);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"SystemPermission"}, new Callable<PermissionPair>() {
      @Override
      @NonNull
      public PermissionPair call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstPermission = 0;
          final int _cursorIndexOfSecondPermission = 1;
          final PermissionPair _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpFirstPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFirstPermission);
            _tmpFirstPermission = _tmp != 0;
            final boolean _tmpSecondPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSecondPermission);
            _tmpSecondPermission = _tmp_1 != 0;
            _result = new PermissionPair(_tmpFirstPermission,_tmpSecondPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object personHasSystemPermissionPair(final long accountPersonUid,
      final long firstPermission, final long secondPermission,
      final Continuation<? super PermissionPair> $completion) {
    final String _sql = "\n"
            + "        SELECT (\n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "                ?\n"
            + "                \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    ) as firstPermission,\n"
            + "                (\n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "                ?\n"
            + "                \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    ) as secondPermission\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, firstPermission);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, secondPermission);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PermissionPair>() {
      @Override
      @NonNull
      public PermissionPair call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstPermission = 0;
          final int _cursorIndexOfSecondPermission = 1;
          final PermissionPair _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpFirstPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfFirstPermission);
            _tmpFirstPermission = _tmp != 0;
            final boolean _tmpSecondPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSecondPermission);
            _tmpSecondPermission = _tmp_1 != 0;
            _result = new PermissionPair(_tmpFirstPermission,_tmpSecondPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<EditAndViewPermission> personHasEditAndViewPermissionForPersonAsFlow(
      final long accountPersonUid, final long otherPersonUid) {
    final String _sql = "\n"
            + "        /* Similar to the query used on list all persons, however it uses the the otherpersonuid param \n"
            + "         * in the WHERE clauses to narrow down the search. \n"
            + "         */\n"
            + "        WITH CanViewPersonUidsViaCoursePermission(personUid) AS\n"
            + "              /* Select personUids that can be viewed based on CoursePermission given to the active\n"
            + "               * user for their enrolment role in that course\n"
            + "              */\n"
            + "              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n"
            + "                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser\n"
            + "                      JOIN CoursePermission \n"
            + "                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid\n"
            + "                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole\n"
            + "                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n"
            + "                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n"
            + "                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = ?\n"
            + "                WHERE ? != 0\n"
            + "                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = ?\n"
            + "                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive\n"
            + "              \n"
            + "               UNION\n"
            + "               /* Select personUids that can be viewed based on CoursePermission for the active user\n"
            + "                  where the CoursePermission is granted directly to them\n"
            + "                */   \n"
            + "               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n"
            + "                 FROM CoursePermission\n"
            + "                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n"
            + "                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = ?\n"
            + "                WHERE ? != 0\n"
            + "                  AND CoursePermission.cpToPersonUid = ?)\n"
            + "                  \n"
            + "        SELECT (    (SELECT ? = ?)\n"
            + "                 OR EXISTS(SELECT 1\n"
            + "                             FROM PersonParentJoin\n"
            + "                            WHERE PersonParentJoin.ppjMinorPersonUid = ?\n"
            + "                              AND PersonParentJoin.ppjParentPersonUid = ?)\n"
            + "                 OR (SELECT \n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "     \n"
            + "                            8192\n"
            + "                            \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    )\n"
            + "                 OR (SELECT ? IN \n"
            + "                             (SELECT CanViewPersonUidsViaCoursePermission.personUid\n"
            + "                                 FROM CanViewPersonUidsViaCoursePermission))           \n"
            + "               ) AS hasViewPermission,\n"
            + "               \n"
            + "               (   (SELECT ? = ?)\n"
            + "                OR EXISTS(SELECT 1\n"
            + "                             FROM PersonParentJoin\n"
            + "                            WHERE PersonParentJoin.ppjMinorPersonUid = ?\n"
            + "                              AND PersonParentJoin.ppjParentPersonUid = ?)\n"
            + "                OR (SELECT \n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "     \n"
            + "                            32768\n"
            + "                            \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    )\n"
            + "                ) AS hasEditPermission\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 19);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment",
        "CoursePermission", "PersonParentJoin",
        "SystemPermission"}, new Callable<EditAndViewPermission>() {
      @Override
      @NonNull
      public EditAndViewPermission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfHasViewPermission = 0;
          final int _cursorIndexOfHasEditPermission = 1;
          final EditAndViewPermission _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpHasViewPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfHasViewPermission);
            _tmpHasViewPermission = _tmp != 0;
            final boolean _tmpHasEditPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfHasEditPermission);
            _tmpHasEditPermission = _tmp_1 != 0;
            _result = new EditAndViewPermission(_tmpHasViewPermission,_tmpHasEditPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
