/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.AbstractConfigNode;
import com.typesafe.config.impl.AbstractConfigNodeValue;
import com.typesafe.config.impl.ConfigNodeComment;
import com.typesafe.config.impl.ConfigNodePath;
import com.typesafe.config.impl.ConfigNodeSingleToken;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class ConfigNodeField
extends AbstractConfigNode {
    private final ArrayList<AbstractConfigNode> children;

    public ConfigNodeField(Collection<AbstractConfigNode> children2) {
        this.children = new ArrayList<AbstractConfigNode>(children2);
    }

    @Override
    protected Collection<Token> tokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (AbstractConfigNode child2 : this.children) {
            tokens.addAll(child2.tokens());
        }
        return tokens;
    }

    public ConfigNodeField replaceValue(AbstractConfigNodeValue newValue) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        for (int i2 = 0; i2 < childrenCopy.size(); ++i2) {
            if (!(childrenCopy.get(i2) instanceof AbstractConfigNodeValue)) continue;
            childrenCopy.set(i2, newValue);
            return new ConfigNodeField(childrenCopy);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a value");
    }

    public AbstractConfigNodeValue value() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!(this.children.get(i2) instanceof AbstractConfigNodeValue)) continue;
            return (AbstractConfigNodeValue)this.children.get(i2);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a value");
    }

    public ConfigNodePath path() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!(this.children.get(i2) instanceof ConfigNodePath)) continue;
            return (ConfigNodePath)this.children.get(i2);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a path");
    }

    protected Token separator() {
        for (AbstractConfigNode child2 : this.children) {
            Token t3;
            if (!(child2 instanceof ConfigNodeSingleToken) || (t3 = ((ConfigNodeSingleToken)child2).token()) != Tokens.PLUS_EQUALS && t3 != Tokens.COLON && t3 != Tokens.EQUALS) continue;
            return t3;
        }
        return null;
    }

    protected List<String> comments() {
        ArrayList<String> comments = new ArrayList<String>();
        for (AbstractConfigNode child2 : this.children) {
            if (!(child2 instanceof ConfigNodeComment)) continue;
            comments.add(((ConfigNodeComment)child2).commentText());
        }
        return comments;
    }
}

