/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;

class LimitingByteInput
implements ByteInput {
    private static final TooBigObjectException EXCEPTION = new TooBigObjectException();
    private final ByteInput input;
    private final long limit;
    private long read;

    LimitingByteInput(ByteInput input2, long limit) {
        this.input = input2;
        this.limit = ObjectUtil.checkPositive(limit, "limit");
    }

    public void close() throws IOException {
    }

    public int available() throws IOException {
        return this.readable(this.input.available());
    }

    public int read() throws IOException {
        int readable = this.readable(1);
        if (readable > 0) {
            int b2 = this.input.read();
            ++this.read;
            return b2;
        }
        throw EXCEPTION;
    }

    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        int readable = this.readable(length);
        if (readable > 0) {
            int i2 = this.input.read(array, offset, readable);
            this.read += (long)i2;
            return i2;
        }
        throw EXCEPTION;
    }

    public long skip(long bytes) throws IOException {
        int readable = this.readable((int)bytes);
        if (readable > 0) {
            long i2 = this.input.skip((long)readable);
            this.read += i2;
            return i2;
        }
        throw EXCEPTION;
    }

    private int readable(int length) {
        return (int)Math.min((long)length, this.limit - this.read);
    }

    static final class TooBigObjectException
    extends IOException {
        private static final long serialVersionUID = 1L;

        TooBigObjectException() {
        }
    }
}

