/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.osjava.datasource.PoolSetup;

public class SJDataSource
implements DataSource {
    private PrintWriter printWriter;
    private String username;
    private String password;
    private String url;
    private String driverName;
    private Properties properties;
    private String poolUrl = null;

    public SJDataSource(String driverName, String url2, String username, String password, Properties properties2) {
        SJDataSource.ensureLoaded(driverName);
        this.driverName = driverName;
        this.url = url2;
        this.printWriter = new PrintWriter(System.err);
        this.username = username;
        this.password = password;
        this.properties = properties2;
    }

    private static boolean ensureLoaded(String name) {
        try {
            Class.forName(name).newInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String poolName = this.properties.getProperty("pool");
        if (poolName != null) {
            Class<SJDataSource> clazz = SJDataSource.class;
            synchronized (SJDataSource.class) {
                if (this.poolUrl == null) {
                    PoolSetup.setupConnection(poolName, this.url, username, password, this.properties);
                    this.poolUrl = PoolSetup.getUrl(poolName);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.getConnection(username, password, this.poolUrl);
            }
        }
        return this.getConnection(username, password, this.url);
    }

    private Connection getConnection(String username, String password, String tmpUrl) throws SQLException {
        if (username == null || password == null) {
            return DriverManager.getConnection(tmpUrl);
        }
        return DriverManager.getConnection(tmpUrl, username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.printWriter = pw;
    }

    @Override
    public void setLoginTimeout(int timeout2) throws SQLException {
    }

    public String toString() {
        return this.driverName + "::::" + this.url + "::::" + this.username;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SJDataSource other = (SJDataSource)obj;
        return other.url.equals(this.url) && other.driverName.equals(this.driverName) && other.username.equals(this.username);
    }

    public int hashCode() {
        return this.url.hashCode() & this.username.hashCode() & this.driverName.hashCode();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("This object is not a wrapper");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("This class does not support this operation.");
    }
}

