/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.lang.BooleanUtils;
import org.osjava.sj.ContextFactory;
import org.osjava.sj.jndi.MemoryContext;

public class MemoryContextFactory
extends ContextFactory
implements InitialContextFactory {
    private static final ConcurrentHashMap<String, Context> contextsByRoot = new ConcurrentHashMap();

    public Context getInitialContext(Hashtable environment2) throws NamingException {
        MemoryContextFactory.overwriteEnvironmentWithSystemProperties(environment2);
        MemoryContextFactory.initializeStandardJndiEnvironment(environment2);
        Boolean isShared = Boolean.valueOf((String)environment2.get("org.osjava.sj.jndi.shared"));
        if (!isShared.booleanValue()) {
            return new MemoryContext(environment2);
        }
        String root = (String)environment2.get("org.osjava.sj.root");
        Context ctx = contextsByRoot.get(root);
        if (ctx != null) {
            String ignoreClose = (String)environment2.get("org.osjava.sj.jndi.ignoreClose");
            ctx.addToEnvironment("org.osjava.sj.jndi.ignoreClose", BooleanUtils.toStringTrueFalse(BooleanUtils.toBoolean(ignoreClose)));
            return ctx;
        }
        final String finalRoot = root;
        MemoryContext context = new MemoryContext(environment2){
            private boolean isClosed;

            @Override
            public void close() throws NamingException {
                String ignoreClose;
                if (!this.isClosed && !BooleanUtils.toBoolean(ignoreClose = (String)this.getEnvironment().get("org.osjava.sj.jndi.ignoreClose"))) {
                    contextsByRoot.remove(finalRoot);
                    super.forceClose();
                    this.isClosed = true;
                }
            }
        };
        contextsByRoot.put(root, context);
        return context;
    }

    static void clearCache() {
        contextsByRoot.clear();
    }
}

