/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.ItemSnapshotList;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.NullPaddedList;
import androidx.paging.PageEvent;
import androidx.paging.TransformablePage;
import androidx.paging.ViewportHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 8*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000289B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006B)\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u001e\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0002J\u0015\u0010(\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010)J\u0006\u0010,\u001a\u00020-J\u001e\u0010.\u001a\u00020\u001f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u00100\u001a\u00020\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u0000022\u0006\u0010#\u001a\u00020$J\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u000004J\b\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bH\u0002R\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006:"}, d2={"Landroidx/paging/PagePresenter;", "T", "", "Landroidx/paging/NullPaddedList;", "insertEvent", "Landroidx/paging/PageEvent$Insert;", "(Landroidx/paging/PageEvent$Insert;)V", "pages", "", "Landroidx/paging/TransformablePage;", "placeholdersBefore", "", "placeholdersAfter", "(Ljava/util/List;II)V", "originalPageOffsetFirst", "getOriginalPageOffsetFirst", "()I", "originalPageOffsetLast", "getOriginalPageOffsetLast", "", "<set-?>", "getPlaceholdersAfter", "getPlaceholdersBefore", "size", "getSize", "storageCount", "getStorageCount", "accessHintForPresenterIndex", "Landroidx/paging/ViewportHint$Access;", "index", "checkIndex", "", "dropPages", "drop", "Landroidx/paging/PageEvent$Drop;", "callback", "Landroidx/paging/PagePresenter$ProcessPageEventCallback;", "dropPagesWithOffsets", "pageOffsetsToDrop", "Lkotlin/ranges/IntRange;", "get", "(I)Ljava/lang/Object;", "getFromStorage", "localIndex", "initializeHint", "Landroidx/paging/ViewportHint$Initial;", "insertPage", "insert", "processEvent", "pageEvent", "Landroidx/paging/PageEvent;", "snapshot", "Landroidx/paging/ItemSnapshotList;", "toString", "", "fullCount", "Companion", "ProcessPageEventCallback", "paging-common"})
@SourceDebugExtension(value={"SMAP\nPagePresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagePresenter.kt\nandroidx/paging/PagePresenter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,375:1\n1#2:376\n1360#3:377\n1446#3,5:378\n12774#4,2:383\n*S KotlinDebug\n*F\n+ 1 PagePresenter.kt\nandroidx/paging/PagePresenter\n*L\n80#1:377\n80#1:378,5\n245#1:383,2\n*E\n"})
public final class PagePresenter<T>
implements NullPaddedList<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TransformablePage<T>> pages;
    private int storageCount;
    private int placeholdersBefore;
    private int placeholdersAfter;
    @NotNull
    private static final PagePresenter<Object> INITIAL = new PagePresenter<Object>(PageEvent.Insert.Companion.getEMPTY_REFRESH_LOCAL());

    public PagePresenter(@NotNull List<TransformablePage<T>> pages, int placeholdersBefore, int placeholdersAfter) {
        Intrinsics.checkNotNullParameter(pages, "pages");
        this.pages = CollectionsKt.toMutableList((Collection)pages);
        this.storageCount = this.fullCount(pages);
        this.placeholdersBefore = placeholdersBefore;
        this.placeholdersAfter = placeholdersAfter;
    }

    public PagePresenter(@NotNull PageEvent.Insert<T> insertEvent) {
        Intrinsics.checkNotNullParameter(insertEvent, "insertEvent");
        this(insertEvent.getPages(), insertEvent.getPlaceholdersBefore(), insertEvent.getPlaceholdersAfter());
    }

    @Override
    public int getStorageCount() {
        return this.storageCount;
    }

    private final int getOriginalPageOffsetFirst() {
        Integer n = ArraysKt.minOrNull(CollectionsKt.first(this.pages).getOriginalPageOffsets());
        Intrinsics.checkNotNull(n);
        return n;
    }

    private final int getOriginalPageOffsetLast() {
        Integer n = ArraysKt.maxOrNull(CollectionsKt.last(this.pages).getOriginalPageOffsets());
        Intrinsics.checkNotNull(n);
        return n;
    }

    @Override
    public int getPlaceholdersBefore() {
        return this.placeholdersBefore;
    }

    @Override
    public int getPlaceholdersAfter() {
        return this.placeholdersAfter;
    }

    private final void checkIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        int n = this.getStorageCount();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<T> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.getFromStorage((int)it));
        }
        String items2 = CollectionsKt.joinToString$default(arrayList, null, null, null, 0, null, null, 63, null);
        return "[(" + this.getPlaceholdersBefore() + " placeholders), " + items2 + ", (" + this.getPlaceholdersAfter() + " placeholders)]";
    }

    @Nullable
    public final T get(int index) {
        this.checkIndex(index);
        int localIndex = index - this.getPlaceholdersBefore();
        if (localIndex < 0 || localIndex >= this.getStorageCount()) {
            return null;
        }
        return this.getFromStorage(localIndex);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemSnapshotList<T> snapshot() {
        List list;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.pages;
        int n = this.getPlaceholdersAfter();
        int n2 = this.getPlaceholdersBefore();
        boolean $i$f$flatMap = false;
        void var3_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TransformablePage it = (TransformablePage)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getData();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        int n3 = n;
        int n4 = n2;
        return new ItemSnapshotList(n4, n3, list2);
    }

    @Override
    @NotNull
    public T getFromStorage(int localIndex) {
        int indexInPage;
        int pageSize;
        int pageIndex = 0;
        int localPageCount = this.pages.size();
        for (indexInPage = localIndex; pageIndex < localPageCount && (pageSize = this.pages.get(pageIndex).getData().size()) <= indexInPage; indexInPage -= pageSize, ++pageIndex) {
        }
        return this.pages.get(pageIndex).getData().get(indexInPage);
    }

    @Override
    public int getSize() {
        return this.getPlaceholdersBefore() + this.getStorageCount() + this.getPlaceholdersAfter();
    }

    /*
     * WARNING - void declaration
     */
    private final int fullCount(List<TransformablePage<T>> $this$fullCount) {
        Iterable iterable = $this$fullCount;
        int n = 0;
        for (Object t3 : iterable) {
            void it;
            TransformablePage transformablePage = (TransformablePage)t3;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getData().size();
            n = n2 + n3;
        }
        return n;
    }

    public final void processEvent(@NotNull PageEvent<T> pageEvent, @NotNull ProcessPageEventCallback callback) {
        Intrinsics.checkNotNullParameter(pageEvent, "pageEvent");
        Intrinsics.checkNotNullParameter(callback, "callback");
        PageEvent<T> pageEvent2 = pageEvent;
        if (pageEvent2 instanceof PageEvent.Insert) {
            this.insertPage((PageEvent.Insert)pageEvent, callback);
        } else if (pageEvent2 instanceof PageEvent.Drop) {
            this.dropPages((PageEvent.Drop)pageEvent, callback);
        } else if (pageEvent2 instanceof PageEvent.LoadStateUpdate) {
            callback.onStateUpdate(((PageEvent.LoadStateUpdate)pageEvent).getSource(), ((PageEvent.LoadStateUpdate)pageEvent).getMediator());
        } else if (pageEvent2 instanceof PageEvent.StaticList) {
            throw new IllegalStateException("Paging received an event to display a static list, while still actively loading\nfrom an existing generation of PagingData. If you see this exception, it is most\nlikely a bug in the library. Please file a bug so we can fix it at:\nhttps://issuetracker.google.com/issues/new?component=413106");
        }
    }

    @NotNull
    public final ViewportHint.Initial initializeHint() {
        int presentedItems = this.getStorageCount();
        return new ViewportHint.Initial(presentedItems / 2, presentedItems / 2, this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    @NotNull
    public final ViewportHint.Access accessHintForPresenterIndex(int index) {
        int indexInPage;
        int pageIndex = 0;
        for (indexInPage = index - this.getPlaceholdersBefore(); indexInPage >= this.pages.get(pageIndex).getData().size() && pageIndex < CollectionsKt.getLastIndex(this.pages); indexInPage -= this.pages.get(pageIndex).getData().size(), ++pageIndex) {
        }
        return this.pages.get(pageIndex).viewportHintFor(indexInPage, index - this.getPlaceholdersBefore(), this.getSize() - index - this.getPlaceholdersAfter() - 1, this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    private final void insertPage(PageEvent.Insert<T> insert2, ProcessPageEventCallback callback) {
        int count2 = this.fullCount(insert2.getPages());
        int oldSize = this.getSize();
        switch (WhenMappings.$EnumSwitchMapping$0[insert2.getLoadType().ordinal()]) {
            case 1: {
                throw new IllegalStateException("Paging received a refresh event in the middle of an actively loading generation\nof PagingData. If you see this exception, it is most likely a bug in the library.\nPlease file a bug so we can fix it at:\nhttps://issuetracker.google.com/issues/new?component=413106");
            }
            case 2: {
                int placeholdersChangedCount = Math.min(this.getPlaceholdersBefore(), count2);
                int placeholdersChangedPos = this.getPlaceholdersBefore() - placeholdersChangedCount;
                int itemsInsertedCount = count2 - placeholdersChangedCount;
                int itemsInsertedPos = 0;
                this.pages.addAll(0, (Collection)insert2.getPages());
                this.storageCount = this.getStorageCount() + count2;
                this.placeholdersBefore = insert2.getPlaceholdersBefore();
                callback.onChanged(placeholdersChangedPos, placeholdersChangedCount);
                callback.onInserted(itemsInsertedPos, itemsInsertedCount);
                int placeholderInsertedCount = this.getSize() - oldSize - itemsInsertedCount;
                if (placeholderInsertedCount > 0) {
                    callback.onInserted(0, placeholderInsertedCount);
                    break;
                }
                if (placeholderInsertedCount >= 0) break;
                callback.onRemoved(0, -placeholderInsertedCount);
                break;
            }
            case 3: {
                int placeholdersChangedCount = Math.min(this.getPlaceholdersAfter(), count2);
                int placeholdersChangedPos = this.getPlaceholdersBefore() + this.getStorageCount();
                int itemsInsertedCount = count2 - placeholdersChangedCount;
                int itemsInsertedPos = placeholdersChangedPos + placeholdersChangedCount;
                this.pages.addAll(this.pages.size(), (Collection)insert2.getPages());
                this.storageCount = this.getStorageCount() + count2;
                this.placeholdersAfter = insert2.getPlaceholdersAfter();
                callback.onChanged(placeholdersChangedPos, placeholdersChangedCount);
                callback.onInserted(itemsInsertedPos, itemsInsertedCount);
                int placeholderInsertedCount = this.getSize() - oldSize - itemsInsertedCount;
                if (placeholderInsertedCount > 0) {
                    callback.onInserted(this.getSize() - placeholderInsertedCount, placeholderInsertedCount);
                    break;
                }
                if (placeholderInsertedCount >= 0) break;
                callback.onRemoved(this.getSize(), -placeholderInsertedCount);
            }
        }
        callback.onStateUpdate(insert2.getSourceLoadStates(), insert2.getMediatorLoadStates());
    }

    private final int dropPagesWithOffsets(IntRange pageOffsetsToDrop) {
        int removeCount = 0;
        Iterator<TransformablePage<T>> pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            boolean bl;
            TransformablePage<T> page;
            block2: {
                page = pageIterator.next();
                int[] $this$any$iv = page.getOriginalPageOffsets();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    int element$iv;
                    int it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!pageOffsetsToDrop.contains(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            removeCount += page.getData().size();
            pageIterator.remove();
        }
        return removeCount;
    }

    private final void dropPages(PageEvent.Drop<T> drop2, ProcessPageEventCallback callback) {
        int oldSize = this.getSize();
        if (drop2.getLoadType() == LoadType.PREPEND) {
            int oldPlaceholdersBefore = this.getPlaceholdersBefore();
            int itemDropCount = this.dropPagesWithOffsets(new IntRange(drop2.getMinPageOffset(), drop2.getMaxPageOffset()));
            this.storageCount = this.getStorageCount() - itemDropCount;
            this.placeholdersBefore = drop2.getPlaceholdersRemaining();
            int expectedSize = this.getSize();
            int placeholdersToInsert = expectedSize - oldSize;
            if (placeholdersToInsert > 0) {
                callback.onInserted(0, placeholdersToInsert);
            } else if (placeholdersToInsert < 0) {
                callback.onRemoved(0, -placeholdersToInsert);
            }
            int firstItemIndex = Math.max(0, oldPlaceholdersBefore + placeholdersToInsert);
            int changeCount = drop2.getPlaceholdersRemaining() - firstItemIndex;
            if (changeCount > 0) {
                callback.onChanged(firstItemIndex, changeCount);
            }
            callback.onStateUpdate(LoadType.PREPEND, false, LoadState.NotLoading.Companion.getIncomplete$paging_common());
        } else {
            int oldPlaceholdersAfter = this.getPlaceholdersAfter();
            int itemDropCount = this.dropPagesWithOffsets(new IntRange(drop2.getMinPageOffset(), drop2.getMaxPageOffset()));
            this.storageCount = this.getStorageCount() - itemDropCount;
            this.placeholdersAfter = drop2.getPlaceholdersRemaining();
            int expectedSize = this.getSize();
            int placeholdersToInsert = expectedSize - oldSize;
            if (placeholdersToInsert > 0) {
                callback.onInserted(oldSize, placeholdersToInsert);
            } else if (placeholdersToInsert < 0) {
                callback.onRemoved(oldSize + placeholdersToInsert, -placeholdersToInsert);
            }
            int oldPlaceholdersRemoved = placeholdersToInsert < 0 ? Math.min(oldPlaceholdersAfter, -placeholdersToInsert) : 0;
            int changeCount = drop2.getPlaceholdersRemaining() - (oldPlaceholdersAfter - oldPlaceholdersRemoved);
            if (changeCount > 0) {
                callback.onChanged(this.getSize() - drop2.getPlaceholdersRemaining(), changeCount);
            }
            callback.onStateUpdate(LoadType.APPEND, false, LoadState.NotLoading.Companion.getIncomplete$paging_common());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0004\"\b\b\u0001\u0010\u0006*\u00020\u00012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/paging/PagePresenter$Companion;", "", "()V", "INITIAL", "Landroidx/paging/PagePresenter;", "initial", "T", "event", "Landroidx/paging/PageEvent$Insert;", "initial$paging_common", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> PagePresenter<T> initial$paging_common(@Nullable PageEvent.Insert<T> event) {
            PagePresenter<T> pagePresenter;
            if (event != null) {
                pagePresenter = new PagePresenter<T>(event);
            } else {
                PagePresenter pagePresenter2 = INITIAL;
                pagePresenter = pagePresenter2;
                Intrinsics.checkNotNull(pagePresenter2, "null cannot be cast to non-null type androidx.paging.PagePresenter<T of androidx.paging.PagePresenter.Companion.initial>");
            }
            return pagePresenter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u001a\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH&J \u0010\t\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Landroidx/paging/PagePresenter$ProcessPageEventCallback;", "", "onChanged", "", "position", "", "count", "onInserted", "onRemoved", "onStateUpdate", "source", "Landroidx/paging/LoadStates;", "mediator", "loadType", "Landroidx/paging/LoadType;", "fromMediator", "", "loadState", "Landroidx/paging/LoadState;", "paging-common"})
    public static interface ProcessPageEventCallback {
        public void onChanged(int var1, int var2);

        public void onInserted(int var1, int var2);

        public void onRemoved(int var1, int var2);

        public void onStateUpdate(@NotNull LoadType var1, boolean var2, @NotNull LoadState var3);

        public void onStateUpdate(@NotNull LoadStates var1, @Nullable LoadStates var2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.REFRESH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.PREPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.APPEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

