/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.test.http;

import com.ustadmobile.lib.util.SysPathUtil;
import com.ustadmobile.test.http.FindFreePortKt;
import com.ustadmobile.test.http.OkHttpClientExtKt;
import com.ustadmobile.test.http.RunMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/ustadmobile/test/http/ServerRunner;", "", "mode", "Lcom/ustadmobile/test/http/RunMode;", "okHttpClient", "Lokhttp3/OkHttpClient;", "serverDir", "Ljava/io/File;", "controllerUrl", "Ljava/net/URL;", "learningSpaceHost", "Ljava/net/InetAddress;", "baseDataDir", "adbDeviceSerial", "", "adbRecordEnabled", "", "adbVideoName", "fromPort", "", "untilPort", "learningSpaceUrlTemplate", "(Lcom/ustadmobile/test/http/RunMode;Lokhttp3/OkHttpClient;Ljava/io/File;Ljava/net/URL;Ljava/net/InetAddress;Ljava/io/File;Ljava/lang/String;ZLjava/lang/String;IILjava/lang/String;)V", "dataDir", "learningSpaceUrl", "getLearningSpaceUrl", "()Ljava/lang/String;", "getMode", "()Lcom/ustadmobile/test/http/RunMode;", "pid", "", "getPid", "()J", "port", "getPort", "()I", "serverProcess", "Ljava/lang/Process;", "start", "", "stop", "Companion", "testserver-controller"})
@SourceDebugExtension(value={"SMAP\nServerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerRunner.kt\ncom/ustadmobile/test/http/ServerRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n766#2:139\n857#2,2:140\n*S KotlinDebug\n*F\n+ 1 ServerRunner.kt\ncom/ustadmobile/test/http/ServerRunner\n*L\n54#1:139\n54#1:140,2\n*E\n"})
public final class ServerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RunMode mode;
    @NotNull
    private final OkHttpClient okHttpClient;
    @NotNull
    private final File serverDir;
    @Nullable
    private final String adbDeviceSerial;
    private final boolean adbRecordEnabled;
    @Nullable
    private final String adbVideoName;
    private final int port;
    @NotNull
    private final String learningSpaceUrl;
    @NotNull
    private final File dataDir;
    @Nullable
    private volatile Process serverProcess;
    @NotNull
    public static final String DEFAULT_LEARNING_SPACE_URL_TEMPLATE = "http://{HOSTIP}:{PORT}/";

    public ServerRunner(@NotNull RunMode mode, @NotNull OkHttpClient okHttpClient, @NotNull File serverDir, @NotNull URL controllerUrl, @NotNull InetAddress learningSpaceHost, @NotNull File baseDataDir, @Nullable String adbDeviceSerial, boolean adbRecordEnabled, @Nullable String adbVideoName, int fromPort, int untilPort, @NotNull String learningSpaceUrlTemplate) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(okHttpClient, "okHttpClient");
        Intrinsics.checkNotNullParameter(serverDir, "serverDir");
        Intrinsics.checkNotNullParameter(controllerUrl, "controllerUrl");
        Intrinsics.checkNotNullParameter(learningSpaceHost, "learningSpaceHost");
        Intrinsics.checkNotNullParameter(baseDataDir, "baseDataDir");
        Intrinsics.checkNotNullParameter(learningSpaceUrlTemplate, "learningSpaceUrlTemplate");
        this.mode = mode;
        this.okHttpClient = okHttpClient;
        this.serverDir = serverDir;
        this.adbDeviceSerial = adbDeviceSerial;
        this.adbRecordEnabled = adbRecordEnabled;
        this.adbVideoName = adbVideoName;
        this.port = FindFreePortKt.findFreePort$default(fromPort, untilPort, 0, 4, null);
        if (this.mode == RunMode.CYPRESS) {
            string = controllerUrl.toString();
        } else {
            String string2 = StringsKt.replace$default(learningSpaceUrlTemplate, "{PORT}", String.valueOf(this.port), false, 4, null);
            String string3 = learningSpaceHost.getHostAddress();
            Intrinsics.checkNotNullExpressionValue(string3, "getHostAddress(...)");
            string = StringsKt.replace$default(string2, "{HOSTIP}", string3, false, 4, null);
        }
        String string4 = string;
        Intrinsics.checkNotNull(string4);
        this.learningSpaceUrl = string4;
        this.dataDir = new File(baseDataDir, "server-" + this.port);
    }

    public /* synthetic */ ServerRunner(RunMode runMode, OkHttpClient okHttpClient, File file2, URL uRL, InetAddress inetAddress, File file3, String string, boolean bl, String string2, int n, int n2, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x40) != 0) {
            string = null;
        }
        if ((n3 & 0x80) != 0) {
            bl = false;
        }
        if ((n3 & 0x100) != 0) {
            string2 = null;
        }
        if ((n3 & 0x200) != 0) {
            n = 1025;
        }
        if ((n3 & 0x400) != 0) {
            n2 = 65534;
        }
        if ((n3 & 0x800) != 0) {
            string3 = DEFAULT_LEARNING_SPACE_URL_TEMPLATE;
        }
        this(runMode, okHttpClient, file2, uRL, inetAddress, file3, string, bl, string2, n, n2, string3);
    }

    @NotNull
    public final RunMode getMode() {
        return this.mode;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getLearningSpaceUrl() {
        return this.learningSpaceUrl;
    }

    public final long getPid() {
        Process process2 = this.serverProcess;
        return process2 != null ? process2.pid() : -1L;
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void $this$filterTo$iv$iv;
        String $this$filter$iv;
        if (this.dataDir.exists()) {
            FilesKt.deleteRecursively(this.dataDir);
        }
        File logDir = new File(this.dataDir, "log");
        logDir.mkdirs();
        String runServerCommand = "java -Dlogs_dir=" + logDir.getAbsolutePath() + " -jar build/libs/ustad-server-all.jar";
        Object object = runServerCommand;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object2 = $this$filterTo$iv$iv.iterator();
        while (object2.hasNext()) {
            Object element$iv$iv = object2.next();
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List serverArgs = CollectionsKt.toMutableList((List)destination$iv$iv);
        if (!StringsKt.startsWith$default((String)serverArgs.get(0), ".", false, 2, null) && !StringsKt.startsWith$default((String)serverArgs.get(0), "/", false, 2, null)) {
            File file2 = SysPathUtil.findCommandInPath$default(SysPathUtil.INSTANCE, (String)serverArgs.get(0), null, null, null, null, null, 62, null);
            String string = $this$filter$iv = file2 != null ? file2.getAbsolutePath() : null;
            if ($this$filter$iv == null) {
                throw new IllegalArgumentException("Could not find server command in PATH " + serverArgs.get(0));
            }
            serverArgs.set(0, $this$filter$iv);
        }
        File configFile = new File(this.serverDir, "src/main/resources/application.conf");
        List<String> serverArgsWithSiteUrl = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)serverArgs, "runserver"), "-config=" + configFile.getAbsolutePath()), "-P:ktor.deployment.port=" + this.port), "-P:ktor.ustad.datadir=" + this.dataDir.getAbsolutePath()), "-P:ktor.ustad.jsDevServer=");
        String commandLine = CollectionsKt.joinToString$default(serverArgsWithSiteUrl, " ", null, null, 0, null, null, 62, null);
        System.out.println((Object)("TestServerController: exec " + commandLine));
        this.serverProcess = new ProcessBuilder(serverArgsWithSiteUrl).directory(this.serverDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
        URL urlToWaitFor = this.mode == RunMode.CYPRESS ? new URL(new URL(this.learningSpaceUrl), "umapp/") : new URL(new URL(this.learningSpaceUrl), "api/centralappconfig/learningspace/getAll");
        String string = urlToWaitFor.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        OkHttpClientExtKt.waitForUrl$default(this.okHttpClient, string, 0L, 0L, 0L, 14, null);
        Object $this$start_u24lambda_u241 = object2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$start_u24lambda_u241.addAll(serverArgs);
        $this$start_u24lambda_u241.add("newlearningspace");
        $this$start_u24lambda_u241.add("--title");
        $this$start_u24lambda_u241.add("TestLearningSpace");
        $this$start_u24lambda_u241.add("--url");
        $this$start_u24lambda_u241.add(this.learningSpaceUrl);
        $this$start_u24lambda_u241.add("--adminpassword");
        $this$start_u24lambda_u241.add("testpass");
        $this$start_u24lambda_u241.add("--datadir");
        $this$start_u24lambda_u241.add(this.dataDir.getAbsolutePath());
        List<String> createLearningSpaceCommandArgs = CollectionsKt.build(object2);
        Process addingLearningSpaceProcess = new ProcessBuilder(createLearningSpaceCommandArgs).directory(this.serverDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
        int status = addingLearningSpaceProcess.waitFor();
        InputStream inputStream2 = addingLearningSpaceProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
        InputStream bl3 = inputStream2;
        Object object3 = Charsets.UTF_8;
        Object object4 = new InputStreamReader(bl3, (Charset)object3);
        int n2 = 8192;
        String output2 = TextStreamsKt.readText(object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n2));
        System.out.println((Object)output2);
        InputStream inputStream3 = addingLearningSpaceProcess.getErrorStream();
        Intrinsics.checkNotNullExpressionValue(inputStream3, "getErrorStream(...)");
        object3 = inputStream3;
        object4 = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object3, (Charset)object4);
        int n3 = 8192;
        String errorOutput = TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n3));
        System.out.println((Object)errorOutput);
        if (status != 0) {
            throw new IllegalStateException("Could not add learning space");
        }
    }

    public final void stop() {
        block0: {
            Process process2;
            System.out.println((Object)("TestServerController: stopping server on port: " + this.port));
            Process process3 = this.serverProcess;
            if (process3 == null) break block0;
            Process it = process2 = process3;
            boolean bl = false;
            it.destroy();
            it.waitFor();
            this.serverProcess = null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/test/http/ServerRunner$Companion;", "", "()V", "DEFAULT_LEARNING_SPACE_URL_TEMPLATE", "", "testserver-controller"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

