/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a4\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a,\u0010\u0015\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"parseQueryString", "Lio/ktor/http/Parameters;", "query", "", "startIndex", "", "limit", "decode", "", "trimEnd", "start", "end", "text", "", "trimStart", "appendParam", "", "Lio/ktor/http/ParametersBuilder;", "nameIndex", "equalIndex", "endIndex", "parse", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Query.kt\nio/ktor/http/QueryKt\n+ 2 Parameters.kt\nio/ktor/http/Parameters$Companion\n*L\n1#1,95:1\n24#2:96\n*S KotlinDebug\n*F\n+ 1 Query.kt\nio/ktor/http/QueryKt\n*L\n14#1:96\n*E\n"})
public final class QueryKt {
    @NotNull
    public static final Parameters parseQueryString(@NotNull String query, int startIndex, int limit, boolean decode) {
        Parameters parameters2;
        Intrinsics.checkNotNullParameter(query, "query");
        if (startIndex > StringsKt.getLastIndex(query)) {
            parameters2 = Parameters.Companion.getEmpty();
        } else {
            ParametersBuilder parametersBuilder;
            Parameters.Companion this_$iv = Parameters.Companion;
            boolean $i$f$build = false;
            ParametersBuilder $this$parseQueryString_u24lambda_u240 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
            boolean bl = false;
            QueryKt.parse($this$parseQueryString_u24lambda_u240, query, startIndex, limit, decode);
            parameters2 = parametersBuilder.build();
        }
        return parameters2;
    }

    public static /* synthetic */ Parameters parseQueryString$default(String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 1000;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return QueryKt.parseQueryString(string, n, n2, bl);
    }

    private static final void parse(ParametersBuilder $this$parse, String query, int startIndex, int limit, boolean decode) {
        int count2 = 0;
        int nameIndex = startIndex;
        int equalIndex = -1;
        int index = startIndex;
        int n = StringsKt.getLastIndex(query);
        if (index <= n) {
            while (true) {
                if (count2 == limit) {
                    return;
                }
                char c = query.charAt(index);
                if (c == '&') {
                    QueryKt.appendParam($this$parse, query, nameIndex, equalIndex, index, decode);
                    nameIndex = index + 1;
                    equalIndex = -1;
                    ++count2;
                } else if (c == '=' && equalIndex == -1) {
                    equalIndex = index;
                }
                if (index == n) break;
                ++index;
            }
        }
        if (count2 == limit) {
            return;
        }
        QueryKt.appendParam($this$parse, query, nameIndex, equalIndex, query.length(), decode);
    }

    private static final void appendParam(ParametersBuilder $this$appendParam, String query, int nameIndex, int equalIndex, int endIndex, boolean decode) {
        if (equalIndex == -1) {
            int spaceNameIndex = QueryKt.trimStart(nameIndex, endIndex, query);
            int spaceEndIndex = QueryKt.trimEnd(spaceNameIndex, endIndex, query);
            if (spaceEndIndex > spaceNameIndex) {
                String string;
                if (decode) {
                    string = CodecsKt.decodeURLQueryComponent$default(query, spaceNameIndex, spaceEndIndex, false, null, 12, null);
                } else {
                    String string2 = query.substring(spaceNameIndex, spaceEndIndex);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                }
                String name = string;
                $this$appendParam.appendAll(name, CollectionsKt.emptyList());
            }
            return;
        }
        int spaceNameIndex = QueryKt.trimStart(nameIndex, equalIndex, query);
        int spaceEqualIndex = QueryKt.trimEnd(spaceNameIndex, equalIndex, query);
        if (spaceEqualIndex > spaceNameIndex) {
            String string;
            String string3;
            if (decode) {
                string3 = CodecsKt.decodeURLQueryComponent$default(query, spaceNameIndex, spaceEqualIndex, false, null, 12, null);
            } else {
                String string4 = query.substring(spaceNameIndex, spaceEqualIndex);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String name = string3;
            int spaceValueIndex = QueryKt.trimStart(equalIndex + 1, endIndex, query);
            int spaceEndIndex = QueryKt.trimEnd(spaceValueIndex, endIndex, query);
            if (decode) {
                string = CodecsKt.decodeURLQueryComponent$default(query, spaceValueIndex, spaceEndIndex, true, null, 8, null);
            } else {
                String string5 = query.substring(spaceValueIndex, spaceEndIndex);
                string = string5;
                Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String value = string;
            $this$appendParam.append(name, value);
        }
    }

    private static final int trimEnd(int start2, int end2, CharSequence text2) {
        int spaceIndex;
        for (spaceIndex = end2; spaceIndex > start2 && CharsKt.isWhitespace(text2.charAt(spaceIndex - 1)); --spaceIndex) {
        }
        return spaceIndex;
    }

    private static final int trimStart(int start2, int end2, CharSequence query) {
        int spaceIndex;
        for (spaceIndex = start2; spaceIndex < end2 && CharsKt.isWhitespace(query.charAt(spaceIndex)); ++spaceIndex) {
        }
        return spaceIndex;
    }
}

