/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.lang.Entities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.commons.lang.text.StrBuilder;

public class StringEscapeUtils {
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_QUOTE_STR = String.valueOf('\"');
    private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

    public static String escapeJava(String str) {
        return StringEscapeUtils.escapeJavaStyleString(str, false, false);
    }

    public static void escapeJava(Writer out2, String str) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(out2, str, false, false);
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeJavaStyleString(str, true, true);
    }

    public static void escapeJavaScript(Writer out2, String str) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(out2, str, true, true);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            StringEscapeUtils.escapeJavaStyleString(writer, str, escapeSingleQuotes, escapeForwardSlash);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out2, String str, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out2 == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (ch > '\u0fff') {
                out2.write("\\u" + StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out2.write("\\u0" + StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out2.write("\\u00" + StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out2.write(92);
                        out2.write(98);
                        break;
                    }
                    case '\n': {
                        out2.write(92);
                        out2.write(110);
                        break;
                    }
                    case '\t': {
                        out2.write(92);
                        out2.write(116);
                        break;
                    }
                    case '\f': {
                        out2.write(92);
                        out2.write(102);
                        break;
                    }
                    case '\r': {
                        out2.write(92);
                        out2.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out2.write("\\u00" + StringEscapeUtils.hex(ch));
                            break;
                        }
                        out2.write("\\u000" + StringEscapeUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out2.write(92);
                    }
                    out2.write(39);
                    continue block13;
                }
                case '\"': {
                    out2.write(92);
                    out2.write(34);
                    continue block13;
                }
                case '\\': {
                    out2.write(92);
                    out2.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out2.write(92);
                    }
                    out2.write(47);
                    continue block13;
                }
                default: {
                    out2.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringEscapeUtils.unescapeJava(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeJava(Writer out2, String str) throws IOException {
        if (out2 == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StrBuilder unicode = new StrBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out2.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new NestableRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out2.write(92);
                        break;
                    }
                    case '\'': {
                        out2.write(39);
                        break;
                    }
                    case '\"': {
                        out2.write(34);
                        break;
                    }
                    case 'r': {
                        out2.write(13);
                        break;
                    }
                    case 'f': {
                        out2.write(12);
                        break;
                    }
                    case 't': {
                        out2.write(9);
                        break;
                    }
                    case 'n': {
                        out2.write(10);
                        break;
                    }
                    case 'b': {
                        out2.write(8);
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out2.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out2.write(ch);
        }
        if (hadSlash) {
            out2.write(92);
        }
    }

    public static String unescapeJavaScript(String str) {
        return StringEscapeUtils.unescapeJava(str);
    }

    public static void unescapeJavaScript(Writer out2, String str) throws IOException {
        StringEscapeUtils.unescapeJava(out2, str);
    }

    public static String escapeHtml(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter((int)((double)str.length() * 1.5));
            StringEscapeUtils.escapeHtml(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void escapeHtml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.HTML40.escape(writer, string);
    }

    public static String unescapeHtml(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter((int)((double)str.length() * 1.5));
            StringEscapeUtils.unescapeHtml(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeHtml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.HTML40.unescape(writer, string);
    }

    public static void escapeXml(Writer writer, String str) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (str == null) {
            return;
        }
        Entities.XML.escape(writer, str);
    }

    public static String escapeXml(String str) {
        if (str == null) {
            return null;
        }
        return Entities.XML.escape(str);
    }

    public static void unescapeXml(Writer writer, String str) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (str == null) {
            return;
        }
        Entities.XML.unescape(writer, str);
    }

    public static String unescapeXml(String str) {
        if (str == null) {
            return null;
        }
        return Entities.XML.unescape(str);
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.replace(str, "'", "''");
    }

    public static String escapeCsv(String str) {
        if (StringUtils.containsNone(str, CSV_SEARCH_CHARS)) {
            return str;
        }
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.escapeCsv(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void escapeCsv(Writer out2, String str) throws IOException {
        if (StringUtils.containsNone(str, CSV_SEARCH_CHARS)) {
            if (str != null) {
                out2.write(str);
            }
            return;
        }
        out2.write(34);
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if (c == '\"') {
                out2.write(34);
            }
            out2.write(c);
        }
        out2.write(34);
    }

    public static String unescapeCsv(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            StringEscapeUtils.unescapeCsv(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeCsv(Writer out2, String str) throws IOException {
        if (str == null) {
            return;
        }
        if (str.length() < 2) {
            out2.write(str);
            return;
        }
        if (str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            out2.write(str);
            return;
        }
        String quoteless = str.substring(1, str.length() - 1);
        if (StringUtils.containsAny(quoteless, CSV_SEARCH_CHARS)) {
            str = StringUtils.replace(quoteless, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR);
        }
        out2.write(str);
    }
}

