/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.MemberUtils;

public class MethodUtils {
    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, methodName, new Object[]{arg});
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments2 = args2.length;
        Class[] parameterTypes = new Class[arguments2];
        for (int i2 = 0; i2 < arguments2; ++i2) {
            parameterTypes[i2] = args2[i2].getClass();
        }
        return MethodUtils.invokeMethod(object, methodName, args2, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args2, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method2;
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method2 = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method2.invoke(object, args2);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, methodName, new Object[]{arg});
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments2 = args2.length;
        Class[] parameterTypes = new Class[arguments2];
        for (int i2 = 0; i2 < arguments2; ++i2) {
            parameterTypes[i2] = args2[i2].getClass();
        }
        return MethodUtils.invokeExactMethod(object, methodName, args2, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args2, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method2;
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((method2 = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method2.invoke(object, args2);
    }

    public static Object invokeExactStaticMethod(Class cls, String methodName, Object[] args2, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method2;
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((method2 = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method2.invoke(null, args2);
    }

    public static Object invokeStaticMethod(Class cls, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeStaticMethod(cls, methodName, new Object[]{arg});
    }

    public static Object invokeStaticMethod(Class cls, String methodName, Object[] args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments2 = args2.length;
        Class[] parameterTypes = new Class[arguments2];
        for (int i2 = 0; i2 < arguments2; ++i2) {
            parameterTypes[i2] = args2[i2].getClass();
        }
        return MethodUtils.invokeStaticMethod(cls, methodName, args2, parameterTypes);
    }

    public static Object invokeStaticMethod(Class cls, String methodName, Object[] args2, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method2;
        if (parameterTypes == null) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method2 = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method2.invoke(null, args2);
    }

    public static Object invokeExactStaticMethod(Class cls, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactStaticMethod(cls, methodName, new Object[]{arg});
    }

    public static Object invokeExactStaticMethod(Class cls, String methodName, Object[] args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args2 == null) {
            args2 = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int arguments2 = args2.length;
        Class[] parameterTypes = new Class[arguments2];
        for (int i2 = 0; i2 < arguments2; ++i2) {
            parameterTypes[i2] = args2[i2].getClass();
        }
        return MethodUtils.invokeExactStaticMethod(cls, methodName, args2, parameterTypes);
    }

    public static Method getAccessibleMethod(Class cls, String methodName, Class parameterType) {
        return MethodUtils.getAccessibleMethod(cls, methodName, new Class[]{parameterType});
    }

    public static Method getAccessibleMethod(Class cls, String methodName, Class[] parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method2) {
        Class[] parameterTypes;
        if (!MemberUtils.isAccessible(method2)) {
            return null;
        }
        Class<?> cls = method2.getDeclaringClass();
        if (Modifier.isPublic(cls.getModifiers())) {
            return method2;
        }
        String methodName = method2.getName();
        if ((method2 = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method2.getParameterTypes())) == null) {
            method2 = MethodUtils.getAccessibleMethodFromSuperclass(cls, methodName, parameterTypes);
        }
        return method2;
    }

    private static Method getAccessibleMethodFromSuperclass(Class cls, String methodName, Class[] parameterTypes) {
        for (Class parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!Modifier.isPublic(parentClass.getModifiers())) continue;
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class cls, String methodName, Class[] parameterTypes) {
        Method method2 = null;
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                if (!Modifier.isPublic(interfaces[i2].getModifiers())) continue;
                try {
                    method2 = interfaces[i2].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method2 != null || (method2 = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i2], methodName, parameterTypes)) != null) break;
            }
            cls = cls.getSuperclass();
        }
        return method2;
    }

    public static Method getMatchingAccessibleMethod(Class cls, String methodName, Class[] parameterTypes) {
        try {
            Method method2 = cls.getMethod(methodName, parameterTypes);
            MemberUtils.setAccessibleWorkaround(method2);
            return method2;
        }
        catch (NoSuchMethodException e) {
            Method bestMatch = null;
            Method[] methods2 = cls.getMethods();
            int size2 = methods2.length;
            for (int i2 = 0; i2 < size2; ++i2) {
                Method accessibleMethod;
                if (!methods2[i2].getName().equals(methodName) || !ClassUtils.isAssignable(parameterTypes, methods2[i2].getParameterTypes(), true) || (accessibleMethod = MethodUtils.getAccessibleMethod(methods2[i2])) == null || bestMatch != null && MemberUtils.compareParameterTypes(accessibleMethod.getParameterTypes(), bestMatch.getParameterTypes(), parameterTypes) >= 0) continue;
                bestMatch = accessibleMethod;
            }
            if (bestMatch != null) {
                MemberUtils.setAccessibleWorkaround(bestMatch);
            }
            return bestMatch;
        }
    }
}

