/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONMLParserConfiguration;
import org.json.JSONObject;
import org.json.XML;
import org.json.XMLTokener;

public class JSONML {
    private static Object parse(XMLTokener x, boolean arrayForm, JSONArray ja, boolean keepStrings, int currentNestingDepth) throws JSONException {
        return JSONML.parse(x, arrayForm, ja, keepStrings ? JSONMLParserConfiguration.KEEP_STRINGS : JSONMLParserConfiguration.ORIGINAL, currentNestingDepth);
    }

    private static Object parse(XMLTokener x, boolean arrayForm, JSONArray ja, JSONMLParserConfiguration config2, int currentNestingDepth) throws JSONException {
        String closeTag = null;
        JSONArray newja = null;
        JSONObject newjo = null;
        String tagName2 = null;
        while (true) {
            if (!x.more()) {
                throw x.syntaxError("Bad XML");
            }
            Object token2 = x.nextContent();
            if (token2 == XML.LT) {
                token2 = x.nextToken();
                if (token2 instanceof Character) {
                    if (token2 == XML.SLASH) {
                        token2 = x.nextToken();
                        if (!(token2 instanceof String)) {
                            throw new JSONException("Expected a closing name instead of '" + token2 + "'.");
                        }
                        if (x.nextToken() != XML.GT) {
                            throw x.syntaxError("Misshaped close tag");
                        }
                        return token2;
                    }
                    if (token2 == XML.BANG) {
                        char c = x.next();
                        if (c == '-') {
                            if (x.next() == '-') {
                                x.skipPast("-->");
                                continue;
                            }
                            x.back();
                            continue;
                        }
                        if (c == '[') {
                            token2 = x.nextToken();
                            if (token2.equals("CDATA") && x.next() == '[') {
                                if (ja == null) continue;
                                ja.put(x.nextCDATA());
                                continue;
                            }
                            throw x.syntaxError("Expected 'CDATA['");
                        }
                        int i2 = 1;
                        do {
                            if ((token2 = x.nextMeta()) == null) {
                                throw x.syntaxError("Missing '>' after '<!'.");
                            }
                            if (token2 == XML.LT) {
                                ++i2;
                                continue;
                            }
                            if (token2 != XML.GT) continue;
                            --i2;
                        } while (i2 > 0);
                        continue;
                    }
                    if (token2 == XML.QUEST) {
                        x.skipPast("?>");
                        continue;
                    }
                    throw x.syntaxError("Misshaped tag");
                }
                if (!(token2 instanceof String)) {
                    throw x.syntaxError("Bad tagName '" + token2 + "'.");
                }
                tagName2 = (String)token2;
                newja = new JSONArray();
                newjo = new JSONObject();
                if (arrayForm) {
                    newja.put(tagName2);
                    if (ja != null) {
                        ja.put(newja);
                    }
                } else {
                    newjo.put("tagName", tagName2);
                    if (ja != null) {
                        ja.put(newjo);
                    }
                }
                token2 = null;
                while (true) {
                    if (token2 == null) {
                        token2 = x.nextToken();
                    }
                    if (token2 == null) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (!(token2 instanceof String)) break;
                    String attribute = (String)token2;
                    if (!arrayForm && ("tagName".equals(attribute) || "childNode".equals(attribute))) {
                        throw x.syntaxError("Reserved attribute.");
                    }
                    token2 = x.nextToken();
                    if (token2 == XML.EQ) {
                        token2 = x.nextToken();
                        if (!(token2 instanceof String)) {
                            throw x.syntaxError("Missing value");
                        }
                        newjo.accumulate(attribute, config2.isKeepStrings() ? (String)token2 : XML.stringToValue((String)token2));
                        token2 = null;
                        continue;
                    }
                    newjo.accumulate(attribute, "");
                }
                if (arrayForm && newjo.length() > 0) {
                    newja.put(newjo);
                }
                if (token2 == XML.SLASH) {
                    if (x.nextToken() != XML.GT) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (ja != null) continue;
                    if (arrayForm) {
                        return newja;
                    }
                    return newjo;
                }
                if (token2 != XML.GT) {
                    throw x.syntaxError("Misshaped tag");
                }
                if (currentNestingDepth == config2.getMaxNestingDepth()) {
                    throw x.syntaxError("Maximum nesting depth of " + config2.getMaxNestingDepth() + " reached");
                }
                closeTag = (String)JSONML.parse(x, arrayForm, newja, config2, currentNestingDepth + 1);
                if (closeTag == null) continue;
                if (!closeTag.equals(tagName2)) {
                    throw x.syntaxError("Mismatched '" + tagName2 + "' and '" + closeTag + "'");
                }
                tagName2 = null;
                if (!arrayForm && newja.length() > 0) {
                    newjo.put("childNodes", newja);
                }
                if (ja != null) continue;
                if (arrayForm) {
                    return newja;
                }
                return newjo;
            }
            if (ja == null) continue;
            ja.put(token2 instanceof String ? (config2.isKeepStrings() ? XML.unescape((String)token2) : XML.stringToValue((String)token2)) : token2);
        }
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return (JSONArray)JSONML.parse(new XMLTokener(string), true, null, JSONMLParserConfiguration.ORIGINAL, 0);
    }

    public static JSONArray toJSONArray(String string, boolean keepStrings) throws JSONException {
        return (JSONArray)JSONML.parse(new XMLTokener(string), true, null, keepStrings, 0);
    }

    public static JSONArray toJSONArray(String string, JSONMLParserConfiguration config2) throws JSONException {
        return (JSONArray)JSONML.parse(new XMLTokener(string), true, null, config2, 0);
    }

    public static JSONArray toJSONArray(XMLTokener x, JSONMLParserConfiguration config2) throws JSONException {
        return (JSONArray)JSONML.parse(x, true, null, config2, 0);
    }

    public static JSONArray toJSONArray(XMLTokener x, boolean keepStrings) throws JSONException {
        return (JSONArray)JSONML.parse(x, true, null, keepStrings, 0);
    }

    public static JSONArray toJSONArray(XMLTokener x) throws JSONException {
        return (JSONArray)JSONML.parse(x, true, null, false, 0);
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return (JSONObject)JSONML.parse(new XMLTokener(string), false, null, false, 0);
    }

    public static JSONObject toJSONObject(String string, boolean keepStrings) throws JSONException {
        return (JSONObject)JSONML.parse(new XMLTokener(string), false, null, keepStrings, 0);
    }

    public static JSONObject toJSONObject(String string, JSONMLParserConfiguration config2) throws JSONException {
        return (JSONObject)JSONML.parse(new XMLTokener(string), false, null, config2, 0);
    }

    public static JSONObject toJSONObject(XMLTokener x) throws JSONException {
        return (JSONObject)JSONML.parse(x, false, null, false, 0);
    }

    public static JSONObject toJSONObject(XMLTokener x, boolean keepStrings) throws JSONException {
        return (JSONObject)JSONML.parse(x, false, null, keepStrings, 0);
    }

    public static JSONObject toJSONObject(XMLTokener x, JSONMLParserConfiguration config2) throws JSONException {
        return (JSONObject)JSONML.parse(x, false, null, config2, 0);
    }

    public static String toString(JSONArray ja) throws JSONException {
        int length;
        int i2;
        StringBuilder sb = new StringBuilder();
        String tagName2 = ja.getString(0);
        XML.noSpace(tagName2);
        tagName2 = XML.escape(tagName2);
        sb.append('<');
        sb.append(tagName2);
        Object object = ja.opt(1);
        if (object instanceof JSONObject) {
            i2 = 2;
            JSONObject jo = (JSONObject)object;
            for (String key2 : jo.keySet()) {
                Object value = jo.opt(key2);
                XML.noSpace(key2);
                if (value == null) continue;
                sb.append(' ');
                sb.append(XML.escape(key2));
                sb.append('=');
                sb.append('\"');
                sb.append(XML.escape(value.toString()));
                sb.append('\"');
            }
        } else {
            i2 = 1;
        }
        if (i2 >= (length = ja.length())) {
            sb.append('/');
            sb.append('>');
        } else {
            sb.append('>');
            do {
                object = ja.get(i2);
                ++i2;
                if (object == null) continue;
                if (object instanceof String) {
                    sb.append(XML.escape(object.toString()));
                    continue;
                }
                if (object instanceof JSONObject) {
                    sb.append(JSONML.toString((JSONObject)object));
                    continue;
                }
                if (object instanceof JSONArray) {
                    sb.append(JSONML.toString((JSONArray)object));
                    continue;
                }
                sb.append(object.toString());
            } while (i2 < length);
            sb.append('<');
            sb.append('/');
            sb.append(tagName2);
            sb.append('>');
        }
        return sb.toString();
    }

    public static String toString(JSONObject jo) throws JSONException {
        StringBuilder sb = new StringBuilder();
        String tagName2 = jo.optString("tagName");
        if (tagName2 == null) {
            return XML.escape(jo.toString());
        }
        XML.noSpace(tagName2);
        tagName2 = XML.escape(tagName2);
        sb.append('<');
        sb.append(tagName2);
        for (String key2 : jo.keySet()) {
            if ("tagName".equals(key2) || "childNodes".equals(key2)) continue;
            XML.noSpace(key2);
            Object value = jo.opt(key2);
            if (value == null) continue;
            sb.append(' ');
            sb.append(XML.escape(key2));
            sb.append('=');
            sb.append('\"');
            sb.append(XML.escape(value.toString()));
            sb.append('\"');
        }
        JSONArray ja = jo.optJSONArray("childNodes");
        if (ja == null) {
            sb.append('/');
            sb.append('>');
        } else {
            sb.append('>');
            int length = ja.length();
            for (int i2 = 0; i2 < length; ++i2) {
                Object object = ja.get(i2);
                if (object == null) continue;
                if (object instanceof String) {
                    sb.append(XML.escape(object.toString()));
                    continue;
                }
                if (object instanceof JSONObject) {
                    sb.append(JSONML.toString((JSONObject)object));
                    continue;
                }
                if (object instanceof JSONArray) {
                    sb.append(JSONML.toString((JSONArray)object));
                    continue;
                }
                sb.append(object.toString());
            }
            sb.append('<');
            sb.append('/');
            sb.append(tagName2);
            sb.append('>');
        }
        return sb.toString();
    }
}

