/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.max;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.junit.experimental.max.CouldNotReadCoreException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> fDurations = new HashMap<String, Long>();
    private final Map<String, Long> fFailureTimestamps = new HashMap<String, Long>();
    private final File fHistoryStore;

    public static MaxHistory forFolder(File file2) {
        if (file2.exists()) {
            try {
                return MaxHistory.readHistory(file2);
            }
            catch (CouldNotReadCoreException e) {
                e.printStackTrace();
                file2.delete();
            }
        }
        return new MaxHistory(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static MaxHistory readHistory(File storedResults) throws CouldNotReadCoreException {
        try {
            FileInputStream file2 = new FileInputStream(storedResults);
            try {
                MaxHistory maxHistory;
                ObjectInputStream stream = new ObjectInputStream(file2);
                try {
                    maxHistory = (MaxHistory)stream.readObject();
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return maxHistory;
            }
            finally {
                file2.close();
            }
        }
        catch (Exception e) {
            throw new CouldNotReadCoreException(e);
        }
    }

    private MaxHistory(File storedResults) {
        this.fHistoryStore = storedResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(new FileOutputStream(this.fHistoryStore));
            stream.writeObject(this);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    Long getFailureTimestamp(Description key2) {
        return this.fFailureTimestamps.get(key2.toString());
    }

    void putTestFailureTimestamp(Description key2, long end2) {
        this.fFailureTimestamps.put(key2.toString(), end2);
    }

    boolean isNewTest(Description key2) {
        return !this.fDurations.containsKey(key2.toString());
    }

    Long getTestDuration(Description key2) {
        return this.fDurations.get(key2.toString());
    }

    void putTestDuration(Description description2, long duration) {
        this.fDurations.put(description2.toString(), duration);
    }

    public RunListener listener() {
        return new RememberingListener();
    }

    public Comparator<Description> testComparator() {
        return new TestComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestComparator
    implements Comparator<Description> {
        private TestComparator() {
        }

        @Override
        public int compare(Description o1, Description o2) {
            if (MaxHistory.this.isNewTest(o1)) {
                return -1;
            }
            if (MaxHistory.this.isNewTest(o2)) {
                return 1;
            }
            int result2 = this.getFailure(o2).compareTo(this.getFailure(o1));
            return result2 != 0 ? result2 : MaxHistory.this.getTestDuration(o1).compareTo(MaxHistory.this.getTestDuration(o2));
        }

        private Long getFailure(Description key2) {
            Long result2 = MaxHistory.this.getFailureTimestamp(key2);
            if (result2 == null) {
                return 0L;
            }
            return result2;
        }
    }

    private final class RememberingListener
    extends RunListener {
        private long overallStart = System.currentTimeMillis();
        private Map<Description, Long> starts = new HashMap<Description, Long>();

        private RememberingListener() {
        }

        public void testStarted(Description description2) throws Exception {
            this.starts.put(description2, System.nanoTime());
        }

        public void testFinished(Description description2) throws Exception {
            long end2 = System.nanoTime();
            long start2 = this.starts.get(description2);
            MaxHistory.this.putTestDuration(description2, end2 - start2);
        }

        public void testFailure(Failure failure) throws Exception {
            MaxHistory.this.putTestFailureTimestamp(failure.getDescription(), this.overallStart);
        }

        public void testRunFinished(Result result2) throws Exception {
            MaxHistory.this.save();
        }
    }
}

