/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.RuleContainer;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MemberValueConsumer;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.junit.validator.PublicClassValidator;
import org.junit.validator.TestClassValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockJUnit4ClassRunner
extends ParentRunner<FrameworkMethod> {
    private static TestClassValidator PUBLIC_CLASS_VALIDATOR = new PublicClassValidator();
    private final ConcurrentMap<FrameworkMethod, Description> methodDescriptions = new ConcurrentHashMap<FrameworkMethod, Description>();
    private static final ThreadLocal<RuleContainer> CURRENT_RULE_CONTAINER = new ThreadLocal();

    public BlockJUnit4ClassRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected BlockJUnit4ClassRunner(TestClass testClass) throws InitializationError {
        super(testClass);
    }

    @Override
    protected void runChild(final FrameworkMethod method2, RunNotifier notifier) {
        Description description2 = this.describeChild(method2);
        if (this.isIgnored(method2)) {
            notifier.fireTestIgnored(description2);
        } else {
            Statement statement2 = new Statement(){

                public void evaluate() throws Throwable {
                    BlockJUnit4ClassRunner.this.methodBlock(method2).evaluate();
                }
            };
            this.runLeaf(statement2, description2, notifier);
        }
    }

    @Override
    protected boolean isIgnored(FrameworkMethod child2) {
        return child2.getAnnotation(Ignore.class) != null;
    }

    @Override
    protected Description describeChild(FrameworkMethod method2) {
        Description description2 = (Description)this.methodDescriptions.get(method2);
        if (description2 == null) {
            description2 = Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(method2), method2.getAnnotations());
            this.methodDescriptions.putIfAbsent(method2, description2);
        }
        return description2;
    }

    @Override
    protected List<FrameworkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validatePublicConstructor(errors);
        this.validateNoNonStaticInnerClass(errors);
        this.validateConstructor(errors);
        this.validateInstanceMethods(errors);
        this.validateFields(errors);
        this.validateMethods(errors);
    }

    private void validatePublicConstructor(List<Throwable> errors) {
        if (this.getTestClass().getJavaClass() != null) {
            errors.addAll(PUBLIC_CLASS_VALIDATOR.validateTestClass(this.getTestClass()));
        }
    }

    protected void validateNoNonStaticInnerClass(List<Throwable> errors) {
        if (this.getTestClass().isANonStaticInnerClass()) {
            String gripe = "The inner class " + this.getTestClass().getName() + " is not static.";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        this.validateZeroArgConstructor(errors);
    }

    protected void validateOnlyOneConstructor(List<Throwable> errors) {
        if (!this.hasOneConstructor()) {
            String gripe = "Test class should have exactly one public constructor";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
        if (!this.getTestClass().isANonStaticInnerClass() && this.hasOneConstructor() && this.getTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
            String gripe = "Test class should have exactly one public zero-argument constructor";
            errors.add(new Exception(gripe));
        }
    }

    private boolean hasOneConstructor() {
        return this.getTestClass().getJavaClass().getConstructors().length == 1;
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.computeTestMethods().isEmpty()) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    protected void validateFields(List<Throwable> errors) {
        RuleMemberValidator.RULE_VALIDATOR.validate(this.getTestClass(), errors);
    }

    private void validateMethods(List<Throwable> errors) {
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.getTestClass(), errors);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
    }

    protected Object createTest(FrameworkMethod method2) throws Exception {
        return this.createTest();
    }

    protected String testName(FrameworkMethod method2) {
        return method2.getName();
    }

    protected Statement methodBlock(final FrameworkMethod method2) {
        Object test;
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return BlockJUnit4ClassRunner.this.createTest(method2);
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement2 = this.methodInvoker(method2, test);
        statement2 = this.possiblyExpectingExceptions(method2, test, statement2);
        statement2 = this.withPotentialTimeout(method2, test, statement2);
        statement2 = this.withBefores(method2, test, statement2);
        statement2 = this.withAfters(method2, test, statement2);
        statement2 = this.withRules(method2, test, statement2);
        statement2 = this.withInterruptIsolation(statement2);
        return statement2;
    }

    protected Statement methodInvoker(FrameworkMethod method2, Object test) {
        return new InvokeMethod(method2, test);
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method2, Object test, Statement next) {
        Test annotation = method2.getAnnotation(Test.class);
        Class<? extends Throwable> expectedExceptionClass = this.getExpectedException(annotation);
        return expectedExceptionClass != null ? new ExpectException(next, expectedExceptionClass) : next;
    }

    @Deprecated
    protected Statement withPotentialTimeout(FrameworkMethod method2, Object test, Statement next) {
        long timeout2 = this.getTimeout(method2.getAnnotation(Test.class));
        if (timeout2 <= 0L) {
            return next;
        }
        return FailOnTimeout.builder().withTimeout(timeout2, TimeUnit.MILLISECONDS).build(next);
    }

    protected Statement withBefores(FrameworkMethod method2, Object target, Statement statement2) {
        List<FrameworkMethod> befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement2 : new RunBefores(statement2, befores, target);
    }

    protected Statement withAfters(FrameworkMethod method2, Object target, Statement statement2) {
        List<FrameworkMethod> afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement2 : new RunAfters(statement2, afters, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement withRules(FrameworkMethod method2, Object target, Statement statement2) {
        RuleContainer ruleContainer = new RuleContainer();
        CURRENT_RULE_CONTAINER.set(ruleContainer);
        try {
            List<TestRule> testRules = this.getTestRules(target);
            for (MethodRule each : this.rules(target)) {
                if (each instanceof TestRule && testRules.contains(each)) continue;
                ruleContainer.add(each);
            }
            for (TestRule rule : testRules) {
                ruleContainer.add(rule);
            }
        }
        finally {
            CURRENT_RULE_CONTAINER.remove();
        }
        return ruleContainer.apply(method2, this.describeChild(method2), target, statement2);
    }

    protected List<MethodRule> rules(Object target) {
        RuleCollector collector2 = new RuleCollector();
        this.getTestClass().collectAnnotatedMethodValues(target, Rule.class, MethodRule.class, collector2);
        this.getTestClass().collectAnnotatedFieldValues(target, Rule.class, MethodRule.class, collector2);
        return collector2.result;
    }

    protected List<TestRule> getTestRules(Object target) {
        RuleCollector collector2 = new RuleCollector();
        this.getTestClass().collectAnnotatedMethodValues(target, Rule.class, TestRule.class, collector2);
        this.getTestClass().collectAnnotatedFieldValues(target, Rule.class, TestRule.class, collector2);
        return collector2.result;
    }

    private Class<? extends Throwable> getExpectedException(Test annotation) {
        if (annotation == null || annotation.expected() == Test.None.class) {
            return null;
        }
        return annotation.expected();
    }

    private long getTimeout(Test annotation) {
        if (annotation == null) {
            return 0L;
        }
        return annotation.timeout();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuleCollector<T>
    implements MemberValueConsumer<T> {
        final List<T> result = new ArrayList<T>();

        private RuleCollector() {
        }

        @Override
        public void accept(FrameworkMember<?> member, T value) {
            RuleContainer container2;
            Rule rule = member.getAnnotation(Rule.class);
            if (rule != null && (container2 = (RuleContainer)CURRENT_RULE_CONTAINER.get()) != null) {
                container2.setOrder(value, rule.order());
            }
            this.result.add(value);
        }
    }
}

