/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.parameterized;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.parameterized.TestWithParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockJUnit4ClassRunnerWithParameters
extends BlockJUnit4ClassRunner {
    private final Object[] parameters;
    private final String name;

    public BlockJUnit4ClassRunnerWithParameters(TestWithParameters test) throws InitializationError {
        super(test.getTestClass());
        this.parameters = test.getParameters().toArray(new Object[test.getParameters().size()]);
        this.name = test.getName();
    }

    @Override
    public Object createTest() throws Exception {
        InjectionType injectionType = this.getInjectionType();
        switch (injectionType) {
            case CONSTRUCTOR: {
                return this.createTestUsingConstructorInjection();
            }
            case FIELD: {
                return this.createTestUsingFieldInjection();
            }
        }
        throw new IllegalStateException("The injection type " + (Object)((Object)injectionType) + " is not supported.");
    }

    private Object createTestUsingConstructorInjection() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
    }

    private Object createTestUsingFieldInjection() throws Exception {
        List<FrameworkField> annotatedFieldsByParameter = this.getAnnotatedFieldsByParameter();
        if (annotatedFieldsByParameter.size() != this.parameters.length) {
            throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.parameters.length + ".");
        }
        Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
        for (FrameworkField each : annotatedFieldsByParameter) {
            Field field = each.getField();
            Parameterized.Parameter annotation = field.getAnnotation(Parameterized.Parameter.class);
            int index = annotation.value();
            try {
                field.set(testClassInstance, this.parameters[index]);
            }
            catch (IllegalAccessException e) {
                IllegalAccessException wrappedException = new IllegalAccessException("Cannot set parameter '" + field.getName() + "'. Ensure that the field '" + field.getName() + "' is public.");
                wrappedException.initCause(e);
                throw wrappedException;
            }
            catch (IllegalArgumentException iare) {
                throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.parameters[index] + " that is not the right type (" + this.parameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
            }
        }
        return testClassInstance;
    }

    @Override
    protected String getName() {
        return this.name;
    }

    @Override
    protected String testName(FrameworkMethod method2) {
        return method2.getName() + this.getName();
    }

    @Override
    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        if (this.getInjectionType() != InjectionType.CONSTRUCTOR) {
            this.validateZeroArgConstructor(errors);
        }
    }

    @Override
    protected void validateFields(List<Throwable> errors) {
        super.validateFields(errors);
        if (this.getInjectionType() == InjectionType.FIELD) {
            List<FrameworkField> annotatedFieldsByParameter = this.getAnnotatedFieldsByParameter();
            int[] usedIndices = new int[annotatedFieldsByParameter.size()];
            for (FrameworkField each : annotatedFieldsByParameter) {
                int index = each.getField().getAnnotation(Parameterized.Parameter.class).value();
                if (index < 0 || index > annotatedFieldsByParameter.size() - 1) {
                    errors.add(new Exception("Invalid @Parameter value: " + index + ". @Parameter fields counted: " + annotatedFieldsByParameter.size() + ". Please use an index between 0 and " + (annotatedFieldsByParameter.size() - 1) + "."));
                    continue;
                }
                int n = index;
                usedIndices[n] = usedIndices[n] + 1;
            }
            for (int index = 0; index < usedIndices.length; ++index) {
                int numberOfUse = usedIndices[index];
                if (numberOfUse == 0) {
                    errors.add(new Exception("@Parameter(" + index + ") is never used."));
                    continue;
                }
                if (numberOfUse <= 1) continue;
                errors.add(new Exception("@Parameter(" + index + ") is used more than once (" + numberOfUse + ")."));
            }
        }
    }

    @Override
    protected Statement classBlock(RunNotifier notifier) {
        Statement statement2 = this.childrenInvoker(notifier);
        statement2 = this.withBeforeParams(statement2);
        statement2 = this.withAfterParams(statement2);
        return statement2;
    }

    private Statement withBeforeParams(Statement statement2) {
        List<FrameworkMethod> befores = this.getTestClass().getAnnotatedMethods(Parameterized.BeforeParam.class);
        return befores.isEmpty() ? statement2 : new RunBeforeParams(statement2, befores);
    }

    private Statement withAfterParams(Statement statement2) {
        List<FrameworkMethod> afters = this.getTestClass().getAnnotatedMethods(Parameterized.AfterParam.class);
        return afters.isEmpty() ? statement2 : new RunAfterParams(statement2, afters);
    }

    @Override
    protected Annotation[] getRunnerAnnotations() {
        Annotation[] allAnnotations = super.getRunnerAnnotations();
        Annotation[] annotationsWithoutRunWith = new Annotation[allAnnotations.length - 1];
        int i2 = 0;
        for (Annotation annotation : allAnnotations) {
            if (annotation.annotationType().equals(RunWith.class)) continue;
            annotationsWithoutRunWith[i2] = annotation;
            ++i2;
        }
        return annotationsWithoutRunWith;
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    private InjectionType getInjectionType() {
        if (this.fieldsAreAnnotated()) {
            return InjectionType.FIELD;
        }
        return InjectionType.CONSTRUCTOR;
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunAfterParams
    extends RunAfters {
        RunAfterParams(Statement next, List<FrameworkMethod> afters) {
            super(next, afters, null);
        }

        @Override
        protected void invokeMethod(FrameworkMethod method2) throws Throwable {
            int paramCount = method2.getMethod().getParameterTypes().length;
            method2.invokeExplosively(null, paramCount == 0 ? (Object[])null : BlockJUnit4ClassRunnerWithParameters.this.parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunBeforeParams
    extends RunBefores {
        RunBeforeParams(Statement next, List<FrameworkMethod> befores) {
            super(next, befores, null);
        }

        @Override
        protected void invokeMethod(FrameworkMethod method2) throws Throwable {
            int paramCount = method2.getMethod().getParameterTypes().length;
            method2.invokeExplosively(null, paramCount == 0 ? (Object[])null : BlockJUnit4ClassRunnerWithParameters.this.parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InjectionType {
        CONSTRUCTOR,
        FIELD;

    }
}

