/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.util.ext;

import com.ustadmobile.core.util.ext.JobDataMapExtKt;
import com.ustadmobile.door.util.SystemTimeKt;
import io.github.aakira.napier.Napier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DI;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u000f\u001a\u00020\u0010*\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0003\u001a\"\u0010\u0015\u001a\u00020\u0010*\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010\u001c\u001a\u00020\u0010*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"(\u0010\n\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"DEFAULT_RETRY_WAIT", "", "RETRY_WAIT_KEY", "", "di", "Lorg/kodein/di/DI;", "Lorg/quartz/Scheduler;", "getDi", "(Lorg/quartz/Scheduler;)Lorg/kodein/di/DI;", "value", "retryWait", "getRetryWait", "(Lorg/quartz/Scheduler;)J", "setRetryWait", "(Lorg/quartz/Scheduler;J)V", "interruptJobs", "", "triggerKeys", "", "Lorg/quartz/TriggerKey;", "cause", "scheduleRetryOrThrow", "Lorg/quartz/JobExecutionContext;", "jobClass", "Ljava/lang/Class;", "Lorg/quartz/Job;", "maxAttemptsAllowed", "", "unscheduleAnyExistingAndStartNow", "job", "Lorg/quartz/JobDetail;", "triggerKey", "core"})
@SourceDebugExtension(value={"SMAP\nSchedulerExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedulerExt.kt\ncom/ustadmobile/core/util/ext/SchedulerExtKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n766#2:102\n857#2,2:103\n1855#2,2:105\n*S KotlinDebug\n*F\n+ 1 SchedulerExt.kt\ncom/ustadmobile/core/util/ext/SchedulerExtKt\n*L\n86#1:102\n86#1:103,2\n90#1:105,2\n*E\n"})
public final class SchedulerExtKt {
    @NotNull
    private static final String RETRY_WAIT_KEY = "com.ustadmobile.wait";
    private static final long DEFAULT_RETRY_WAIT = 10000L;

    public static final long getRetryWait(@NotNull Scheduler $this$retryWait) {
        Intrinsics.checkNotNullParameter((Object)$this$retryWait, (String)"<this>");
        return $this$retryWait.getContext().containsKey((Object)RETRY_WAIT_KEY) ? $this$retryWait.getContext().getLong(RETRY_WAIT_KEY) : 10000L;
    }

    public static final void setRetryWait(@NotNull Scheduler $this$retryWait, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$retryWait, (String)"<this>");
        $this$retryWait.getContext().put(RETRY_WAIT_KEY, value);
    }

    @NotNull
    public static final DI getDi(@NotNull Scheduler $this$di) {
        Intrinsics.checkNotNullParameter((Object)$this$di, (String)"<this>");
        SchedulerContext schedulerContext = $this$di.getContext();
        Object object = schedulerContext != null ? schedulerContext.get((Object)"di") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kodein.di.DI");
        return (DI)object;
    }

    public static final void scheduleRetryOrThrow(@NotNull JobExecutionContext $this$scheduleRetryOrThrow, @NotNull Class<? extends Job> jobClass, int maxAttemptsAllowed) {
        int attemptCount;
        Intrinsics.checkNotNullParameter((Object)$this$scheduleRetryOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter(jobClass, (String)"jobClass");
        JobDataMap jobDataMap = $this$scheduleRetryOrThrow.getJobDetail().getJobDataMap();
        Intrinsics.checkNotNull((Object)jobDataMap);
        Integer n = JobDataMapExtKt.getIntOrNull(jobDataMap, "attempts");
        int n2 = attemptCount = n != null ? n : 1;
        if (attemptCount >= maxAttemptsAllowed) {
            throw new IllegalStateException("Cannot reschedule: " + $this$scheduleRetryOrThrow.getTrigger().getKey().getName() + ": attempts exceed " + maxAttemptsAllowed);
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(new TriggerKey($this$scheduleRetryOrThrow.getTrigger().getKey().getName() + "-retry-" + attemptCount, $this$scheduleRetryOrThrow.getTrigger().getKey().getGroup()));
        long l = SystemTimeKt.systemTimeInMillis();
        Scheduler scheduler = $this$scheduleRetryOrThrow.getScheduler();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"getScheduler(...)");
        Trigger trigger = triggerBuilder.startAt(new Date(l + SchedulerExtKt.getRetryWait(scheduler))).build();
        JobDetail jobDetail = JobBuilder.newJob(jobClass).usingJobData($this$scheduleRetryOrThrow.getMergedJobDataMap()).usingJobData("attempts", Integer.valueOf(attemptCount + 1)).build();
        Napier.d$default((Napier)Napier.INSTANCE, (String)("scheduleRetryOrThrow: attempt " + attemptCount + " failed, rescheduling"), null, null, (int)6, null);
        $this$scheduleRetryOrThrow.getScheduler().scheduleJob(jobDetail, trigger);
    }

    public static final void unscheduleAnyExistingAndStartNow(@NotNull Scheduler $this$unscheduleAnyExistingAndStartNow, @NotNull JobDetail job, @NotNull TriggerKey triggerKey) {
        Intrinsics.checkNotNullParameter((Object)$this$unscheduleAnyExistingAndStartNow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)triggerKey, (String)"triggerKey");
        Trigger jobTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startNow().build();
        Napier.d$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(triggerKey){
            final /* synthetic */ TriggerKey $triggerKey;
            {
                this.$triggerKey = $triggerKey;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "SchedulerExt: scheduleJob with replace " + this.$triggerKey;
            }
        }), (int)3, null);
        $this$unscheduleAnyExistingAndStartNow.scheduleJob(job, SetsKt.setOf((Object)jobTrigger), true);
        Napier.d$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(triggerKey){
            final /* synthetic */ TriggerKey $triggerKey;
            {
                this.$triggerKey = $triggerKey;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "SchedulerExt: scheduleJob with replace " + this.$triggerKey + " : completed";
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void interruptJobs(@NotNull Scheduler $this$interruptJobs, @NotNull List<TriggerKey> triggerKeys, @NotNull String cause) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$interruptJobs, (String)"<this>");
        Intrinsics.checkNotNullParameter(triggerKeys, (String)"triggerKeys");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        List list = $this$interruptJobs.getCurrentlyExecutingJobs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentlyExecutingJobs(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JobExecutionContext it = (JobExecutionContext)element$iv$iv;
            boolean bl = false;
            if (!triggerKeys.contains(it.getTrigger().getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jobsToInterrupt = (List)destination$iv$iv;
        Iterable $this$forEach$iv = jobsToInterrupt;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JobExecutionContext it = (JobExecutionContext)element$iv;
            boolean bl = false;
            TriggerKey triggerKey = it.getTrigger().getKey();
            try {
                $this$interruptJobs.interrupt(it.getFireInstanceId());
                Napier.d$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(triggerKey, cause){
                    final /* synthetic */ TriggerKey $triggerKey;
                    final /* synthetic */ String $cause;
                    {
                        this.$triggerKey = $triggerKey;
                        this.$cause = $cause;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Scheduler.interruptJobs: interrupted " + this.$triggerKey + " for cause: " + this.$cause;
                    }
                }), (int)3, null);
            }
            catch (Throwable e) {
                Napier.w$default((Napier)Napier.INSTANCE, (Throwable)e, null, (Function0)((Function0)new Function0<String>(triggerKey, cause){
                    final /* synthetic */ TriggerKey $triggerKey;
                    final /* synthetic */ String $cause;
                    {
                        this.$triggerKey = $triggerKey;
                        this.$cause = $cause;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Scheduler.interruptJobs: Exception attempting to interrupt " + this.$triggerKey + " for cause: " + this.$cause;
                    }
                }), (int)2, null);
            }
        }
    }
}

