/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersJvmKt;
import kotlinx.io.RealSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u000f\u001a\u00020\n*\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"asByteChannel", "Ljava/nio/channels/ReadableByteChannel;", "Lkotlinx/io/Source;", "asInputStream", "Ljava/io/InputStream;", "readAtMostTo", "", "sink", "Ljava/nio/ByteBuffer;", "readString", "", "charset", "Ljava/nio/charset/Charset;", "byteCount", "", "readStringImpl", "Lkotlinx/io/Buffer;", "kotlinx-io-core"})
public final class SourcesJvmKt {
    private static final String readStringImpl(Buffer $this$readStringImpl, long byteCount, Charset charset) {
        if (!(byteCount >= 0L && byteCount <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-SourcesJvmKt$readStringImpl$22 = false;
            String $i$a$-require-SourcesJvmKt$readStringImpl$22 = "byteCount (" + byteCount + ") is not within the range [0..2147483647)";
            throw new IllegalArgumentException($i$a$-require-SourcesJvmKt$readStringImpl$22.toString());
        }
        if ($this$readStringImpl.getSize() < byteCount) {
            throw new EOFException("Buffer contains less bytes then required (byteCount: " + byteCount + ", size: " + $this$readStringImpl.getSize() + ')');
        }
        if (byteCount == 0L) {
            return "";
        }
        Segment segment = $this$readStringImpl.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        if ((long)s.pos + byteCount > (long)s.limit) {
            return new String(SourcesKt.readByteArray($this$readStringImpl, (int)byteCount), charset);
        }
        String result = new String(s.data, s.pos, (int)byteCount, charset);
        s.pos += (int)byteCount;
        $this$readStringImpl.setSize$kotlinx_io_core($this$readStringImpl.getSize() - byteCount);
        if (s.pos == s.limit) {
            $this$readStringImpl.head = s.pop();
            SegmentPool.recycle(s);
        }
        return result;
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        long req = 1L;
        while ($this$readString.request(req)) {
            req *= (long)2;
        }
        return SourcesJvmKt.readStringImpl($this$readString.getBuffer(), $this$readString.getBuffer().getSize(), charset);
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString, long byteCount, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        $this$readString.require(byteCount);
        return SourcesJvmKt.readStringImpl($this$readString.getBuffer(), byteCount, charset);
    }

    @NotNull
    public static final InputStream asInputStream(@NotNull Source $this$asInputStream) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)$this$asInputStream, (String)"<this>");
        Source source = $this$asInputStream;
        if (source instanceof RealSource) {
            function0 = (Function0)new MutablePropertyReference0Impl($this$asInputStream){

                @Nullable
                public Object get() {
                    return ((RealSource)this.receiver).closed;
                }

                public void set(@Nullable Object value) {
                    ((RealSource)this.receiver).closed = (Boolean)value;
                }
            };
        } else if (source instanceof Buffer) {
            function0 = asInputStream.isClosed.2.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0 isClosed2 = function0;
        return new InputStream((Function0<Boolean>)isClosed2, $this$asInputStream){
            final /* synthetic */ Function0<Boolean> $isClosed;
            final /* synthetic */ Source $this_asInputStream;
            {
                this.$isClosed = $isClosed;
                this.$this_asInputStream = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public int read() {
                void $this$and$iv;
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying source is closed.");
                }
                if (this.$this_asInputStream.exhausted()) {
                    return -1;
                }
                byte by = this.$this_asInputStream.readByte();
                int other$iv = 255;
                boolean $i$f$and = false;
                return $this$and$iv & other$iv;
            }

            public int read(@NotNull byte[] data, int offset, int byteCount) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying source is closed.");
                }
                _UtilKt.checkOffsetAndCount(data.length, offset, byteCount);
                return this.$this_asInputStream.readAtMostTo(data, offset, offset + byteCount);
            }

            /*
             * WARNING - void declaration
             */
            public int available() {
                void a$iv;
                if (((Boolean)this.$isClosed.invoke()).booleanValue()) {
                    throw new IOException("Underlying source is closed.");
                }
                long l = this.$this_asInputStream.getBuffer().getSize();
                int b$iv = Integer.MAX_VALUE;
                boolean $i$f$minOf = false;
                return (int)Math.min((long)a$iv, (long)b$iv);
            }

            public void close() {
                this.$this_asInputStream.close();
            }

            @NotNull
            public String toString() {
                return this.$this_asInputStream + ".asInputStream()";
            }
        };
    }

    public static final int readAtMostTo(@NotNull Source $this$readAtMostTo, @NotNull ByteBuffer sink) {
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if ($this$readAtMostTo.getBuffer().getSize() == 0L) {
            $this$readAtMostTo.request(8192L);
            if ($this$readAtMostTo.getBuffer().getSize() == 0L) {
                return -1;
            }
        }
        return BuffersJvmKt.readAtMostTo($this$readAtMostTo.getBuffer(), sink);
    }

    @NotNull
    public static final ReadableByteChannel asByteChannel(@NotNull Source $this$asByteChannel) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)$this$asByteChannel, (String)"<this>");
        Source source = $this$asByteChannel;
        if (source instanceof RealSource) {
            function0 = (Function0)new MutablePropertyReference0Impl($this$asByteChannel){

                @Nullable
                public Object get() {
                    return ((RealSource)this.receiver).closed;
                }

                public void set(@Nullable Object value) {
                    ((RealSource)this.receiver).closed = (Boolean)value;
                }
            };
        } else if (source instanceof Buffer) {
            function0 = asByteChannel.isClosed.2.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function0 isClosed2 = function0;
        return new ReadableByteChannel($this$asByteChannel, (Function0<Boolean>)isClosed2){
            final /* synthetic */ Source $this_asByteChannel;
            final /* synthetic */ Function0<Boolean> $isClosed;
            {
                this.$this_asByteChannel = $receiver;
                this.$isClosed = $isClosed;
            }

            public void close() {
                this.$this_asByteChannel.close();
            }

            public boolean isOpen() {
                return (Boolean)this.$isClosed.invoke() == false;
            }

            public int read(@NotNull ByteBuffer sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                return SourcesJvmKt.readAtMostTo(this.$this_asByteChannel, sink);
            }
        };
    }
}

