/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import net.bramp.ffmpeg.nut.NutDataInputStream;
import net.bramp.ffmpeg.nut.Packet;

public class PacketHeader {
    long startcode;
    long forwardPtr;
    int checksum;
    long end;

    public void read(NutDataInputStream in, long startcode) throws IOException {
        this.startcode = startcode;
        this.forwardPtr = in.readVarLong();
        if (this.forwardPtr > 4096L) {
            long expected = in.getCRC();
            this.checksum = in.readInt();
            if ((long)this.checksum != expected) {
                throw new IOException(String.format("invalid header checksum %X want %X", expected, this.checksum));
            }
        }
        in.resetCRC();
        this.end = in.offset() + this.forwardPtr - 4L;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("startcode", (Object)Packet.Startcode.toString(this.startcode)).add("forwardPtr", this.forwardPtr);
        if (this.forwardPtr > 4096L) {
            helper = helper.add("checksum", this.checksum);
        }
        return helper.toString();
    }
}

