import { p as Mutation, o as Query, K as QueryOptions, ax as MutationOptions, b as QueryClient, at as MutationKey, q as MutationState, av as MutationMeta, t as QueryKey, n as QueryState, F as QueryMeta } from './queryClient-Iu1tSaKE.js';
import './removable.js';
import './subscribable.js';

interface DehydrateOptions {
    shouldDehydrateMutation?: (mutation: Mutation) => boolean;
    shouldDehydrateQuery?: (query: Query) => boolean;
}
interface HydrateOptions {
    defaultOptions?: {
        queries?: QueryOptions;
        mutations?: MutationOptions;
    };
}
interface DehydratedMutation {
    mutationKey?: MutationKey;
    state: MutationState;
    meta?: MutationMeta;
}
interface DehydratedQuery {
    queryHash: string;
    queryKey: QueryKey;
    state: QueryState;
    meta?: QueryMeta;
}
interface DehydratedState {
    mutations: Array<DehydratedMutation>;
    queries: Array<DehydratedQuery>;
}
declare function defaultShouldDehydrateMutation(mutation: Mutation): boolean;
declare function defaultShouldDehydrateQuery(query: Query): boolean;
declare function dehydrate(client: QueryClient, options?: DehydrateOptions): DehydratedState;
declare function hydrate(client: QueryClient, dehydratedState: unknown, options?: HydrateOptions): void;

export { type DehydrateOptions, type DehydratedState, type HydrateOptions, defaultShouldDehydrateMutation, defaultShouldDehydrateQuery, dehydrate, hydrate };
