
module.exports = function(config) {

config.set({
  "singleRun": true,
  "autoWatch": false,
  "basePath": "/home/jenkins/.jenkins/workspace/dev-simplified-onboarding/build/js/packages/UstadMobile-app-react-test",
  "files": [
    "/home/jenkins/.jenkins/workspace/dev-simplified-onboarding/build/js/packages_imported/kotlin-test-js-runner/0.0.1/kotlin-test-karma-runner.js",
    "/home/jenkins/.jenkins/workspace/dev-simplified-onboarding/build/js/packages/UstadMobile-app-react-test/kotlin/UstadMobile-app-react-test.js"
  ],
  "frameworks": [
    "mocha",
    "webpack"
  ],
  "client": {
    "args": []
  },
  "browsers": [
    "ChromeHeadless"
  ],
  "customLaunchers": {},
  "failOnFailingTestSuite": false,
  "failOnEmptyTestSuite": false,
  "reporters": [
    "karma-kotlin-reporter"
  ],
  "preprocessors": {
    "/home/jenkins/.jenkins/workspace/dev-simplified-onboarding/build/js/packages_imported/kotlin-test-js-runner/0.0.1/kotlin-test-karma-runner.js": [
      "webpack",
      "sourcemap"
    ],
    "/home/jenkins/.jenkins/workspace/dev-simplified-onboarding/build/js/packages/UstadMobile-app-react-test/kotlin/UstadMobile-app-react-test.js": [
      "webpack",
      "sourcemap"
    ]
  },
  "proxies": {}
});
config.plugins = config.plugins || [];
config.plugins.push('kotlin-test-js-runner/karma-kotlin-reporter.js');

config.loggers = [
    {
        type: 'kotlin-test-js-runner/tc-log-appender.js',
        //default layout
        layout: { type: 'pattern', pattern: '%[%d{DATETIME}:%p [%c]: %]%m' }
    }
]

// webpack config
function createWebpackConfig() {
let config = {
  mode: 'development',
  resolve: {
    modules: [
      "node_modules"
    ]
  },
  plugins: [],
  module: {
    rules: []
  }
};

    // source maps
    config.module.rules.push({
            test: /\.m?js$/,
            use: ["source-map-loader"],
            enforce: "pre"
    });
    config.devtool = false;
config.ignoreWarnings = [/Failed to parse source map/]
    
                // optimization
                config.optimization = config.optimization || {
  "splitChunks": false
};
// Report progress to console
// noinspection JSUnnecessarySemicolon
;(function(config) {
    const webpack = require('webpack');
    const handler = (percentage, message, ...args) => {
        const p = percentage * 100;
        let msg = `${Math.trunc(p / 10)}${Math.trunc(p % 10)}% ${message} ${args.join(' ')}`;
        ;
        console.log(msg);
    };

    config.plugins.push(new webpack.ProgressPlugin(handler))
})(config);

// KotlinWebpackCssRule[css]
;(function(config) {
            const use = [{
    loader: 'style-loader',
    options: {}
},{
    loader: 'css-loader',
    options: {}
}]
config.module.rules.push({
    test: /\.css$/,
    use: use,
    exclude: undefined,
    include: undefined,
})
})(config);

// noinspection JSUnnecessarySemicolon
;(function(config) {
    const tcErrorPlugin = require('kotlin-test-js-runner/tc-log-error-webpack');
    config.plugins.push(new tcErrorPlugin())
    config.stats = config.stats || {}
    Object.assign(config.stats, config.stats, {
        warnings: false,
        errors: false
    })
})(config);

// moko-resources-generated.js
// noinspection JSUnnecessarySemicolon
;(function(config) {
    const path = require('path');
    const MiniCssExtractPlugin = require('mini-css-extract-plugin');

    const mokoResourcePath = path.resolve("/home/jenkins/.jenkins/workspace/dev-simplified-onboarding/app-react/build/generated/moko/jsMain/comustadmobileappreact/res");

    config.module.rules.push(
        {
            test: /\.(.*)/,
            resource: [
                path.resolve(mokoResourcePath, "files"),
                path.resolve(mokoResourcePath, "images"),
                path.resolve(mokoResourcePath, "localization"),
            ],
            type: 'asset/resource'
        }
    );
    
    config.plugins.push(new MiniCssExtractPlugin())
    config.module.rules.push(
        {
            test: /\.css$/,
            resource: [
                path.resolve(mokoResourcePath, "fonts"),
            ],
            use: ['style-loader', 'css-loader']
        }
    )

    config.module.rules.push(
        {
            test: /\.(otf|ttf)?$/,
            resource: [
                path.resolve(mokoResourcePath, "fonts"),
            ],
            type: 'asset/resource',
        }
    )
    
    config.resolve.modules.push(mokoResourcePath);
})(config);

// no-fs-buffer-polyfill.js
/*
 * Prevent webpack errors - we do not want to include polyfills for the below
 */
config.resolve.fallback = {
    "fs": false,
    "buffer": false,
    "path": false
};



config.experiments = {
    topLevelAwait: true,
}
// noinspection JSUnnecessarySemicolon
;(function(config) {
    const webpack = require('webpack');

    // https://github.com/webpack/webpack/issues/12951
    const PatchSourceMapSource = require('kotlin-test-js-runner/webpack-5-debug');
    config.plugins.push(new PatchSourceMapSource())
    
    config.plugins.push(new webpack.SourceMapDevToolPlugin({
        moduleFilenameTemplate: "[absolute-resource-path]"
    }))
})(config);
   return config;
}

config.set({webpack: createWebpackConfig()});


// moko-resources-generated.js
// workaround from https://github.com/ryanclark/karma-webpack/issues/498#issuecomment-790040818

const output = {
  path: require("os").tmpdir() + '/' + '_karma_webpack_' + Math.floor(Math.random() * 1000000),
}

config.set(
    {
        webpack: {... createWebpackConfig(), output},
        files: config.files.concat([{
                pattern: `${output.path}/**/*`,
                watched: false,
                included: false,
            }]
        )
    }
)



}
