package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLangName
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLanguage
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class ContentEntryRelatedEntryJoinDao : BaseDao<ContentEntryRelatedEntryJoin>
    {
  @Query(`value` =
      "SELECT ContentEntryRelatedEntryJoin.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntry ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publik")
  public actual abstract fun publicContentEntryRelatedEntryJoins():
      List<ContentEntryRelatedEntryJoin>

  @Query(`value` =
      "SELECT * FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = :contentEntryUid LIMIT 1")
  public actual abstract fun findPrimaryByTranslation(contentEntryUid: Long):
      ContentEntryRelatedEntryJoin?

  @Query(`value` =
      "SELECT ContentEntryRelatedEntryJoin.cerejContentEntryUid, ContentEntryRelatedEntryJoin.cerejRelatedEntryUid, CASE ContentEntryRelatedEntryJoin.cerejRelatedEntryUid WHEN :contentEntryUid THEN (SELECT name FROM Language WHERE langUid = (SELECT primaryLanguageUid FROM ContentEntry WHERE contentEntryUid = ContentEntryRelatedEntryJoin.cerejContentEntryUid)) ELSE Language.name END languageName FROM ContentEntryRelatedEntryJoin LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = :contentEntryUid OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = :contentEntryUid)) AND ContentEntryRelatedEntryJoin.relType = 1")
  public actual abstract suspend fun findAllTranslationsForContentEntryAsync(contentEntryUid: Long):
      List<ContentEntryRelatedEntryJoinWithLangName>

  @Query(`value` =
      "SELECT ContentEntryRelatedEntryJoin.*, Language.* FROM ContentEntryRelatedEntryJoin\n        LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid\n        WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = :contentEntryUid\n        OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN\n        (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = :contentEntryUid))\n        AND ContentEntryRelatedEntryJoin.relType = 1\n        ORDER BY Language.name")
  public actual abstract fun findAllTranslationsWithContentEntryUid(contentEntryUid: Long):
      PagingSource<Int, ContentEntryRelatedEntryJoinWithLanguage>

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  actual abstract override fun update(entity: ContentEntryRelatedEntryJoin)
}
