package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.CourseBlockPicture
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class CourseBlockPictureDao : ImageDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertListAsync(entities: List<CourseBlockPicture>)

  @Query(`value` =
      "\n        UPDATE CourseBlockPicture\n           SET cbpPictureUri = :uri,\n               cbpThumbnailUri = :thumbnailUri,\n               cbpLct = :time\n         WHERE cbpUid = :uid  \n    ")
  actual override suspend fun updateUri(
    uid: Long,
    uri: String?,
    thumbnailUri: String?,
    time: Long,
  ) {
  }
}
