package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.Holiday
import kotlin.Any
import kotlin.Boolean
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class HolidayDao : BaseDao<Holiday>, OneToManyJoinDao<Holiday> {
  @Query(`value` = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = :holidayCalendarUid")
  public actual abstract fun findByHolidayCalendaUid(holidayCalendarUid: Long): List<Holiday>

  @Query(`value` = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = :holidayCalendarUid")
  public actual abstract suspend fun findByHolidayCalendaUidAsync(holidayCalendarUid: Long):
      List<Holiday>

  @Query(`value` =
      "\n        UPDATE Holiday \n           SET holActive = :active, \n               holLct = :changeTime\n         WHERE holUid = :holidayUid")
  public actual abstract fun updateActiveByUid(
    holidayUid: Long,
    active: Boolean,
    changeTime: Long,
  )

  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(entity: Holiday)
}
