package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.ActivityExtensionEntity
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class ActivityExtensionDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertListAsync(list: List<ActivityExtensionEntity>)

  @Query(`value` =
      "\n        SELECT ActivityExtensionEntity.*\n          FROM ActivityExtensionEntity\n         WHERE ActivityExtensionEntity.aeeActivityUid = :activityUid \n    ")
  public actual abstract suspend fun findAllByActivityUid(activityUid: Long):
      List<ActivityExtensionEntity>
}
