package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.LeavingReason;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class LeavingReasonDao_Impl extends LeavingReasonDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LeavingReason> __insertionAdapterOfLeavingReason;

  private final EntityInsertionAdapter<LeavingReason> __insertionAdapterOfLeavingReason_1;

  private final EntityDeletionOrUpdateAdapter<LeavingReason> __updateAdapterOfLeavingReason;

  public LeavingReasonDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLeavingReason = new EntityInsertionAdapter<LeavingReason>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `LeavingReason` (`leavingReasonUid`,`leavingReasonTitle`,`leavingReasonMCSN`,`leavingReasonCSN`,`leavingReasonLCB`,`leavingReasonLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LeavingReason entity) {
        statement.bindLong(1, entity.getLeavingReasonUid());
        if (entity.getLeavingReasonTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getLeavingReasonTitle());
        }
        statement.bindLong(3, entity.getLeavingReasonMCSN());
        statement.bindLong(4, entity.getLeavingReasonCSN());
        statement.bindLong(5, entity.getLeavingReasonLCB());
        statement.bindLong(6, entity.getLeavingReasonLct());
      }
    };
    this.__insertionAdapterOfLeavingReason_1 = new EntityInsertionAdapter<LeavingReason>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `LeavingReason` (`leavingReasonUid`,`leavingReasonTitle`,`leavingReasonMCSN`,`leavingReasonCSN`,`leavingReasonLCB`,`leavingReasonLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LeavingReason entity) {
        statement.bindLong(1, entity.getLeavingReasonUid());
        if (entity.getLeavingReasonTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getLeavingReasonTitle());
        }
        statement.bindLong(3, entity.getLeavingReasonMCSN());
        statement.bindLong(4, entity.getLeavingReasonCSN());
        statement.bindLong(5, entity.getLeavingReasonLCB());
        statement.bindLong(6, entity.getLeavingReasonLct());
      }
    };
    this.__updateAdapterOfLeavingReason = new EntityDeletionOrUpdateAdapter<LeavingReason>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `LeavingReason` SET `leavingReasonUid` = ?,`leavingReasonTitle` = ?,`leavingReasonMCSN` = ?,`leavingReasonCSN` = ?,`leavingReasonLCB` = ?,`leavingReasonLct` = ? WHERE `leavingReasonUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LeavingReason entity) {
        statement.bindLong(1, entity.getLeavingReasonUid());
        if (entity.getLeavingReasonTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getLeavingReasonTitle());
        }
        statement.bindLong(3, entity.getLeavingReasonMCSN());
        statement.bindLong(4, entity.getLeavingReasonCSN());
        statement.bindLong(5, entity.getLeavingReasonLCB());
        statement.bindLong(6, entity.getLeavingReasonLct());
        statement.bindLong(7, entity.getLeavingReasonUid());
      }
    };
  }

  @Override
  public long insert(final LeavingReason entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfLeavingReason.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final LeavingReason entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfLeavingReason.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends LeavingReason> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLeavingReason.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replaceList(final List<LeavingReason> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfLeavingReason_1.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final LeavingReason entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLeavingReason.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final LeavingReason entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfLeavingReason.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, LeavingReason> findAllReasons() {
    final String _sql = "SELECT * FROM LeavingReason";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new LimitOffsetPagingSource<LeavingReason>(_statement, __db, "LeavingReason") {
      @Override
      @NonNull
      protected List<LeavingReason> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonUid");
        final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonTitle");
        final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonMCSN");
        final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonCSN");
        final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonLCB");
        final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonLct");
        final List<LeavingReason> _result = new ArrayList<LeavingReason>(cursor.getCount());
        while (cursor.moveToNext()) {
          final LeavingReason _item;
          _item = new LeavingReason();
          final long _tmpLeavingReasonUid;
          _tmpLeavingReasonUid = cursor.getLong(_cursorIndexOfLeavingReasonUid);
          _item.setLeavingReasonUid(_tmpLeavingReasonUid);
          final String _tmpLeavingReasonTitle;
          if (cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
            _tmpLeavingReasonTitle = null;
          } else {
            _tmpLeavingReasonTitle = cursor.getString(_cursorIndexOfLeavingReasonTitle);
          }
          _item.setLeavingReasonTitle(_tmpLeavingReasonTitle);
          final long _tmpLeavingReasonMCSN;
          _tmpLeavingReasonMCSN = cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
          _item.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
          final long _tmpLeavingReasonCSN;
          _tmpLeavingReasonCSN = cursor.getLong(_cursorIndexOfLeavingReasonCSN);
          _item.setLeavingReasonCSN(_tmpLeavingReasonCSN);
          final int _tmpLeavingReasonLCB;
          _tmpLeavingReasonLCB = cursor.getInt(_cursorIndexOfLeavingReasonLCB);
          _item.setLeavingReasonLCB(_tmpLeavingReasonLCB);
          final long _tmpLeavingReasonLct;
          _tmpLeavingReasonLct = cursor.getLong(_cursorIndexOfLeavingReasonLct);
          _item.setLeavingReasonLct(_tmpLeavingReasonLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<LeavingReason> findAllReasonsLive() {
    final String _sql = "SELECT * FROM LeavingReason";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
      final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
      final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
      final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
      final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
      final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
      final List<LeavingReason> _result = new ArrayList<LeavingReason>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final LeavingReason _item;
        _item = new LeavingReason();
        final long _tmpLeavingReasonUid;
        _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
        _item.setLeavingReasonUid(_tmpLeavingReasonUid);
        final String _tmpLeavingReasonTitle;
        if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
          _tmpLeavingReasonTitle = null;
        } else {
          _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
        }
        _item.setLeavingReasonTitle(_tmpLeavingReasonTitle);
        final long _tmpLeavingReasonMCSN;
        _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
        _item.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
        final long _tmpLeavingReasonCSN;
        _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
        _item.setLeavingReasonCSN(_tmpLeavingReasonCSN);
        final int _tmpLeavingReasonLCB;
        _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
        _item.setLeavingReasonLCB(_tmpLeavingReasonLCB);
        final long _tmpLeavingReasonLct;
        _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
        _item.setLeavingReasonLct(_tmpLeavingReasonLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findAllReasonsAsync(final Continuation<? super List<LeavingReason>> $completion) {
    final String _sql = "SELECT * FROM LeavingReason";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<LeavingReason>>() {
      @Override
      @NonNull
      public List<LeavingReason> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final List<LeavingReason> _result = new ArrayList<LeavingReason>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final LeavingReason _item;
            _item = new LeavingReason();
            final long _tmpLeavingReasonUid;
            _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
            _item.setLeavingReasonUid(_tmpLeavingReasonUid);
            final String _tmpLeavingReasonTitle;
            if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
              _tmpLeavingReasonTitle = null;
            } else {
              _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
            }
            _item.setLeavingReasonTitle(_tmpLeavingReasonTitle);
            final long _tmpLeavingReasonMCSN;
            _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
            _item.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
            final long _tmpLeavingReasonCSN;
            _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
            _item.setLeavingReasonCSN(_tmpLeavingReasonCSN);
            final int _tmpLeavingReasonLCB;
            _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
            _item.setLeavingReasonLCB(_tmpLeavingReasonLCB);
            final long _tmpLeavingReasonLct;
            _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
            _item.setLeavingReasonLct(_tmpLeavingReasonLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super LeavingReason> $completion) {
    final String _sql = "SELECT * FROM LeavingReason WHERE leavingReasonUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<LeavingReason>() {
      @Override
      @Nullable
      public LeavingReason call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final LeavingReason _result;
          if (_cursor.moveToFirst()) {
            _result = new LeavingReason();
            final long _tmpLeavingReasonUid;
            _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
            _result.setLeavingReasonUid(_tmpLeavingReasonUid);
            final String _tmpLeavingReasonTitle;
            if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
              _tmpLeavingReasonTitle = null;
            } else {
              _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
            }
            _result.setLeavingReasonTitle(_tmpLeavingReasonTitle);
            final long _tmpLeavingReasonMCSN;
            _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
            _result.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
            final long _tmpLeavingReasonCSN;
            _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
            _result.setLeavingReasonCSN(_tmpLeavingReasonCSN);
            final int _tmpLeavingReasonLCB;
            _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
            _result.setLeavingReasonLCB(_tmpLeavingReasonLCB);
            final long _tmpLeavingReasonLct;
            _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
            _result.setLeavingReasonLct(_tmpLeavingReasonLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidList(final List<Long> uidList,
      final Continuation<? super List<Long>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT leavingReasonUid FROM LeavingReason WHERE leavingReasonUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      @NonNull
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<LeavingReason> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM LeavingReason WHERE leavingReasonUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"LeavingReason"}, new Callable<LeavingReason>() {
      @Override
      @Nullable
      public LeavingReason call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final LeavingReason _result;
          if (_cursor.moveToFirst()) {
            _result = new LeavingReason();
            final long _tmpLeavingReasonUid;
            _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
            _result.setLeavingReasonUid(_tmpLeavingReasonUid);
            final String _tmpLeavingReasonTitle;
            if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
              _tmpLeavingReasonTitle = null;
            } else {
              _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
            }
            _result.setLeavingReasonTitle(_tmpLeavingReasonTitle);
            final long _tmpLeavingReasonMCSN;
            _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
            _result.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
            final long _tmpLeavingReasonCSN;
            _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
            _result.setLeavingReasonCSN(_tmpLeavingReasonCSN);
            final int _tmpLeavingReasonLCB;
            _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
            _result.setLeavingReasonLCB(_tmpLeavingReasonLCB);
            final long _tmpLeavingReasonLct;
            _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
            _result.setLeavingReasonLct(_tmpLeavingReasonLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getReasonsFromUids(final List<Long> uidList,
      final Continuation<? super List<UidAndLabel>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT LeavingReason.leavingReasonUid AS uid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            LeavingReason.leavingReasonTitle As labelName  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            FROM LeavingReason WHERE leavingReasonUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UidAndLabel>>() {
      @Override
      @NonNull
      public List<UidAndLabel> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUid = 0;
          final int _cursorIndexOfLabelName = 1;
          final List<UidAndLabel> _result = new ArrayList<UidAndLabel>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UidAndLabel _item_1;
            _item_1 = new UidAndLabel();
            final long _tmpUid;
            _tmpUid = _cursor.getLong(_cursorIndexOfUid);
            _item_1.setUid(_tmpUid);
            final String _tmpLabelName;
            if (_cursor.isNull(_cursorIndexOfLabelName)) {
              _tmpLabelName = null;
            } else {
              _tmpLabelName = _cursor.getString(_cursorIndexOfLabelName);
            }
            _item_1.setLabelName(_tmpLabelName);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
