package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.StatementEntityJson
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class StatementEntityJsonDao {
  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract suspend fun insertOrIgnoreListAsync(entityList: List<StatementEntityJson>)

  @Query(`value` =
      "\n        SELECT StatementEntityJson.*\n          FROM StatementEntityJson\n         WHERE (    (:stmtJsonIdHi = 0 AND :stmtJsonIdLo = 0) \n                 OR (stmtJsonIdHi = :stmtJsonIdHi AND stmtJsonIdLo = :stmtJsonIdLo))\n                  \n    ")
  public actual abstract suspend fun getStatements(stmtJsonIdHi: Long, stmtJsonIdLo: Long):
      List<StatementEntityJson>
}
