package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.lib.db.composites.ClazzInviteAndClazz
import com.ustadmobile.lib.db.composites.ClazzInviteWithTimeZone
import com.ustadmobile.lib.db.entities.ClazzInvite
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public actual abstract class ClazzInviteDao : BaseDao<ClazzInvite> {
  public actual abstract suspend fun replace(entity: ClazzInvite): Long

  public actual abstract suspend fun insertAll(entity: List<ClazzInvite>)

  public actual abstract suspend fun updateAll(entity: List<ClazzInvite>)

  public actual abstract suspend fun findInviteAsync(): List<ClazzInvite>

  public actual abstract suspend fun findClazzInviteEntityForInviteToken(inviteTokenUid: String):
      ClazzInviteWithTimeZone?

  public actual abstract fun findClazzInviteEntityForInviteTokenAsFlow(inviteTokenUid: String):
      Flow<ClazzInviteAndClazz?>

  public actual abstract suspend fun updateInviteStatus(
    status: Int,
    ciUid: Long,
    updateTime: Long,
  )

  public actual abstract fun findPendingInviteByPersonUid(
    ciPersonUid: Long,
    clazzUid: Long,
    currentTime: Long,
  ): PagingSource<Int, ClazzInvite>

  public actual abstract suspend fun updateClazzInviteToRevokeInvite(inviteContact: String): Int

  public actual abstract suspend fun findClazzInviteFromContact(inviteContact: String): ClazzInvite?
}
