package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.SystemPermissionDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<SystemPermissionDao>) {
  `get`("findByPersonUidAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByPersonUidAsFlow_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("personHasSystemPermission") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.personHasSystemPermission_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("personHasSystemPermissionAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.personHasSystemPermissionAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("personHasSystemPermissionPairAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.personHasSystemPermissionPairAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("personHasSystemPermissionPair") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.personHasSystemPermissionPair_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("personHasEditAndViewPermissionForPersonAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.personHasEditAndViewPermissionForPersonAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
}
