package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonPicture
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzLogAttendanceRecordDao.findByClazzAndTime_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzLogUid : Long = request.queryParam("clazzLogUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_time : Long = request.queryParam("time")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByClazzAndTime = findByClazzAndTime(
    clazzUid = _arg_clazzUid,
    clazzLogUid = _arg_clazzLogUid,
    time = _arg_time,
  )
  val _result_findAllEnrolmentsByClazzUidAndRole =
      request.db.doorWrapper.getDaoByClass(ClazzEnrolmentDao::class).findAllEnrolmentsByClazzUidAndRole(
    clazzUid = _arg_clazzUid,
    roleId = 1000,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByClazzAndTime.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzAndTime.mapNotNull {
        _row ->
        _row.personPicture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzAndTime.mapNotNull {
        _row ->
        _row.attendanceRecord?.let {
          DoorReplicationEntity(tableId = 15,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzLogAttendanceRecord.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllEnrolmentsByClazzUidAndRole.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
