package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLangName
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLanguage
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

public class ContentEntryRelatedEntryJoinDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentEntryRelatedEntryJoinDao,
) : ContentEntryRelatedEntryJoinDao() {
  override fun publicContentEntryRelatedEntryJoins(): List<ContentEntryRelatedEntryJoin> =
      _dao.publicContentEntryRelatedEntryJoins()

  override fun findPrimaryByTranslation(contentEntryUid: Long): ContentEntryRelatedEntryJoin? =
      _dao.findPrimaryByTranslation(contentEntryUid)

  override suspend fun findAllTranslationsForContentEntryAsync(contentEntryUid: Long):
      List<ContentEntryRelatedEntryJoinWithLangName> =
      _dao.findAllTranslationsForContentEntryAsync(contentEntryUid)

  override fun findAllTranslationsWithContentEntryUid(contentEntryUid: Long):
      PagingSource<Int, ContentEntryRelatedEntryJoinWithLanguage> =
      _dao.findAllTranslationsWithContentEntryUid(contentEntryUid)

  override fun update(entity: ContentEntryRelatedEntryJoin) {
    entity.cerejLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }

  public override fun insert(entity: ContentEntryRelatedEntryJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cerejUid == 0L) {
      val _newPk = _pkManager.nextId(8)
      entity.cerejUid = _newPk
    }
    entity.cerejLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.cerejUid
  }

  public override suspend fun insertAsync(entity: ContentEntryRelatedEntryJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cerejUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(8)
      entity.cerejUid = _newPk
    }
    entity.cerejLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.cerejUid
  }

  public override fun insertList(entityList: List<ContentEntryRelatedEntryJoin>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.cerejUid == 0L) {
        val _newPk = _pkManager.nextId(8)
        it.cerejUid = _newPk
        _generatedPks += _newPk
      }
      it.cerejLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }
}
