package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.CourseAssignmentSubmissionDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<CourseAssignmentSubmissionDao>) {
  `get`("getAllSubmissionsFromSubmitterAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getAllSubmissionsFromSubmitterAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getLatestSubmissionForUserAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getLatestSubmissionForUserAsync_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByUidAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByUidAsFlow_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByAssignmentUidAndAccountPersonUid") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByAssignmentUidAndAccountPersonUid_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
}
