package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.PersonPicture
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class PersonPictureDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: PersonPictureDao,
) : PersonPictureDao() {
  override suspend fun upsert(personPicture: PersonPicture) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(personPicture.personPictureUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(50)
      personPicture.personPictureUid = _newPk
    }
    personPicture.personPictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.upsert(personPicture)
  }

  override suspend fun findByPersonUidAsync(personUid: Long): PersonPicture? =
      _dao.findByPersonUidAsync(personUid)

  override fun findByPersonUidLive(personUid: Long): Flow<PersonPicture?> =
      _dao.findByPersonUidLive(personUid)

  override fun findByPersonUidAsFlow(personUid: Long): Flow<PersonPicture?> =
      _dao.findByPersonUidAsFlow(personUid)

  override suspend fun updateAsync(personPicture: PersonPicture) {
    personPicture.personPictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.updateAsync(personPicture)
  }

  override suspend fun updateLct(uid: Long, time: Long) {
    _dao.updateLct(uid, time)
  }

  override suspend fun updateUri(
    uid: Long,
    uri: String?,
    thumbnailUri: String?,
    time: Long,
  ) {
    _dao.updateUri(uid, uri, thumbnailUri, time)
  }

  override suspend fun updateTransferJobItemEtag(entityUid: Long, transferJobItemUid: Int) {
    _dao.updateTransferJobItemEtag(entityUid, transferJobItemUid)
  }

  public override fun insert(entity: PersonPicture): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.personPictureUid == 0L) {
      val _newPk = _pkManager.nextId(50)
      entity.personPictureUid = _newPk
    }
    entity.personPictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.personPictureUid
  }

  public override suspend fun insertAsync(entity: PersonPicture): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.personPictureUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(50)
      entity.personPictureUid = _newPk
    }
    entity.personPictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.personPictureUid
  }

  public override fun insertList(entityList: List<PersonPicture>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.personPictureUid == 0L) {
        val _newPk = _pkManager.nextId(50)
        it.personPictureUid = _newPk
        _generatedPks += _newPk
      }
      it.personPictureLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: PersonPicture) {
    entity.personPictureLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
