/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.httpoveripc.core;

import com.ustadmobile.httpoveripc.core.SimpleTextRequest;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rawhttp.core.RawHttp;
import rawhttp.core.RawHttpRequest;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J?\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/ustadmobile/httpoveripc/core/SimpleTextRequest;", "", "method", "Lcom/ustadmobile/httpoveripc/core/SimpleTextRequest$Method;", "url", "Lio/ktor/http/Url;", "headers", "", "", "requestBody", "(Lcom/ustadmobile/httpoveripc/core/SimpleTextRequest$Method;Lio/ktor/http/Url;Ljava/util/Map;Ljava/lang/String;)V", "getHeaders", "()Ljava/util/Map;", "getMethod", "()Lcom/ustadmobile/httpoveripc/core/SimpleTextRequest$Method;", "getRequestBody", "()Ljava/lang/String;", "getUrl", "()Lio/ktor/http/Url;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toRawHttpRequest", "Lrawhttp/core/RawHttpRequest;", "rawHttp", "Lrawhttp/core/RawHttp;", "toString", "Method", "core_debug"})
public final class SimpleTextRequest {
    @NotNull
    private final Method method;
    @NotNull
    private final Url url;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private final String requestBody;

    public SimpleTextRequest(@NotNull Method method, @NotNull Url url, @NotNull Map<String, String> headers, @Nullable String requestBody) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.requestBody = requestBody;
    }

    public /* synthetic */ SimpleTextRequest(Method method, Url url, Map map, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(method, url, map, string);
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final Url getUrl() {
        return this.url;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public final String getRequestBody() {
        return this.requestBody;
    }

    @NotNull
    public final RawHttpRequest toRawHttpRequest(@NotNull RawHttp rawHttp) {
        byte[] contentBytes;
        Intrinsics.checkNotNullParameter((Object)rawHttp, (String)"rawHttp");
        Map allHeaders = MapsKt.toMutableMap(this.headers);
        allHeaders.put("Host", this.url.getSpecifiedPort() > 0 ? URLUtilsKt.getHostWithPort((Url)this.url) : this.url.getHost());
        String string = this.requestBody;
        Object object = contentBytes = (Object)(string != null ? StringsKt.encodeToByteArray((String)string) : null);
        if (contentBytes != null) {
            allHeaders.put("Content-Length", String.valueOf(contentBytes.length));
        }
        StringBuilder stringBuilder = new StringBuilder().append(this.method.name()).append(' ').append(this.url.getEncodedPathAndQuery()).append(" HTTP/1.1\r\n").append(CollectionsKt.joinToString$default((Iterable)allHeaders.entrySet(), (CharSequence)"\r\n", null, null, (int)0, null, (Function1)toRawHttpRequest.1.INSTANCE, (int)30, null)).append("\r\n\r\n");
        String string2 = this.requestBody;
        if (string2 == null) {
            string2 = "";
        }
        RawHttpRequest rawHttpRequest = rawHttp.parseRequest(stringBuilder.append(string2).toString());
        Intrinsics.checkNotNullExpressionValue((Object)rawHttpRequest, (String)"rawHttp.parseRequest(\n  \u2026uestBody ?: \"\")\n        )");
        return rawHttpRequest;
    }

    @NotNull
    public final Method component1() {
        return this.method;
    }

    @NotNull
    public final Url component2() {
        return this.url;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @Nullable
    public final String component4() {
        return this.requestBody;
    }

    @NotNull
    public final SimpleTextRequest copy(@NotNull Method method, @NotNull Url url, @NotNull Map<String, String> headers, @Nullable String requestBody) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return new SimpleTextRequest(method, url, headers, requestBody);
    }

    public static /* synthetic */ SimpleTextRequest copy$default(SimpleTextRequest simpleTextRequest, Method method, Url url, Map map, String string, int n, Object object) {
        if ((n & 1) != 0) {
            method = simpleTextRequest.method;
        }
        if ((n & 2) != 0) {
            url = simpleTextRequest.url;
        }
        if ((n & 4) != 0) {
            map = simpleTextRequest.headers;
        }
        if ((n & 8) != 0) {
            string = simpleTextRequest.requestBody;
        }
        return simpleTextRequest.copy(method, url, map, string);
    }

    @NotNull
    public String toString() {
        return "SimpleTextRequest(method=" + (Object)((Object)this.method) + ", url=" + this.url + ", headers=" + this.headers + ", requestBody=" + this.requestBody + ')';
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + (this.requestBody == null ? 0 : this.requestBody.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleTextRequest)) {
            return false;
        }
        SimpleTextRequest simpleTextRequest = (SimpleTextRequest)other;
        if (this.method != simpleTextRequest.method) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)simpleTextRequest.url)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, simpleTextRequest.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestBody, (Object)simpleTextRequest.requestBody);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/httpoveripc/core/SimpleTextRequest$Method;", "", "(Ljava/lang/String;I)V", "GET", "POST", "PUT", "DELETE", "core_debug"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GET = new Method();
        public static final /* enum */ Method POST = new Method();
        public static final /* enum */ Method PUT = new Method();
        public static final /* enum */ Method DELETE = new Method();
        private static final /* synthetic */ Method[] $VALUES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        static {
            $VALUES = methodArray = new Method[]{Method.GET, Method.POST, Method.PUT, Method.DELETE};
        }
    }
}

