/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.httpoveripc.server;

import com.ustadmobile.httpoveripc.server.AbstractHttpOverIpcServer;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import rawhttp.core.RawHttp;
import rawhttp.core.RawHttpRequest;
import rawhttp.core.RawHttpResponse;
import rawhttp.core.body.BodyReader;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/httpoveripc/server/EchoHttpOverIpcServer;", "Lcom/ustadmobile/httpoveripc/server/AbstractHttpOverIpcServer;", "()V", "rawHttp", "Lrawhttp/core/RawHttp;", "handleRequest", "Lrawhttp/core/RawHttpResponse;", "request", "Lrawhttp/core/RawHttpRequest;", "server_debug"})
public final class EchoHttpOverIpcServer
extends AbstractHttpOverIpcServer {
    @NotNull
    private final RawHttp rawHttp = new RawHttp();

    @Override
    @NotNull
    public RawHttpResponse<?> handleRequest(@NotNull RawHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String dateString = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
        Object object = request.getHeaders().get("content-length");
        Long bodyContentLen = object != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null ? Long.valueOf(Long.parseLong((String)object)) : null;
        String requestBody = bodyContentLen != null ? ((BodyReader)request.getBody().get()).decodeBodyToString(Charsets.UTF_8) : "";
        String body = request.getUri().toString() + requestBody;
        RawHttpResponse response = this.rawHttp.parseResponse("HTTP/1.1 200 OK\r\nContent-Type: plain/text\r\nContent-Length: " + body.length() + "\r\nServer: RawHTTP\r\nDate: " + dateString + "\r\n\r\n" + body);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return response;
    }
}

