/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.httpoveripc.server;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.ustadmobile.httpoveripc.core.ext.BundleExtKt;
import com.ustadmobile.httpoveripc.server.AbstractHttpOverIpcServer;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rawhttp.core.RawHttp;
import rawhttp.core.RawHttpRequest;
import rawhttp.core.RawHttpResponse;
import rawhttp.core.body.HttpMessageBody;
import rawhttp.core.body.StringBody;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/httpoveripc/server/AbstractHttpOverIpcServer;", "Landroid/app/Service;", "()V", "handlerThread", "Landroid/os/HandlerThread;", "mMessenger", "Landroid/os/Messenger;", "rawHttp", "Lrawhttp/core/RawHttp;", "getRawHttp", "()Lrawhttp/core/RawHttp;", "rawHttp$delegate", "Lkotlin/Lazy;", "handleRequest", "Lrawhttp/core/RawHttpResponse;", "request", "Lrawhttp/core/RawHttpRequest;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onDestroy", "", "IncomingHandler", "server_debug"})
public abstract class AbstractHttpOverIpcServer
extends Service {
    @NotNull
    private final Lazy rawHttp$delegate = LazyKt.lazy((Function0)rawHttp.2.INSTANCE);
    @NotNull
    private final HandlerThread handlerThread;
    @NotNull
    private final Messenger mMessenger;

    /*
     * WARNING - void declaration
     */
    public AbstractHttpOverIpcServer() {
        void it;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("HttpServiceHandler");
        AbstractHttpOverIpcServer abstractHttpOverIpcServer = this;
        boolean bl = false;
        if (!it.isAlive()) {
            it.start();
        }
        abstractHttpOverIpcServer.handlerThread = handlerThread;
        Looper looper = this.handlerThread.getLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"handlerThread.looper");
        this.mMessenger = new Messenger((Handler)new IncomingHandler(looper));
    }

    private final RawHttp getRawHttp() {
        Lazy lazy = this.rawHttp$delegate;
        return (RawHttp)lazy.getValue();
    }

    @NotNull
    public abstract RawHttpResponse<?> handleRequest(@NotNull RawHttpRequest var1);

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        IBinder iBinder = this.mMessenger.getBinder();
        Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"mMessenger.binder");
        return iBinder;
    }

    public void onDestroy() {
        super.onDestroy();
        this.handlerThread.quit();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/httpoveripc/server/AbstractHttpOverIpcServer$IncomingHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "(Lcom/ustadmobile/httpoveripc/server/AbstractHttpOverIpcServer;Landroid/os/Looper;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "server_debug"})
    private final class IncomingHandler
    extends Handler {
        public IncomingHandler(Looper looper) {
            Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
            super(looper);
        }

        public void handleMessage(@NotNull Message msg) {
            RawHttpResponse incomingRequest;
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            String requestUri = null;
            try {
                Bundle bundle = msg.getData();
                Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"msg.data");
                incomingRequest = BundleExtKt.getRawHttpRequest((Bundle)bundle, (String)"request", (RawHttp)AbstractHttpOverIpcServer.this.getRawHttp());
                requestUri = incomingRequest.getUri().toString();
                incomingRequest = AbstractHttpOverIpcServer.this.handleRequest((RawHttpRequest)incomingRequest);
            }
            catch (Exception e) {
                RawHttpResponse rawHttpResponse;
                RawHttpResponse it = rawHttpResponse = AbstractHttpOverIpcServer.this.getRawHttp().parseResponse("HTTP/1.1 500 Internal Server Error\nContent-Type: text/plain\n\n").withBody((HttpMessageBody)new StringBody(ExceptionsKt.stackTraceToString((Throwable)e)));
                boolean bl = false;
                Log.e((String)"HttpOverIpcServer", (String)("HttpOverIpc: uri=" + requestUri + " exception: " + e));
                incomingRequest = rawHttpResponse;
            }
            RawHttpResponse response = incomingRequest;
            Message replyMessage = Message.obtain((Handler)this, (int)64003);
            Bundle bundle = replyMessage.getData();
            Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"replyMessage.data");
            Intrinsics.checkNotNullExpressionValue(response, (String)"response");
            BundleExtKt.putRawHttpResponse((Bundle)bundle, (String)"response", (RawHttpResponse)response);
            try {
                msg.replyTo.send(replyMessage);
            }
            catch (RemoteException e) {
                Log.e((String)"HttpOverIpcServer", (String)("HttpOverIpc: could not send ReplyMessage to remote: " + (Object)((Object)e)));
                e.printStackTrace();
            }
        }
    }
}

