/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.LoadState;
import androidx.paging.LoadType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u000fH\u0087\b\u00f8\u0001\u0000J\u001d\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0017\u001a\u00020\u00188G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Landroidx/paging/LoadStates;", "", "refresh", "Landroidx/paging/LoadState;", "prepend", "append", "<init>", "(Landroidx/paging/LoadState;Landroidx/paging/LoadState;Landroidx/paging/LoadState;)V", "getRefresh", "()Landroidx/paging/LoadState;", "getPrepend", "getAppend", "forEach", "", "op", "Lkotlin/Function2;", "Landroidx/paging/LoadType;", "modifyState", "loadType", "newState", "modifyState$paging_common", "get", "get$paging_common", "hasError", "", "()Z", "isIdle", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "paging-common"})
public final class LoadStates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoadState refresh;
    @NotNull
    private final LoadState prepend;
    @NotNull
    private final LoadState append;
    private final boolean hasError;
    private final boolean isIdle;
    @NotNull
    private static final LoadStates IDLE = new LoadStates(LoadState.NotLoading.Companion.getIncomplete$paging_common(), LoadState.NotLoading.Companion.getIncomplete$paging_common(), LoadState.NotLoading.Companion.getIncomplete$paging_common());

    public LoadStates(@NotNull LoadState refresh, @NotNull LoadState prepend, @NotNull LoadState append2) {
        Intrinsics.checkNotNullParameter(refresh, "refresh");
        Intrinsics.checkNotNullParameter(prepend, "prepend");
        Intrinsics.checkNotNullParameter(append2, "append");
        this.refresh = refresh;
        this.prepend = prepend;
        this.append = append2;
        this.hasError = this.refresh instanceof LoadState.Error || this.append instanceof LoadState.Error || this.prepend instanceof LoadState.Error;
        this.isIdle = this.refresh instanceof LoadState.NotLoading && this.append instanceof LoadState.NotLoading && this.prepend instanceof LoadState.NotLoading;
    }

    @NotNull
    public final LoadState getRefresh() {
        return this.refresh;
    }

    @NotNull
    public final LoadState getPrepend() {
        return this.prepend;
    }

    @NotNull
    public final LoadState getAppend() {
        return this.append;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void forEach(@NotNull Function2<? super LoadType, ? super LoadState, Unit> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        boolean $i$f$forEach = false;
        op.invoke(LoadType.REFRESH, this.getRefresh());
        op.invoke(LoadType.PREPEND, this.getPrepend());
        op.invoke(LoadType.APPEND, this.getAppend());
    }

    @NotNull
    public final LoadStates modifyState$paging_common(@NotNull LoadType loadType, @NotNull LoadState newState) {
        LoadStates loadStates;
        Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
        Intrinsics.checkNotNullParameter(newState, "newState");
        switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
            case 1: {
                loadStates = LoadStates.copy$default(this, null, null, newState, 3, null);
                break;
            }
            case 2: {
                loadStates = LoadStates.copy$default(this, null, newState, null, 5, null);
                break;
            }
            case 3: {
                loadStates = LoadStates.copy$default(this, newState, null, null, 6, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadStates;
    }

    @NotNull
    public final LoadState get$paging_common(@NotNull LoadType loadType) {
        LoadState loadState;
        Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
        switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
            case 3: {
                loadState = this.refresh;
                break;
            }
            case 1: {
                loadState = this.append;
                break;
            }
            case 2: {
                loadState = this.prepend;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadState;
    }

    @JvmName(name="hasError")
    public final boolean hasError() {
        return this.hasError;
    }

    public final boolean isIdle() {
        return this.isIdle;
    }

    @NotNull
    public final LoadState component1() {
        return this.refresh;
    }

    @NotNull
    public final LoadState component2() {
        return this.prepend;
    }

    @NotNull
    public final LoadState component3() {
        return this.append;
    }

    @NotNull
    public final LoadStates copy(@NotNull LoadState refresh, @NotNull LoadState prepend, @NotNull LoadState append2) {
        Intrinsics.checkNotNullParameter(refresh, "refresh");
        Intrinsics.checkNotNullParameter(prepend, "prepend");
        Intrinsics.checkNotNullParameter(append2, "append");
        return new LoadStates(refresh, prepend, append2);
    }

    public static /* synthetic */ LoadStates copy$default(LoadStates loadStates, LoadState loadState, LoadState loadState2, LoadState loadState3, int n, Object object) {
        if ((n & 1) != 0) {
            loadState = loadStates.refresh;
        }
        if ((n & 2) != 0) {
            loadState2 = loadStates.prepend;
        }
        if ((n & 4) != 0) {
            loadState3 = loadStates.append;
        }
        return loadStates.copy(loadState, loadState2, loadState3);
    }

    @NotNull
    public String toString() {
        return "LoadStates(refresh=" + this.refresh + ", prepend=" + this.prepend + ", append=" + this.append + ")";
    }

    public int hashCode() {
        int result2 = this.refresh.hashCode();
        result2 = result2 * 31 + this.prepend.hashCode();
        result2 = result2 * 31 + this.append.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadStates)) {
            return false;
        }
        LoadStates loadStates = (LoadStates)other;
        if (!Intrinsics.areEqual(this.refresh, loadStates.refresh)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.prepend, loadStates.prepend)) {
            return false;
        }
        return Intrinsics.areEqual(this.append, loadStates.append);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/paging/LoadStates$Companion;", "", "<init>", "()V", "IDLE", "Landroidx/paging/LoadStates;", "getIDLE", "()Landroidx/paging/LoadStates;", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LoadStates getIDLE() {
            return IDLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.APPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.PREPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.REFRESH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

