/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Container;
import com.typesafe.config.impl.MergeableValue;
import com.typesafe.config.impl.OriginType;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveResult;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class AbstractConfigValue
implements ConfigValue,
MergeableValue {
    private final SimpleConfigOrigin origin;

    AbstractConfigValue(ConfigOrigin origin2) {
        this.origin = (SimpleConfigOrigin)origin2;
    }

    @Override
    public SimpleConfigOrigin origin() {
        return this.origin;
    }

    ResolveResult<? extends AbstractConfigValue> resolveSubstitutions(ResolveContext context2, ResolveSource source2) throws NotPossibleToResolve {
        return ResolveResult.make(context2, this);
    }

    ResolveStatus resolveStatus() {
        return ResolveStatus.RESOLVED;
    }

    protected static List<AbstractConfigValue> replaceChildInList(List<AbstractConfigValue> list2, AbstractConfigValue child, AbstractConfigValue replacement) {
        int i2;
        for (i2 = 0; i2 < list2.size() && list2.get(i2) != child; ++i2) {
        }
        if (i2 == list2.size()) {
            throw new ConfigException.BugOrBroken("tried to replace " + child + " which is not in " + list2);
        }
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>(list2);
        if (replacement != null) {
            newStack.set(i2, replacement);
        } else {
            newStack.remove(i2);
        }
        if (newStack.isEmpty()) {
            return null;
        }
        return newStack;
    }

    protected static boolean hasDescendantInList(List<AbstractConfigValue> list2, AbstractConfigValue descendant) {
        for (AbstractConfigValue v : list2) {
            if (v != descendant) continue;
            return true;
        }
        for (AbstractConfigValue v : list2) {
            if (!(v instanceof Container) || !((Container)((Object)v)).hasDescendant(descendant)) continue;
            return true;
        }
        return false;
    }

    AbstractConfigValue relativized(Path prefix) {
        return this;
    }

    @Override
    public AbstractConfigValue toFallbackValue() {
        return this;
    }

    protected abstract AbstractConfigValue newCopy(ConfigOrigin var1);

    protected boolean ignoresFallbacks() {
        return this.resolveStatus() == ResolveStatus.RESOLVED;
    }

    protected AbstractConfigValue withFallbacksIgnored() {
        if (this.ignoresFallbacks()) {
            return this;
        }
        throw new ConfigException.BugOrBroken("value class doesn't implement forced fallback-ignoring " + this);
    }

    protected final void requireNotIgnoringFallbacks() {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("method should not have been called with ignoresFallbacks=true " + this.getClass().getSimpleName());
        }
    }

    protected AbstractConfigValue constructDelayedMerge(ConfigOrigin origin2, List<AbstractConfigValue> stack) {
        return new ConfigDelayedMerge(origin2, stack);
    }

    protected final AbstractConfigValue mergedWithTheUnmergeable(Collection<AbstractConfigValue> stack, Unmergeable fallback2) {
        this.requireNotIgnoringFallbacks();
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        newStack.addAll(stack);
        newStack.addAll(fallback2.unmergedValues());
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(newStack), newStack);
    }

    private final AbstractConfigValue delayMerge(Collection<AbstractConfigValue> stack, AbstractConfigValue fallback2) {
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        newStack.addAll(stack);
        newStack.add(fallback2);
        return this.constructDelayedMerge(AbstractConfigObject.mergeOrigins(newStack), newStack);
    }

    protected final AbstractConfigValue mergedWithObject(Collection<AbstractConfigValue> stack, AbstractConfigObject fallback2) {
        this.requireNotIgnoringFallbacks();
        if (this instanceof AbstractConfigObject) {
            throw new ConfigException.BugOrBroken("Objects must reimplement mergedWithObject");
        }
        return this.mergedWithNonObject(stack, fallback2);
    }

    protected final AbstractConfigValue mergedWithNonObject(Collection<AbstractConfigValue> stack, AbstractConfigValue fallback2) {
        this.requireNotIgnoringFallbacks();
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return this.withFallbacksIgnored();
        }
        return this.delayMerge(stack, fallback2);
    }

    protected AbstractConfigValue mergedWithTheUnmergeable(Unmergeable fallback2) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithTheUnmergeable(Collections.singletonList(this), fallback2);
    }

    protected AbstractConfigValue mergedWithObject(AbstractConfigObject fallback2) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithObject(Collections.singletonList(this), fallback2);
    }

    protected AbstractConfigValue mergedWithNonObject(AbstractConfigValue fallback2) {
        this.requireNotIgnoringFallbacks();
        return this.mergedWithNonObject(Collections.singletonList(this), fallback2);
    }

    @Override
    public AbstractConfigValue withOrigin(ConfigOrigin origin2) {
        if (this.origin == origin2) {
            return this;
        }
        return this.newCopy(origin2);
    }

    @Override
    public AbstractConfigValue withFallback(ConfigMergeable mergeable) {
        if (this.ignoresFallbacks()) {
            return this;
        }
        ConfigValue other = ((MergeableValue)mergeable).toFallbackValue();
        if (other instanceof Unmergeable) {
            return this.mergedWithTheUnmergeable((Unmergeable)((Object)other));
        }
        if (other instanceof AbstractConfigObject) {
            return this.mergedWithObject((AbstractConfigObject)other);
        }
        return this.mergedWithNonObject((AbstractConfigValue)other);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigValue;
    }

    public boolean equals(Object other) {
        if (other instanceof ConfigValue) {
            return this.canEqual(other) && this.valueType() == ((ConfigValue)other).valueType() && ConfigImplUtil.equalsHandlingNull(this.unwrapped(), ((ConfigValue)other).unwrapped());
        }
        return false;
    }

    public int hashCode() {
        Object o = this.unwrapped();
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.render(sb, 0, true, null, ConfigRenderOptions.concise());
        return this.getClass().getSimpleName() + "(" + sb.toString() + ")";
    }

    protected static void indent(StringBuilder sb, int indent, ConfigRenderOptions options2) {
        if (options2.getFormatted()) {
            for (int remaining = indent; remaining > 0; --remaining) {
                sb.append("    ");
            }
        }
    }

    protected void render(StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options2) {
        if (atKey != null) {
            String renderedKey = options2.getJson() ? ConfigImplUtil.renderJsonString(atKey) : ConfigImplUtil.renderStringUnquotedIfPossible(atKey);
            sb.append(renderedKey);
            if (options2.getJson()) {
                if (options2.getFormatted()) {
                    sb.append(" : ");
                } else {
                    sb.append(":");
                }
            } else if (this instanceof ConfigObject) {
                if (options2.getFormatted()) {
                    sb.append(' ');
                }
            } else {
                sb.append("=");
            }
        }
        this.render(sb, indent, atRoot, options2);
    }

    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options2) {
        if (this.hideEnvVariableValue(options2)) {
            sb.append("<env variable>");
        } else {
            Object u2 = this.unwrapped();
            sb.append(u2.toString());
        }
    }

    protected boolean hideEnvVariableValue(ConfigRenderOptions options2) {
        return !options2.getShowEnvVariableValues() && this.origin.originType() == OriginType.ENV_VARIABLE;
    }

    protected void appendHiddenEnvVariableValue(StringBuilder sb) {
        sb.append("\"<env variable>\"");
    }

    @Override
    public final String render() {
        return this.render(ConfigRenderOptions.defaults());
    }

    @Override
    public final String render(ConfigRenderOptions options2) {
        StringBuilder sb = new StringBuilder();
        this.render(sb, 0, true, null, options2);
        return sb.toString();
    }

    String transformToString() {
        return null;
    }

    SimpleConfig atKey(ConfigOrigin origin2, String key) {
        Map<String, AbstractConfigValue> m = Collections.singletonMap(key, this);
        return new SimpleConfigObject(origin2, m).toConfig();
    }

    @Override
    public SimpleConfig atKey(String key) {
        return this.atKey(SimpleConfigOrigin.newSimple("atKey(" + key + ")"), key);
    }

    SimpleConfig atPath(ConfigOrigin origin2, Path path) {
        SimpleConfig result2 = this.atKey(origin2, path.last());
        for (Path parent = path.parent(); parent != null; parent = parent.parent()) {
            String key = parent.last();
            result2 = result2.atKey(origin2, key);
        }
        return result2;
    }

    @Override
    public SimpleConfig atPath(String pathExpression) {
        SimpleConfigOrigin origin2 = SimpleConfigOrigin.newSimple("atPath(" + pathExpression + ")");
        return this.atPath(origin2, Path.newPath(pathExpression));
    }

    protected abstract class NoExceptionsModifier
    implements Modifier {
        protected NoExceptionsModifier() {
        }

        @Override
        public final AbstractConfigValue modifyChildMayThrow(String keyOrNull, AbstractConfigValue v) throws Exception {
            try {
                return this.modifyChild(keyOrNull, v);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException.BugOrBroken("Unexpected exception", e);
            }
        }

        abstract AbstractConfigValue modifyChild(String var1, AbstractConfigValue var2);
    }

    protected static interface Modifier {
        public AbstractConfigValue modifyChildMayThrow(String var1, AbstractConfigValue var2) throws Exception;
    }

    static class NotPossibleToResolve
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String traceString;

        NotPossibleToResolve(ResolveContext context2) {
            super("was not possible to resolve");
            this.traceString = context2.traceString();
        }

        String traceString() {
            return this.traceString;
        }
    }
}

