/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;

public class X509CertificateSerializer
extends StdSerializer<X509Certificate> {
    public X509CertificateSerializer() {
        super(X509Certificate.class);
    }

    public void serialize(@NotNull X509Certificate value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) throws IOException {
        try {
            String str = Base64Util.encodeToString((byte[])value.getEncoded());
            gen.writeString(str);
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }
}

