/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedHashCacheEntry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B'\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J4\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0011J\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010\u0011R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010\u0013R\u0011\u0010&\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011\u00a8\u0006("}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "", "version", "", "httpPort", "", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashCacheEntry;", "entries", "<init>", "(BILjava/util/List;)V", "", "toBytes", "()[B", "component1", "()B", "component2", "()I", "component3", "()Ljava/util/List;", "copy", "(BILjava/util/List;)Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "B", "getVersion", "I", "getHttpPort", "Ljava/util/List;", "getEntries", "getSize", "size", "Companion", "respect-lib-cache"})
@SourceDebugExtension(value={"SMAP\nDistributedHashEntries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedHashEntries.kt\ncom/ustadmobile/libcache/distributed/model/DistributedHashEntries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1869#2,2:54\n*S KotlinDebug\n*F\n+ 1 DistributedHashEntries.kt\ncom/ustadmobile/libcache/distributed/model/DistributedHashEntries\n*L\n29#1:54,2\n*E\n"})
public final class DistributedHashEntries
extends DistributedCachePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte version;
    private final int httpPort;
    @NotNull
    private final List<DistributedHashCacheEntry> entries;
    public static final int OVERHEAD_SIZE = 10;

    public DistributedHashEntries(byte version, int httpPort, @NotNull List<DistributedHashCacheEntry> entries2) {
        Intrinsics.checkNotNullParameter(entries2, "entries");
        super(null);
        this.version = version;
        this.httpPort = httpPort;
        this.entries = entries2;
    }

    public /* synthetic */ DistributedHashEntries(byte by, int n, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            by = 1;
        }
        this(by, n, list2);
    }

    public final byte getVersion() {
        return this.version;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @NotNull
    public final List<DistributedHashCacheEntry> getEntries() {
        return this.entries;
    }

    public final int getSize() {
        return 10 + this.entries.size() * 24;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        buffer.put((byte)1);
        buffer.putInt(this.getHttpPort());
        buffer.put(this.version);
        buffer.putInt(this.entries.size());
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DistributedHashCacheEntry it = (DistributedHashCacheEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(buffer);
            it.writeBytes(buffer);
        }
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    public final byte component1() {
        return this.version;
    }

    public final int component2() {
        return this.httpPort;
    }

    @NotNull
    public final List<DistributedHashCacheEntry> component3() {
        return this.entries;
    }

    @NotNull
    public final DistributedHashEntries copy(byte version, int httpPort, @NotNull List<DistributedHashCacheEntry> entries2) {
        Intrinsics.checkNotNullParameter(entries2, "entries");
        return new DistributedHashEntries(version, httpPort, entries2);
    }

    public static /* synthetic */ DistributedHashEntries copy$default(DistributedHashEntries distributedHashEntries, byte by, int n, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            by = distributedHashEntries.version;
        }
        if ((n2 & 2) != 0) {
            n = distributedHashEntries.httpPort;
        }
        if ((n2 & 4) != 0) {
            list2 = distributedHashEntries.entries;
        }
        return distributedHashEntries.copy(by, n, list2);
    }

    @NotNull
    public String toString() {
        return "DistributedHashEntries(version=" + this.version + ", httpPort=" + this.httpPort + ", entries=" + this.entries + ")";
    }

    public int hashCode() {
        int result2 = Byte.hashCode(this.version);
        result2 = result2 * 31 + Integer.hashCode(this.httpPort);
        result2 = result2 * 31 + ((Object)this.entries).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DistributedHashEntries)) {
            return false;
        }
        DistributedHashEntries distributedHashEntries = (DistributedHashEntries)other;
        if (this.version != distributedHashEntries.version) {
            return false;
        }
        if (this.httpPort != distributedHashEntries.httpPort) {
            return false;
        }
        return Intrinsics.areEqual(this.entries, distributedHashEntries.entries);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u000b\u001a\u00020\n*\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries$Companion;", "", "<init>", "()V", "", "mtu", "numEntriesFor", "(I)I", "Ljava/nio/ByteBuffer;", "httpPort", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "readDistributedHashEntries", "(Ljava/nio/ByteBuffer;I)Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "OVERHEAD_SIZE", "I", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        public final int numEntriesFor(int mtu) {
            return (mtu - 10) / 24;
        }

        @NotNull
        public final DistributedHashEntries readDistributedHashEntries(@NotNull ByteBuffer $this$readDistributedHashEntries, int httpPort) {
            Intrinsics.checkNotNullParameter($this$readDistributedHashEntries, "<this>");
            byte version = $this$readDistributedHashEntries.get();
            int numEntries = $this$readDistributedHashEntries.getInt();
            List entriesList = new ArrayList();
            for (int i2 = 0; i2 < numEntries; ++i2) {
                entriesList.add(DistributedHashCacheEntry.Companion.readBytes($this$readDistributedHashEntries));
            }
            return new DistributedHashEntries(version, httpPort, entriesList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

