package world.respect.datalayer.db.school.daos

import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.InviteEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.ClassInviteModeEnum
import world.respect.datalayer.school.model.EnrollmentRoleEnum
import world.respect.datalayer.school.model.PersonRoleEnum
import world.respect.datalayer.school.model.StatusEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class InviteEntityDao_Impl(
  __db: RoomDatabase,
) : InviteEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfInviteEntity: EntityInsertAdapter<InviteEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfInviteEntity = object : EntityInsertAdapter<InviteEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `InviteEntity` (`iGuid`,`iGuidHash`,`iCode`,`iApprovalRequiredAfter`,`iLastModified`,`iStored`,`iStatus`,`iNewUserRole`,`iNewUserFirstInvite`,`iForFamilyOfGuid`,`iForFamilyOfGuidHash`,`iForClassGuid`,`iForClassName`,`iInviteMode`,`iSchoolName`,`iForClassGuidHash`,`iForClassRole`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: InviteEntity) {
        statement.bindText(1, entity.iGuid)
        statement.bindLong(2, entity.iGuidHash)
        statement.bindText(3, entity.iCode)
        val _tmp: Long? = __sharedConverters.fromInstant(entity.iApprovalRequiredAfter)
        if (_tmp == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.iLastModified)
        if (_tmp_1 == null) {
          statement.bindNull(5)
        } else {
          statement.bindLong(5, _tmp_1)
        }
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.iStored)
        if (_tmp_2 == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmp_2)
        }
        val _tmp_3: Int = __schoolTypeConverters.fromStatusEnum(entity.iStatus)
        statement.bindLong(7, _tmp_3.toLong())
        val _tmpINewUserRole: PersonRoleEnum? = entity.iNewUserRole
        val _tmp_4: Int?
        if (_tmpINewUserRole == null) {
          _tmp_4 = null
        } else {
          _tmp_4 = __schoolTypeConverters.fromPersonRoleType(_tmpINewUserRole)
        }
        if (_tmp_4 == null) {
          statement.bindNull(8)
        } else {
          statement.bindLong(8, _tmp_4.toLong())
        }
        val _tmp_5: Int = if (entity.iNewUserFirstInvite) 1 else 0
        statement.bindLong(9, _tmp_5.toLong())
        val _tmpIForFamilyOfGuid: String? = entity.iForFamilyOfGuid
        if (_tmpIForFamilyOfGuid == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpIForFamilyOfGuid)
        }
        val _tmpIForFamilyOfGuidHash: Long? = entity.iForFamilyOfGuidHash
        if (_tmpIForFamilyOfGuidHash == null) {
          statement.bindNull(11)
        } else {
          statement.bindLong(11, _tmpIForFamilyOfGuidHash)
        }
        val _tmpIForClassGuid: String? = entity.iForClassGuid
        if (_tmpIForClassGuid == null) {
          statement.bindNull(12)
        } else {
          statement.bindText(12, _tmpIForClassGuid)
        }
        val _tmpIForClassName: String? = entity.iForClassName
        if (_tmpIForClassName == null) {
          statement.bindNull(13)
        } else {
          statement.bindText(13, _tmpIForClassName)
        }
        val _tmpIInviteMode: ClassInviteModeEnum? = entity.iInviteMode
        val _tmp_6: Int?
        if (_tmpIInviteMode == null) {
          _tmp_6 = null
        } else {
          _tmp_6 = __schoolTypeConverters.fromClassInviteModeEnum(_tmpIInviteMode)
        }
        if (_tmp_6 == null) {
          statement.bindNull(14)
        } else {
          statement.bindLong(14, _tmp_6.toLong())
        }
        val _tmpISchoolName: String? = entity.iSchoolName
        if (_tmpISchoolName == null) {
          statement.bindNull(15)
        } else {
          statement.bindText(15, _tmpISchoolName)
        }
        val _tmpIForClassGuidHash: Long? = entity.iForClassGuidHash
        if (_tmpIForClassGuidHash == null) {
          statement.bindNull(16)
        } else {
          statement.bindLong(16, _tmpIForClassGuidHash)
        }
        val _tmpIForClassRole: EnrollmentRoleEnum? = entity.iForClassRole
        val _tmp_7: Int?
        if (_tmpIForClassRole == null) {
          _tmp_7 = null
        } else {
          _tmp_7 = __schoolTypeConverters.fromEnrollmentRoleEnum(_tmpIForClassRole)
        }
        if (_tmp_7 == null) {
          statement.bindNull(17)
        } else {
          statement.bindLong(17, _tmp_7.toLong())
        }
      }
    }
  }

  public override suspend fun insert(inviteEntity: InviteEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfInviteEntity.insert(_connection, inviteEntity)
  }

  public override suspend fun insertAll(invites: List<InviteEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfInviteEntity.insert(_connection, invites)
  }

  public override suspend fun getLastModifiedByGuid(guidHash: Long): Long? {
    val _sql: String = """
        |
        |        SELECT InviteEntity.iLastModified
        |          FROM InviteEntity
        |         WHERE InviteEntity.iGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getInviteByInviteCode(code: String): InviteEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iCode = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, code)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
        val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
        val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
        val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpIApprovalRequiredAfter: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIApprovalRequiredAfter = _tmp_1
          }
          val _tmpILastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfILastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpILastModified = _tmp_3
          }
          val _tmpIStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfIStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIStored = _tmp_5
          }
          val _tmpIStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
          _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          val _tmpINewUserRole: PersonRoleEnum?
          val _tmp_7: Int?
          if (_stmt.isNull(_columnIndexOfINewUserRole)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
          }
          if (_tmp_7 == null) {
            _tmpINewUserRole = null
          } else {
            _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
          }
          val _tmpINewUserFirstInvite: Boolean
          val _tmp_8: Int
          _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
          _tmpINewUserFirstInvite = _tmp_8 != 0
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpIInviteMode: ClassInviteModeEnum?
          val _tmp_9: Int?
          if (_stmt.isNull(_columnIndexOfIInviteMode)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
          }
          if (_tmp_9 == null) {
            _tmpIInviteMode = null
          } else {
            _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_10: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_10 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
          }
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuidHash(guidHash: Long): InviteEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
        val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
        val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
        val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpIApprovalRequiredAfter: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIApprovalRequiredAfter = _tmp_1
          }
          val _tmpILastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfILastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpILastModified = _tmp_3
          }
          val _tmpIStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfIStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIStored = _tmp_5
          }
          val _tmpIStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
          _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          val _tmpINewUserRole: PersonRoleEnum?
          val _tmp_7: Int?
          if (_stmt.isNull(_columnIndexOfINewUserRole)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
          }
          if (_tmp_7 == null) {
            _tmpINewUserRole = null
          } else {
            _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
          }
          val _tmpINewUserFirstInvite: Boolean
          val _tmp_8: Int
          _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
          _tmpINewUserFirstInvite = _tmp_8 != 0
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpIInviteMode: ClassInviteModeEnum?
          val _tmp_9: Int?
          if (_stmt.isNull(_columnIndexOfIInviteMode)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
          }
          if (_tmp_9 == null) {
            _tmpIInviteMode = null
          } else {
            _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_10: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_10 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
          }
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuid(guid: String): InviteEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iGuid = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, guid)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
        val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
        val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
        val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpIApprovalRequiredAfter: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIApprovalRequiredAfter = _tmp_1
          }
          val _tmpILastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfILastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpILastModified = _tmp_3
          }
          val _tmpIStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfIStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIStored = _tmp_5
          }
          val _tmpIStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
          _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          val _tmpINewUserRole: PersonRoleEnum?
          val _tmp_7: Int?
          if (_stmt.isNull(_columnIndexOfINewUserRole)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
          }
          if (_tmp_7 == null) {
            _tmpINewUserRole = null
          } else {
            _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
          }
          val _tmpINewUserFirstInvite: Boolean
          val _tmp_8: Int
          _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
          _tmpINewUserFirstInvite = _tmp_8 != 0
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpIInviteMode: ClassInviteModeEnum?
          val _tmp_9: Int?
          if (_stmt.isNull(_columnIndexOfIInviteMode)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
          }
          if (_tmp_9 == null) {
            _tmpIInviteMode = null
          } else {
            _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_10: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_10 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
          }
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByGuidHashAsFlow(guidHash: Long): Flow<InviteEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM InviteEntity
        |         WHERE iGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("InviteEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
        val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
        val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
        val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _result: InviteEntity?
        if (_stmt.step()) {
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpIApprovalRequiredAfter: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIApprovalRequiredAfter = _tmp_1
          }
          val _tmpILastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfILastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpILastModified = _tmp_3
          }
          val _tmpIStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfIStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIStored = _tmp_5
          }
          val _tmpIStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
          _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          val _tmpINewUserRole: PersonRoleEnum?
          val _tmp_7: Int?
          if (_stmt.isNull(_columnIndexOfINewUserRole)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
          }
          if (_tmp_7 == null) {
            _tmpINewUserRole = null
          } else {
            _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
          }
          val _tmpINewUserFirstInvite: Boolean
          val _tmp_8: Int
          _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
          _tmpINewUserFirstInvite = _tmp_8 != 0
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpIInviteMode: ClassInviteModeEnum?
          val _tmp_9: Int?
          if (_stmt.isNull(_columnIndexOfIInviteMode)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
          }
          if (_tmp_9 == null) {
            _tmpIInviteMode = null
          } else {
            _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_10: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_10 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
          }
          _result = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun listAsPagingSource(guidHash: Long, code: String?): PagingSource<Int, InviteEntity> {
    val _sql: String = """
        |
        |           SELECT InviteEntity.* 
        |             FROM InviteEntity
        |            WHERE (? = 0 OR InviteEntity.iGuidHash = ?)
        |              AND (? IS NULL OR InviteEntity.iCode = ?)
        |        
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 2
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 3
      if (code == null) {
        _stmt.bindNull(_argIndex)
      } else {
        _stmt.bindText(_argIndex, code)
      }
      _argIndex = 4
      if (code == null) {
        _stmt.bindNull(_argIndex)
      } else {
        _stmt.bindText(_argIndex, code)
      }
    }
    return object : LimitOffsetPagingSource<InviteEntity>(_rawQuery, __db, "InviteEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int): List<InviteEntity> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
          val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
          val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
          val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
          val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
          val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
          val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
          val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
          val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
          val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
          val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
          val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
          val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
          val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
          val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
          val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
          val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
          val _result: MutableList<InviteEntity> = mutableListOf()
          while (_stmt.step()) {
            val _item: InviteEntity
            val _tmpIGuid: String
            _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
            val _tmpIGuidHash: Long
            _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
            val _tmpICode: String
            _tmpICode = _stmt.getText(_columnIndexOfICode)
            val _tmpIApprovalRequiredAfter: Instant
            val _tmp: Long?
            if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
              _tmp = null
            } else {
              _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
            }
            val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
            if (_tmp_1 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpIApprovalRequiredAfter = _tmp_1
            }
            val _tmpILastModified: Instant
            val _tmp_2: Long?
            if (_stmt.isNull(_columnIndexOfILastModified)) {
              _tmp_2 = null
            } else {
              _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
            }
            val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
            if (_tmp_3 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpILastModified = _tmp_3
            }
            val _tmpIStored: Instant
            val _tmp_4: Long?
            if (_stmt.isNull(_columnIndexOfIStored)) {
              _tmp_4 = null
            } else {
              _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
            }
            val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
            if (_tmp_5 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpIStored = _tmp_5
            }
            val _tmpIStatus: StatusEnum
            val _tmp_6: Int
            _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
            _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
            val _tmpINewUserRole: PersonRoleEnum?
            val _tmp_7: Int?
            if (_stmt.isNull(_columnIndexOfINewUserRole)) {
              _tmp_7 = null
            } else {
              _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
            }
            if (_tmp_7 == null) {
              _tmpINewUserRole = null
            } else {
              _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
            }
            val _tmpINewUserFirstInvite: Boolean
            val _tmp_8: Int
            _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
            _tmpINewUserFirstInvite = _tmp_8 != 0
            val _tmpIForFamilyOfGuid: String?
            if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
              _tmpIForFamilyOfGuid = null
            } else {
              _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
            }
            val _tmpIForFamilyOfGuidHash: Long?
            if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
              _tmpIForFamilyOfGuidHash = null
            } else {
              _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
            }
            val _tmpIForClassGuid: String?
            if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
              _tmpIForClassGuid = null
            } else {
              _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
            }
            val _tmpIForClassName: String?
            if (_stmt.isNull(_columnIndexOfIForClassName)) {
              _tmpIForClassName = null
            } else {
              _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
            }
            val _tmpIInviteMode: ClassInviteModeEnum?
            val _tmp_9: Int?
            if (_stmt.isNull(_columnIndexOfIInviteMode)) {
              _tmp_9 = null
            } else {
              _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
            }
            if (_tmp_9 == null) {
              _tmpIInviteMode = null
            } else {
              _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
            }
            val _tmpISchoolName: String?
            if (_stmt.isNull(_columnIndexOfISchoolName)) {
              _tmpISchoolName = null
            } else {
              _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
            }
            val _tmpIForClassGuidHash: Long?
            if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
              _tmpIForClassGuidHash = null
            } else {
              _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
            }
            val _tmpIForClassRole: EnrollmentRoleEnum?
            val _tmp_10: Int?
            if (_stmt.isNull(_columnIndexOfIForClassRole)) {
              _tmp_10 = null
            } else {
              _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
            }
            if (_tmp_10 == null) {
              _tmpIForClassRole = null
            } else {
              _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
            }
            _item = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override suspend fun list(guidHash: Long, code: String?): List<InviteEntity> {
    val _sql: String = """
        |
        |           SELECT InviteEntity.* 
        |             FROM InviteEntity
        |            WHERE (? = 0 OR InviteEntity.iGuidHash = ?)
        |              AND (? IS NULL OR InviteEntity.iCode = ?)
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        _argIndex = 2
        _stmt.bindLong(_argIndex, guidHash)
        _argIndex = 3
        if (code == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, code)
        }
        _argIndex = 4
        if (code == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, code)
        }
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
        val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
        val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
        val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _result: MutableList<InviteEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: InviteEntity
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpIApprovalRequiredAfter: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIApprovalRequiredAfter = _tmp_1
          }
          val _tmpILastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfILastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpILastModified = _tmp_3
          }
          val _tmpIStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfIStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIStored = _tmp_5
          }
          val _tmpIStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
          _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          val _tmpINewUserRole: PersonRoleEnum?
          val _tmp_7: Int?
          if (_stmt.isNull(_columnIndexOfINewUserRole)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
          }
          if (_tmp_7 == null) {
            _tmpINewUserRole = null
          } else {
            _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
          }
          val _tmpINewUserFirstInvite: Boolean
          val _tmp_8: Int
          _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
          _tmpINewUserFirstInvite = _tmp_8 != 0
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpIInviteMode: ClassInviteModeEnum?
          val _tmp_9: Int?
          if (_stmt.isNull(_columnIndexOfIInviteMode)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
          }
          if (_tmp_9 == null) {
            _tmpIInviteMode = null
          } else {
            _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_10: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_10 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
          }
          _item = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidList(uidNums: List<Long>): List<InviteEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT * ")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM InviteEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE iGuidHash IN (")
    val _inputSize: Int = uidNums.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uidNums) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfIGuid: Int = getColumnIndexOrThrow(_stmt, "iGuid")
        val _columnIndexOfIGuidHash: Int = getColumnIndexOrThrow(_stmt, "iGuidHash")
        val _columnIndexOfICode: Int = getColumnIndexOrThrow(_stmt, "iCode")
        val _columnIndexOfIApprovalRequiredAfter: Int = getColumnIndexOrThrow(_stmt, "iApprovalRequiredAfter")
        val _columnIndexOfILastModified: Int = getColumnIndexOrThrow(_stmt, "iLastModified")
        val _columnIndexOfIStored: Int = getColumnIndexOrThrow(_stmt, "iStored")
        val _columnIndexOfIStatus: Int = getColumnIndexOrThrow(_stmt, "iStatus")
        val _columnIndexOfINewUserRole: Int = getColumnIndexOrThrow(_stmt, "iNewUserRole")
        val _columnIndexOfINewUserFirstInvite: Int = getColumnIndexOrThrow(_stmt, "iNewUserFirstInvite")
        val _columnIndexOfIForFamilyOfGuid: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuid")
        val _columnIndexOfIForFamilyOfGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForFamilyOfGuidHash")
        val _columnIndexOfIForClassGuid: Int = getColumnIndexOrThrow(_stmt, "iForClassGuid")
        val _columnIndexOfIForClassName: Int = getColumnIndexOrThrow(_stmt, "iForClassName")
        val _columnIndexOfIInviteMode: Int = getColumnIndexOrThrow(_stmt, "iInviteMode")
        val _columnIndexOfISchoolName: Int = getColumnIndexOrThrow(_stmt, "iSchoolName")
        val _columnIndexOfIForClassGuidHash: Int = getColumnIndexOrThrow(_stmt, "iForClassGuidHash")
        val _columnIndexOfIForClassRole: Int = getColumnIndexOrThrow(_stmt, "iForClassRole")
        val _result: MutableList<InviteEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: InviteEntity
          val _tmpIGuid: String
          _tmpIGuid = _stmt.getText(_columnIndexOfIGuid)
          val _tmpIGuidHash: Long
          _tmpIGuidHash = _stmt.getLong(_columnIndexOfIGuidHash)
          val _tmpICode: String
          _tmpICode = _stmt.getText(_columnIndexOfICode)
          val _tmpIApprovalRequiredAfter: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfIApprovalRequiredAfter)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfIApprovalRequiredAfter)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIApprovalRequiredAfter = _tmp_1
          }
          val _tmpILastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfILastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfILastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpILastModified = _tmp_3
          }
          val _tmpIStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfIStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfIStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpIStored = _tmp_5
          }
          val _tmpIStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfIStatus).toInt()
          _tmpIStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          val _tmpINewUserRole: PersonRoleEnum?
          val _tmp_7: Int?
          if (_stmt.isNull(_columnIndexOfINewUserRole)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfINewUserRole).toInt()
          }
          if (_tmp_7 == null) {
            _tmpINewUserRole = null
          } else {
            _tmpINewUserRole = __schoolTypeConverters.toPersonRoleType(_tmp_7)
          }
          val _tmpINewUserFirstInvite: Boolean
          val _tmp_8: Int
          _tmp_8 = _stmt.getLong(_columnIndexOfINewUserFirstInvite).toInt()
          _tmpINewUserFirstInvite = _tmp_8 != 0
          val _tmpIForFamilyOfGuid: String?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuid)) {
            _tmpIForFamilyOfGuid = null
          } else {
            _tmpIForFamilyOfGuid = _stmt.getText(_columnIndexOfIForFamilyOfGuid)
          }
          val _tmpIForFamilyOfGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForFamilyOfGuidHash)) {
            _tmpIForFamilyOfGuidHash = null
          } else {
            _tmpIForFamilyOfGuidHash = _stmt.getLong(_columnIndexOfIForFamilyOfGuidHash)
          }
          val _tmpIForClassGuid: String?
          if (_stmt.isNull(_columnIndexOfIForClassGuid)) {
            _tmpIForClassGuid = null
          } else {
            _tmpIForClassGuid = _stmt.getText(_columnIndexOfIForClassGuid)
          }
          val _tmpIForClassName: String?
          if (_stmt.isNull(_columnIndexOfIForClassName)) {
            _tmpIForClassName = null
          } else {
            _tmpIForClassName = _stmt.getText(_columnIndexOfIForClassName)
          }
          val _tmpIInviteMode: ClassInviteModeEnum?
          val _tmp_9: Int?
          if (_stmt.isNull(_columnIndexOfIInviteMode)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfIInviteMode).toInt()
          }
          if (_tmp_9 == null) {
            _tmpIInviteMode = null
          } else {
            _tmpIInviteMode = __schoolTypeConverters.toClassInviteModeEnum(_tmp_9)
          }
          val _tmpISchoolName: String?
          if (_stmt.isNull(_columnIndexOfISchoolName)) {
            _tmpISchoolName = null
          } else {
            _tmpISchoolName = _stmt.getText(_columnIndexOfISchoolName)
          }
          val _tmpIForClassGuidHash: Long?
          if (_stmt.isNull(_columnIndexOfIForClassGuidHash)) {
            _tmpIForClassGuidHash = null
          } else {
            _tmpIForClassGuidHash = _stmt.getLong(_columnIndexOfIForClassGuidHash)
          }
          val _tmpIForClassRole: EnrollmentRoleEnum?
          val _tmp_10: Int?
          if (_stmt.isNull(_columnIndexOfIForClassRole)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfIForClassRole).toInt()
          }
          if (_tmp_10 == null) {
            _tmpIForClassRole = null
          } else {
            _tmpIForClassRole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_10)
          }
          _item_1 = InviteEntity(_tmpIGuid,_tmpIGuidHash,_tmpICode,_tmpIApprovalRequiredAfter,_tmpILastModified,_tmpIStored,_tmpIStatus,_tmpINewUserRole,_tmpINewUserFirstInvite,_tmpIForFamilyOfGuid,_tmpIForFamilyOfGuidHash,_tmpIForClassGuid,_tmpIForClassName,_tmpIInviteMode,_tmpISchoolName,_tmpIForClassGuidHash,_tmpIForClassRole)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
