/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.cache;

import io.ktor.client.HttpClient;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.plugins.cache.CacheControl;
import io.ktor.client.plugins.cache.HttpCache;
import io.ktor.client.plugins.cache.HttpCacheEntry;
import io.ktor.client.plugins.cache.HttpCacheEntryKt;
import io.ktor.client.plugins.cache.HttpCacheKt;
import io.ktor.client.plugins.cache.HttpCacheLegacyKt;
import io.ktor.client.plugins.cache.InvalidCacheStateException;
import io.ktor.client.plugins.cache.ValidateStatus;
import io.ktor.client.plugins.cache.storage.HttpCacheStorage;
import io.ktor.client.plugins.cache.storage.HttpCacheStorageKt;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.HttpResponseData;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.http.HeaderValue;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.date.GMTDate;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.ByteReadChannel;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a8\u0010\n\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0080@\u00a2\u0006\u0004\b\n\u0010\u000b\u001a8\u0010\u000e\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0080@\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a0\u0010\u0012\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001c\u0010\u0014\u001a\u00020\f*\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0082@\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a%\u0010\u0018\u001a\u0004\u0018\u00010\f*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001aA\u0010\"\u001a\u0004\u0018\u00010!*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\"\u0010#\u001a%\u0010\"\u001a\u0004\u0018\u00010!*\u00020\u00032\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\"\u0010%\u00a8\u0006&"}, d2={"Lio/ktor/util/pipeline/PipelineContext;", "", "Lio/ktor/client/request/HttpRequestBuilder;", "Lio/ktor/client/plugins/cache/HttpCache;", "plugin", "Lio/ktor/http/content/OutgoingContent;", "content", "Lio/ktor/client/HttpClient;", "scope", "", "interceptSendLegacy", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/http/content/OutgoingContent;Lio/ktor/client/HttpClient;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/client/statement/HttpResponse;", "response", "interceptReceiveLegacy", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/client/statement/HttpResponse;Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/client/HttpClient;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/client/call/HttpClientCall;", "cachedCall", "proceedWithWarning", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/client/call/HttpClientCall;Lio/ktor/client/HttpClient;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cacheResponse", "(Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/client/request/HttpRequest;", "request", "findAndRefresh", "(Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/client/request/HttpRequest;Lio/ktor/client/statement/HttpResponse;)Lio/ktor/client/statement/HttpResponse;", "Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "storage", "", "", "varyKeys", "Lio/ktor/http/Url;", "url", "Lio/ktor/client/plugins/cache/HttpCacheEntry;", "findResponse", "(Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;Ljava/util/Map;Lio/ktor/http/Url;Lio/ktor/client/request/HttpRequest;)Lio/ktor/client/plugins/cache/HttpCacheEntry;", "context", "(Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/client/request/HttpRequestBuilder;Lio/ktor/http/content/OutgoingContent;)Lio/ktor/client/plugins/cache/HttpCacheEntry;", "ktor-client-core"})
@SourceDebugExtension(value={"SMAP\nHttpCacheLegacy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCacheLegacy.kt\nio/ktor/client/plugins/cache/HttpCacheLegacyKt\n+ 2 Headers.kt\nio/ktor/http/Headers$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n30#2:173\n1068#3:174\n295#3:175\n296#3:179\n168#4,3:176\n168#4,3:180\n*S KotlinDebug\n*F\n+ 1 HttpCacheLegacy.kt\nio/ktor/client/plugins/cache/HttpCacheLegacyKt\n*L\n95#1:173\n151#1:174\n152#1:175\n152#1:179\n153#1:176,3\n165#1:180,3\n*E\n"})
public final class HttpCacheLegacyKt {
    @Nullable
    public static final Object interceptSendLegacy(@NotNull PipelineContext<Object, HttpRequestBuilder> $this$interceptSendLegacy, @NotNull HttpCache plugin, @NotNull OutgoingContent content2, @NotNull HttpClient scope2, @NotNull Continuation<? super Unit> $completion) {
        block8: {
            HttpCacheEntry cache2 = HttpCacheLegacyKt.findResponse(plugin, $this$interceptSendLegacy.getContext(), content2);
            if (cache2 == null) {
                List<HeaderValue> header2 = HttpHeaderValueParserKt.parseHeaderValue($this$interceptSendLegacy.getContext().getHeaders().get(HttpHeaders.INSTANCE.getCacheControl()));
                if (header2.contains(CacheControl.INSTANCE.getONLY_IF_CACHED$ktor_client_core())) {
                    Object object = HttpCache.Companion.proceedWithMissingCache$ktor_client_core($this$interceptSendLegacy, scope2, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                }
                return Unit.INSTANCE;
            }
            HttpClientCall cachedCall = cache2.produceResponse$ktor_client_core().getCall();
            ValidateStatus validateStatus = HttpCacheEntryKt.shouldValidate(cache2.getExpires(), cache2.getResponse().getHeaders(), $this$interceptSendLegacy.getContext());
            if (validateStatus == ValidateStatus.ShouldNotValidate) {
                Object object = HttpCache.Companion.proceedWithCache$ktor_client_core($this$interceptSendLegacy, scope2, cachedCall, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (validateStatus == ValidateStatus.ShouldWarn) {
                Object object = HttpCacheLegacyKt.proceedWithWarning($this$interceptSendLegacy, cachedCall, scope2, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            String string2 = cache2.getResponseHeaders$ktor_client_core().get(HttpHeaders.INSTANCE.getETag());
            if (string2 != null) {
                String etag = string2;
                boolean bl = false;
                UtilsKt.header($this$interceptSendLegacy.getContext(), HttpHeaders.INSTANCE.getIfNoneMatch(), etag);
            }
            String string3 = cache2.getResponseHeaders$ktor_client_core().get(HttpHeaders.INSTANCE.getLastModified());
            if (string3 == null) break block8;
            String it = string3;
            boolean bl = false;
            UtilsKt.header($this$interceptSendLegacy.getContext(), HttpHeaders.INSTANCE.getIfModifiedSince(), it);
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object interceptReceiveLegacy(@NotNull PipelineContext<HttpResponse, Unit> $this$interceptReceiveLegacy, @NotNull HttpResponse response, @NotNull HttpCache plugin, @NotNull HttpClient scope, @NotNull Continuation<? super Unit> $completion) {
        block13: {
            if (!($completion instanceof interceptReceiveLegacy.1)) ** GOTO lbl-1000
            var7_5 = $completion;
            if ((var7_5.label & -2147483648) != 0) {
                var7_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl((Continuation<? super interceptReceiveLegacy.1>)$completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return HttpCacheLegacyKt.interceptReceiveLegacy(null, null, null, null, this);
                    }
                };
            }
            $result = $continuation.result;
            var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    if (!HttpStatusCodeKt.isSuccess(response.getStatus())) break;
                    $continuation.L$0 = $this$interceptReceiveLegacy;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable(response);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable(plugin);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable(scope);
                    $continuation.label = 1;
                    v0 = HttpCacheLegacyKt.cacheResponse(plugin, response, $continuation);
                    if (v0 == var8_7) {
                        return var8_7;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    scope = (HttpClient)$continuation.L$3;
                    plugin = (HttpCache)$continuation.L$2;
                    response = (HttpResponse)$continuation.L$1;
                    $this$interceptReceiveLegacy = (PipelineContext)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    reusableResponse = (HttpResponse)v0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this$interceptReceiveLegacy);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable(response);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable(plugin);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable(scope);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable(reusableResponse);
                    $continuation.label = 2;
                    v1 = $this$interceptReceiveLegacy.proceedWith(reusableResponse, $continuation);
                    if (v1 == var8_7) {
                        return var8_7;
                    }
                    ** GOTO lbl48
                }
                case 2: {
                    reusableResponse = (HttpResponse)$continuation.L$4;
                    scope = (HttpClient)$continuation.L$3;
                    plugin = (HttpCache)$continuation.L$2;
                    response = (HttpResponse)$continuation.L$1;
                    $this$interceptReceiveLegacy = (PipelineContext)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            if (!Intrinsics.areEqual(response.getStatus(), HttpStatusCode.Companion.getNotModified())) break block13;
            v2 = HttpCacheLegacyKt.findAndRefresh(plugin, response.getCall().getRequest(), response);
            if (v2 == null) {
                throw new InvalidCacheStateException(response.getCall().getRequest().getUrl());
            }
            responseFromCache = v2;
            if (HttpCacheEntryKt.varyKeys(responseFromCache).size() != HttpCacheEntryKt.varyKeys(response).size()) {
                HttpCacheKt.getLOGGER().warn("Vary header mismatch on cached response for " + response.getCall().getRequest().getUrl() + ". Received 304 Not Modified with Vary: " + HttpCacheEntryKt.varyKeys(response) + " but cached response has Vary: " + HttpCacheEntryKt.varyKeys(responseFromCache) + ". According to RFC 7232 \u00a74.1 and RFC 9111 \u00a74.1, the server must include the full Vary header in 304 responses. Proceeding with cached response despite mismatch. Consider reporting this issue to the server maintainers.");
            }
            scope.getMonitor().raise(HttpCache.Companion.getHttpResponseFromCache(), responseFromCache);
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this$interceptReceiveLegacy);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable(response);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable(plugin);
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable(scope);
            $continuation.L$4 = SpillingKt.nullOutSpilledVariable(responseFromCache);
            $continuation.label = 3;
            v3 = $this$interceptReceiveLegacy.proceedWith(responseFromCache, $continuation);
            if (v3 == var8_7) {
                return var8_7;
            }
            ** GOTO lbl75
            {
                case 3: {
                    responseFromCache = (HttpResponse)$continuation.L$4;
                    scope = (HttpClient)$continuation.L$3;
                    plugin = (HttpCache)$continuation.L$2;
                    response = (HttpResponse)$continuation.L$1;
                    $this$interceptReceiveLegacy = (PipelineContext)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v3 = $result;
lbl75:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private static final Object proceedWithWarning(PipelineContext<Object, HttpRequestBuilder> $this$proceedWithWarning, HttpClientCall cachedCall, HttpClient scope2, Continuation<? super Unit> $completion) {
        void $this$proceedWithWarning_u24lambda_u242;
        HeadersBuilder headersBuilder;
        HttpRequestData request2 = $this$proceedWithWarning.getContext().build();
        Headers.Companion this_$iv = Headers.Companion;
        boolean $i$f$build = false;
        HeadersBuilder headersBuilder2 = headersBuilder = new HeadersBuilder(0, 1, null);
        GMTDate gMTDate = cachedCall.getResponse().getRequestTime();
        HttpStatusCode httpStatusCode = cachedCall.getResponse().getStatus();
        boolean bl = false;
        $this$proceedWithWarning_u24lambda_u242.appendAll(cachedCall.getResponse().getHeaders());
        $this$proceedWithWarning_u24lambda_u242.append(HttpHeaders.INSTANCE.getWarning(), "110");
        Unit unit = Unit.INSTANCE;
        CoroutineContext coroutineContext = cachedCall.getResponse().getCoroutineContext();
        ByteReadChannel byteReadChannel = cachedCall.getResponse().getRawContent();
        HttpProtocolVersion httpProtocolVersion = cachedCall.getResponse().getVersion();
        Headers headers2 = headersBuilder.build();
        GMTDate gMTDate2 = gMTDate;
        HttpStatusCode httpStatusCode2 = httpStatusCode;
        HttpResponseData response2 = new HttpResponseData(httpStatusCode2, gMTDate2, headers2, httpProtocolVersion, byteReadChannel, coroutineContext);
        HttpClientCall call = new HttpClientCall(scope2, request2, response2);
        $this$proceedWithWarning.finish();
        scope2.getMonitor().raise(HttpCache.Companion.getHttpResponseFromCache(), call.getResponse());
        Object object = $this$proceedWithWarning.proceedWith(call, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object cacheResponse(HttpCache $this$cacheResponse, HttpResponse response, Continuation<? super HttpResponse> $completion) {
        if (!($completion instanceof cacheResponse.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super cacheResponse.1>)$completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpCacheLegacyKt.access$cacheResponse(null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                request = response.getCall().getRequest();
                responseCacheControl = HttpMessagePropertiesKt.cacheControl(response);
                requestCacheControl = HttpMessagePropertiesKt.cacheControl(request);
                v0 = storage = responseCacheControl.contains(CacheControl.INSTANCE.getPRIVATE$ktor_client_core()) != false ? $this$cacheResponse.getPrivateStorage$ktor_client_core() : $this$cacheResponse.getPublicStorage$ktor_client_core();
                if (responseCacheControl.contains(CacheControl.INSTANCE.getNO_STORE$ktor_client_core()) || requestCacheControl.contains(CacheControl.INSTANCE.getNO_STORE$ktor_client_core())) {
                    return response;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this$cacheResponse);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(response);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable(responseCacheControl);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(requestCacheControl);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable(storage);
                $continuation.label = 1;
                v1 = HttpCacheStorageKt.store(storage, request.getUrl(), response, $this$cacheResponse.isSharedClient$ktor_client_core(), $continuation);
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                storage = (HttpCacheStorage)$continuation.L$5;
                requestCacheControl = (List)$continuation.L$4;
                responseCacheControl = (List)$continuation.L$3;
                request = (HttpRequest)$continuation.L$2;
                response = (HttpResponse)$continuation.L$1;
                $this$cacheResponse = (HttpCache)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl38:
                // 2 sources

                cacheEntry = (HttpCacheEntry)v1;
                return cacheEntry.produceResponse$ktor_client_core();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final HttpResponse findAndRefresh(HttpCache $this$findAndRefresh, HttpRequest request2, HttpResponse response2) {
        Url url2 = response2.getCall().getRequest().getUrl();
        List<HeaderValue> cacheControl = HttpMessagePropertiesKt.cacheControl(response2);
        HttpCacheStorage storage = cacheControl.contains(CacheControl.INSTANCE.getPRIVATE$ktor_client_core()) ? $this$findAndRefresh.getPrivateStorage$ktor_client_core() : $this$findAndRefresh.getPublicStorage$ktor_client_core();
        HttpCacheEntry httpCacheEntry = HttpCacheLegacyKt.findResponse($this$findAndRefresh, storage, HttpCacheEntryKt.varyKeys(response2), url2, request2);
        if (httpCacheEntry == null) {
            return null;
        }
        HttpCacheEntry cache2 = httpCacheEntry;
        storage.store(url2, new HttpCacheEntry(HttpCacheEntryKt.cacheExpires$default(response2, $this$findAndRefresh.isSharedClient$ktor_client_core(), null, 2, null), cache2.getVaryKeys(), cache2.getResponse(), cache2.getBody()));
        return cache2.produceResponse$ktor_client_core();
    }

    /*
     * WARNING - void declaration
     */
    private static final HttpCacheEntry findResponse(HttpCache $this$findResponse, HttpCacheStorage storage, Map<String, String> varyKeys, Url url2, HttpRequest request2) {
        HttpCacheEntry httpCacheEntry;
        if (!varyKeys.isEmpty()) {
            httpCacheEntry = storage.find(url2, varyKeys);
        } else {
            Object v2;
            block7: {
                void $this$firstOrNull$iv;
                Iterable $this$sortedByDescending$iv;
                Function1<String, String> requestHeaders2 = HttpCacheKt.mergedHeadersLookup(request2.getContent(), (Function1<? super String, String>)new Function1<String, String>((Object)request2.getHeaders()){

                    public final String invoke(String p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Headers)this.receiver).get(p0);
                    }
                }, (Function1<? super String, ? extends List<String>>)new Function1<String, List<? extends String>>((Object)request2.getHeaders()){

                    public final List<String> invoke(String p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return ((Headers)this.receiver).getAll(p0);
                    }
                });
                Iterable iterable = storage.findByUrl(url2);
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a2, T b2) {
                        HttpCacheEntry it = (HttpCacheEntry)b2;
                        boolean bl = false;
                        Comparable comparable = it.getResponse().getResponseTime();
                        it = (HttpCacheEntry)a2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)it.getResponse().getResponseTime());
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block6: {
                        HttpCacheEntry cachedResponse = (HttpCacheEntry)element$iv;
                        boolean bl2 = false;
                        Map<String, String> $this$all$iv = cachedResponse.getVaryKeys();
                        boolean $i$f$all = false;
                        if ($this$all$iv.isEmpty()) {
                            bl = true;
                        } else {
                            Iterator<Map.Entry<String, String>> iterator2 = $this$all$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<String, String> element$iv2;
                                Map.Entry<String, String> entry = element$iv2 = iterator2.next();
                                boolean bl3 = false;
                                String key = entry.getKey();
                                String value = entry.getValue();
                                if (Intrinsics.areEqual(requestHeaders2.invoke(key), value)) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            httpCacheEntry = v2;
        }
        return httpCacheEntry;
    }

    private static final HttpCacheEntry findResponse(HttpCache $this$findResponse, HttpRequestBuilder context2, OutgoingContent content2) {
        Url url2 = URLUtilsKt.Url(context2.getUrl());
        Function1<String, String> lookup2 = HttpCacheKt.mergedHeadersLookup(content2, (Function1<? super String, String>)new Function1<String, String>((Object)context2.getHeaders()){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((HeadersBuilder)this.receiver).get(p0);
            }
        }, (Function1<? super String, ? extends List<String>>)new Function1<String, List<? extends String>>((Object)context2.getHeaders()){

            public final List<String> invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((HeadersBuilder)this.receiver).getAll(p0);
            }
        });
        Set<HttpCacheEntry> cachedResponses = SetsKt.plus($this$findResponse.getPrivateStorage$ktor_client_core().findByUrl(url2), (Iterable)$this$findResponse.getPublicStorage$ktor_client_core().findByUrl(url2));
        for (HttpCacheEntry item2 : cachedResponses) {
            Map<String, String> varyKeys = item2.getVaryKeys();
            if (!varyKeys.isEmpty()) {
                boolean bl;
                block5: {
                    Map<String, String> $this$all$iv = varyKeys;
                    boolean $i$f$all = false;
                    if ($this$all$iv.isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<Map.Entry<String, String>> iterator2 = $this$all$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<String, String> element$iv;
                            Map.Entry<String, String> entry = element$iv = iterator2.next();
                            boolean bl2 = false;
                            String key = entry.getKey();
                            String value = entry.getValue();
                            if (Intrinsics.areEqual(lookup2.invoke(key), value)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
            }
            return item2;
        }
        return null;
    }

    public static final /* synthetic */ Object access$proceedWithWarning(PipelineContext $receiver, HttpClientCall cachedCall, HttpClient scope2, Continuation $completion) {
        return HttpCacheLegacyKt.proceedWithWarning($receiver, cachedCall, scope2, $completion);
    }

    public static final /* synthetic */ Object access$cacheResponse(HttpCache $receiver, HttpResponse response2, Continuation $completion) {
        return HttpCacheLegacyKt.cacheResponse($receiver, response2, $completion);
    }
}

