/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.coroutines.FlowUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.ustadmobile.libcache.PublicationPinState;
import com.ustadmobile.libcache.db.DbTypeConverters;
import com.ustadmobile.libcache.db.dao.DownloadJobItemDao;
import com.ustadmobile.libcache.db.entities.DownloadJobItem;
import io.ktor.http.Url;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0096@\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\fH\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\fH\u0096@\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0004\b\u001a\u0010\u001bJ \u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0096@\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lcom/ustadmobile/libcache/db/dao/DownloadJobItemDao_Impl;", "Lcom/ustadmobile/libcache/db/dao/DownloadJobItemDao;", "Landroidx/room/RoomDatabase;", "__db", "<init>", "(Landroidx/room/RoomDatabase;)V", "", "Lcom/ustadmobile/libcache/db/entities/DownloadJobItem;", "items", "", "upsertList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "jobUid", "findPendingByJobUid", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllByJobUid", "findNumberJobItemsNotComplete", "", "pubManifestHash", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/libcache/PublicationPinState;", "publicationPinState", "(J)Lkotlinx/coroutines/flow/Flow;", "jobItemUid", "transferred", "updateTransferredProgress", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "status", "updateStatus", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroidx/room/RoomDatabase;", "Landroidx/room/EntityInsertAdapter;", "__insertAdapterOfDownloadJobItem", "Landroidx/room/EntityInsertAdapter;", "Lcom/ustadmobile/libcache/db/DbTypeConverters;", "__dbTypeConverters", "Lcom/ustadmobile/libcache/db/DbTypeConverters;", "Companion", "respect-lib-cache"})
public final class DownloadJobItemDao_Impl
extends DownloadJobItemDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<DownloadJobItem> __insertAdapterOfDownloadJobItem;
    @NotNull
    private final DbTypeConverters __dbTypeConverters;

    public DownloadJobItemDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter(__db, "__db");
        this.__dbTypeConverters = new DbTypeConverters();
        this.__db = __db;
        this.__insertAdapterOfDownloadJobItem = new EntityInsertAdapter<DownloadJobItem>(){

            @Override
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `DownloadJobItem` (`djiUid`,`djiDjUid`,`djiTotalSize`,`djiTransferred`,`djiAttemptCount`,`djiUrl`,`djiDest`,`djiType`,`djiStatus`,`djiEntityEtag`,`djiLockIdToRelease`,`djiPartialTmpFile`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
            }

            @Override
            protected void bind(SQLiteStatement statement, DownloadJobItem entity) {
                Intrinsics.checkNotNullParameter(statement, "statement");
                Intrinsics.checkNotNullParameter(entity, "entity");
                statement.bindLong(1, entity.getDjiUid());
                statement.bindLong(2, entity.getDjiDjUid());
                statement.bindLong(3, entity.getDjiTotalSize());
                statement.bindLong(4, entity.getDjiTransferred());
                statement.bindLong(5, entity.getDjiAttemptCount());
                String _tmp = __dbTypeConverters.fromUrl(entity.getDjiUrl());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmpDjiDest = entity.getDjiDest();
                if (_tmpDjiDest == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmpDjiDest);
                }
                statement.bindLong(8, entity.getDjiType());
                statement.bindLong(9, entity.getDjiStatus());
                statement.bindLong(10, entity.getDjiEntityEtag());
                statement.bindLong(11, entity.getDjiLockIdToRelease());
                String _tmpDjiPartialTmpFile = entity.getDjiPartialTmpFile();
                if (_tmpDjiPartialTmpFile == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmpDjiPartialTmpFile);
                }
            }
        };
    }

    @Override
    @Nullable
    public Object upsertList(@NotNull List<DownloadJobItem> items2, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending(this.__db, false, true, arg_0 -> DownloadJobItemDao_Impl.upsertList$lambda$0(this, items2, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object findPendingByJobUid(int jobUid, @NotNull Continuation<? super List<DownloadJobItem>> $completion) {
        String _sql = "\n        SELECT DownloadJobItem.*\n          FROM DownloadJobItem\n         WHERE DownloadJobItem.djiDjUid = ?\n           AND DownloadJobItem.djiStatus < 21\n    ";
        return DBUtil.performSuspending(this.__db, true, false, arg_0 -> DownloadJobItemDao_Impl.findPendingByJobUid$lambda$0(_sql, jobUid, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findAllByJobUid(int jobUid, @NotNull Continuation<? super List<DownloadJobItem>> $completion) {
        String _sql = "\n        SELECT DownloadJobItem.*\n          FROM DownloadJobItem\n         WHERE DownloadJobItem.djiDjUid = ?\n    ";
        return DBUtil.performSuspending(this.__db, true, false, arg_0 -> DownloadJobItemDao_Impl.findAllByJobUid$lambda$0(_sql, jobUid, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findNumberJobItemsNotComplete(int jobUid, @NotNull Continuation<? super Integer> $completion) {
        String _sql = "\n       SELECT COUNT(*)\n         FROM DownloadJobItem\n        WHERE DownloadJobItem.djiDjUid = ?\n          AND DownloadJobItem.djiStatus != 21\n    ";
        return DBUtil.performSuspending(this.__db, true, false, arg_0 -> DownloadJobItemDao_Impl.findNumberJobItemsNotComplete$lambda$0(_sql, jobUid, arg_0), $completion);
    }

    @Override
    @NotNull
    public Flow<PublicationPinState> publicationPinState(long pubManifestHash) {
        String _sql = "\n        WITH MostRecentDlUid(uid) AS (\n            SELECT COALESCE(\n                   (SELECT DownloadJob.djUid\n                      FROM DownloadJob\n                     WHERE DownloadJob.djPubManifestHash = ?\n                  ORDER BY DownloadJob.djTimeCreated DESC\n                     LIMIT 1), 0)\n        )\n        \n        SELECT CASE((SELECT DownloadJob.djStatus\n                       FROM DownloadJob\n                      WHERE DownloadJob.djUid = (SELECT uid FROM MostRecentDlUid)))\n                   WHEN 21 THEN 10\n                   WHEN 11 THEN 3\n                   WHEN 2 THEN 2\n                   ELSE 0\n                   END AS status,\n               (SELECT SUM(DownloadJobItem.djiTransferred)\n                  FROM DownloadJobItem\n                 WHERE DownloadJobItem.djiDjUid = (SELECT uid FROM MostRecentDlUid)) AS transferred,\n               (SELECT SUM(DownloadJobItem.djiTotalSize)\n                  FROM DownloadJobItem\n                 WHERE DownloadJobItem.djiDjUid = (SELECT uid FROM MostRecentDlUid)) AS totalSize  \n    ";
        String[] stringArray = new String[]{"DownloadJob", "DownloadJobItem"};
        return FlowUtil.createFlow(this.__db, false, stringArray, arg_0 -> DownloadJobItemDao_Impl.publicationPinState$lambda$0(_sql, pubManifestHash, this, arg_0));
    }

    @Override
    @Nullable
    public Object updateTransferredProgress(int jobItemUid, long transferred, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        UPDATE DownloadJobItem\n           SET djiTransferred = ?\n         WHERE djiUid = ?\n    ";
        Object object = DBUtil.performSuspending(this.__db, false, true, arg_0 -> DownloadJobItemDao_Impl.updateTransferredProgress$lambda$0(_sql, transferred, jobItemUid, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object updateStatus(int jobItemUid, int status2, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        UPDATE DownloadJobItem\n           SET djiStatus = ?\n         WHERE djiUid = ?  \n    ";
        Object object = DBUtil.performSuspending(this.__db, false, true, arg_0 -> DownloadJobItemDao_Impl.updateStatus$lambda$0(_sql, status2, jobItemUid, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit upsertList$lambda$0(DownloadJobItemDao_Impl this$0, List $items, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        this$0.__insertAdapterOfDownloadJobItem.insert(_connection, $items);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findPendingByJobUid$lambda$0(String $_sql, int $jobUid, DownloadJobItemDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $jobUid);
            int _columnIndexOfDjiUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiUid");
            int _columnIndexOfDjiDjUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiDjUid");
            int _columnIndexOfDjiTotalSize = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiTotalSize");
            int _columnIndexOfDjiTransferred = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiTransferred");
            int _columnIndexOfDjiAttemptCount = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiAttemptCount");
            int _columnIndexOfDjiUrl = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiUrl");
            int _columnIndexOfDjiDest = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiDest");
            int _columnIndexOfDjiType = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiType");
            int _columnIndexOfDjiStatus = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiStatus");
            int _columnIndexOfDjiEntityEtag = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiEntityEtag");
            int _columnIndexOfDjiLockIdToRelease = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiLockIdToRelease");
            int _columnIndexOfDjiPartialTmpFile = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiPartialTmpFile");
            List _result = new ArrayList();
            while (_stmt.step()) {
                DownloadJobItem _item = null;
                int _tmpDjiUid = 0;
                _tmpDjiUid = (int)_stmt.getLong(_columnIndexOfDjiUid);
                int _tmpDjiDjUid = 0;
                _tmpDjiDjUid = (int)_stmt.getLong(_columnIndexOfDjiDjUid);
                long _tmpDjiTotalSize = 0L;
                _tmpDjiTotalSize = _stmt.getLong(_columnIndexOfDjiTotalSize);
                long _tmpDjiTransferred = 0L;
                _tmpDjiTransferred = _stmt.getLong(_columnIndexOfDjiTransferred);
                int _tmpDjiAttemptCount = 0;
                _tmpDjiAttemptCount = (int)_stmt.getLong(_columnIndexOfDjiAttemptCount);
                Url _tmpDjiUrl = null;
                String _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfDjiUrl) ? null : _stmt.getText(_columnIndexOfDjiUrl);
                Url _tmp_1 = this$0.__dbTypeConverters.toUrl(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                }
                _tmpDjiUrl = _tmp_1;
                String _tmpDjiDest = null;
                _tmpDjiDest = _stmt.isNull(_columnIndexOfDjiDest) ? null : _stmt.getText(_columnIndexOfDjiDest);
                int _tmpDjiType = 0;
                _tmpDjiType = (int)_stmt.getLong(_columnIndexOfDjiType);
                int _tmpDjiStatus = 0;
                _tmpDjiStatus = (int)_stmt.getLong(_columnIndexOfDjiStatus);
                long _tmpDjiEntityEtag = 0L;
                _tmpDjiEntityEtag = _stmt.getLong(_columnIndexOfDjiEntityEtag);
                long _tmpDjiLockIdToRelease = 0L;
                _tmpDjiLockIdToRelease = _stmt.getLong(_columnIndexOfDjiLockIdToRelease);
                String _tmpDjiPartialTmpFile = null;
                _tmpDjiPartialTmpFile = _stmt.isNull(_columnIndexOfDjiPartialTmpFile) ? null : _stmt.getText(_columnIndexOfDjiPartialTmpFile);
                _item = new DownloadJobItem(_tmpDjiUid, _tmpDjiDjUid, _tmpDjiTotalSize, _tmpDjiTransferred, _tmpDjiAttemptCount, _tmpDjiUrl, _tmpDjiDest, _tmpDjiType, _tmpDjiStatus, _tmpDjiEntityEtag, _tmpDjiLockIdToRelease, _tmpDjiPartialTmpFile);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAllByJobUid$lambda$0(String $_sql, int $jobUid, DownloadJobItemDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $jobUid);
            int _columnIndexOfDjiUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiUid");
            int _columnIndexOfDjiDjUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiDjUid");
            int _columnIndexOfDjiTotalSize = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiTotalSize");
            int _columnIndexOfDjiTransferred = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiTransferred");
            int _columnIndexOfDjiAttemptCount = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiAttemptCount");
            int _columnIndexOfDjiUrl = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiUrl");
            int _columnIndexOfDjiDest = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiDest");
            int _columnIndexOfDjiType = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiType");
            int _columnIndexOfDjiStatus = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiStatus");
            int _columnIndexOfDjiEntityEtag = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiEntityEtag");
            int _columnIndexOfDjiLockIdToRelease = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiLockIdToRelease");
            int _columnIndexOfDjiPartialTmpFile = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "djiPartialTmpFile");
            List _result = new ArrayList();
            while (_stmt.step()) {
                DownloadJobItem _item = null;
                int _tmpDjiUid = 0;
                _tmpDjiUid = (int)_stmt.getLong(_columnIndexOfDjiUid);
                int _tmpDjiDjUid = 0;
                _tmpDjiDjUid = (int)_stmt.getLong(_columnIndexOfDjiDjUid);
                long _tmpDjiTotalSize = 0L;
                _tmpDjiTotalSize = _stmt.getLong(_columnIndexOfDjiTotalSize);
                long _tmpDjiTransferred = 0L;
                _tmpDjiTransferred = _stmt.getLong(_columnIndexOfDjiTransferred);
                int _tmpDjiAttemptCount = 0;
                _tmpDjiAttemptCount = (int)_stmt.getLong(_columnIndexOfDjiAttemptCount);
                Url _tmpDjiUrl = null;
                String _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfDjiUrl) ? null : _stmt.getText(_columnIndexOfDjiUrl);
                Url _tmp_1 = this$0.__dbTypeConverters.toUrl(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                }
                _tmpDjiUrl = _tmp_1;
                String _tmpDjiDest = null;
                _tmpDjiDest = _stmt.isNull(_columnIndexOfDjiDest) ? null : _stmt.getText(_columnIndexOfDjiDest);
                int _tmpDjiType = 0;
                _tmpDjiType = (int)_stmt.getLong(_columnIndexOfDjiType);
                int _tmpDjiStatus = 0;
                _tmpDjiStatus = (int)_stmt.getLong(_columnIndexOfDjiStatus);
                long _tmpDjiEntityEtag = 0L;
                _tmpDjiEntityEtag = _stmt.getLong(_columnIndexOfDjiEntityEtag);
                long _tmpDjiLockIdToRelease = 0L;
                _tmpDjiLockIdToRelease = _stmt.getLong(_columnIndexOfDjiLockIdToRelease);
                String _tmpDjiPartialTmpFile = null;
                _tmpDjiPartialTmpFile = _stmt.isNull(_columnIndexOfDjiPartialTmpFile) ? null : _stmt.getText(_columnIndexOfDjiPartialTmpFile);
                _item = new DownloadJobItem(_tmpDjiUid, _tmpDjiDjUid, _tmpDjiTotalSize, _tmpDjiTransferred, _tmpDjiAttemptCount, _tmpDjiUrl, _tmpDjiDest, _tmpDjiType, _tmpDjiStatus, _tmpDjiEntityEtag, _tmpDjiLockIdToRelease, _tmpDjiPartialTmpFile);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int findNumberJobItemsNotComplete$lambda$0(String $_sql, int $jobUid, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $jobUid);
            int _result = 0;
            if (_stmt.step()) {
                int _tmp = 0;
                _result = _tmp = (int)_stmt.getLong(0);
            } else {
                _result = 0;
            }
            n = _result;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PublicationPinState publicationPinState$lambda$0(String $_sql, long $pubManifestHash, DownloadJobItemDao_Impl this$0, SQLiteConnection _connection) {
        PublicationPinState publicationPinState;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $pubManifestHash);
            int _columnIndexOfStatus = 0;
            int _columnIndexOfTransferred = 1;
            int _columnIndexOfTotalSize = 2;
            PublicationPinState _result = null;
            if (!_stmt.step()) {
                throw new IllegalStateException("The query result was empty, but expected a single row to return a NON-NULL object of type 'com.ustadmobile.libcache.PublicationPinState'.".toString());
            }
            PublicationPinState.Status _tmpStatus = null;
            int _tmp = 0;
            _tmp = (int)_stmt.getLong(_columnIndexOfStatus);
            _tmpStatus = this$0.__dbTypeConverters.toPublicationPinStateStatus(_tmp);
            long _tmpTransferred = 0L;
            _tmpTransferred = _stmt.getLong(_columnIndexOfTransferred);
            long _tmpTotalSize = 0L;
            _tmpTotalSize = _stmt.getLong(_columnIndexOfTotalSize);
            _result = new PublicationPinState(_tmpStatus, _tmpTotalSize, _tmpTransferred);
            publicationPinState = _result;
        }
        return publicationPinState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateTransferredProgress$lambda$0(String $_sql, long $transferred, int $jobItemUid, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $transferred);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $jobItemUid);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateStatus$lambda$0(String $_sql, int $status, int $jobItemUid, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $status);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $jobItemUid);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/libcache/db/dao/DownloadJobItemDao_Impl$Companion;", "", "<init>", "()V", "", "Lkotlin/reflect/KClass;", "getRequiredConverters", "()Ljava/util/List;", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

