/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a)\u0010\u0005\u001a\u00028\u0000\"\f\b\u0000\u0010\u0002*\u00060\u0000j\u0002`\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a'\u0010\u000b\u001a\u00020\n*\u00060\u0000j\u0002`\u00012\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a'\u0010\u000e\u001a\u00020\n*\u00060\u0000j\u0002`\u00012\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\f\u001a\u001f\u0010\u000f\u001a\u00020\n*\u00060\u0000j\u0002`\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0011\u0010\u0011\u001a\u00020\u0003*\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a)\u0010\u0017\u001a\u00020\u0003*\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a/\u0010\u0017\u001a\u00020\u0003*\u00020\u00032\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u001b\u001a%\u0010\u001c\u001a\u00020\n*\u00020\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001f\u0010\u001e\u001a\u00020\u0003*\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a%\u0010\u001e\u001a\u00020\u0003*\u00020\u00032\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007\u00a2\u0006\u0004\b\u001e\u0010 \u001a\u0019\u0010!\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0002\u00a2\u0006\u0004\b!\u0010\"\u001a\\\u0010)\u001a\u00020\n*\u00020\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010%\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0019\b\u0002\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0&\u00a2\u0006\u0002\b'\u00a2\u0006\u0004\b)\u0010*\u001a'\u0010+\u001a\u00020\u0003*\u00020\u00032\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007H\u0007\u00a2\u0006\u0004\b+\u0010 \u001a!\u0010+\u001a\u00020\u0003*\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0004\b+\u0010\u001f\"\u0014\u0010,\u001a\u00020$8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b,\u0010-\"\u0018\u00100\u001a\u00020\u0007*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0015\u00102\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/\"(\u0010\r\u001a\u00020\u0007*\u00020\u00032\u0006\u00103\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010/\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "A", "Lio/ktor/http/URLBuilder;", "out", "appendTo", "(Lio/ktor/http/URLBuilder;Ljava/lang/Appendable;)Ljava/lang/Appendable;", "", "encodedUser", "host", "", "appendMailto", "(Ljava/lang/Appendable;Ljava/lang/String;Ljava/lang/String;)V", "encodedPath", "appendFile", "appendPayload", "(Ljava/lang/Appendable;Ljava/lang/String;)V", "clone", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "", "segments", "", "encodeSlash", "appendPathSegments", "(Lio/ktor/http/URLBuilder;Ljava/util/List;Z)Lio/ktor/http/URLBuilder;", "", "components", "(Lio/ktor/http/URLBuilder;[Ljava/lang/String;Z)Lio/ktor/http/URLBuilder;", "path", "(Lio/ktor/http/URLBuilder;[Ljava/lang/String;)V", "appendEncodedPathSegments", "(Lio/ktor/http/URLBuilder;Ljava/util/List;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;[Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "joinPath", "(Ljava/util/List;)Ljava/lang/String;", "scheme", "", "port", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "block", "set", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "pathComponents", "DEFAULT_PORT", "I", "getEncodedUserAndPassword", "(Lio/ktor/http/URLBuilder;)Ljava/lang/String;", "encodedUserAndPassword", "getAuthority", "authority", "value", "getEncodedPath", "setEncodedPath", "(Lio/ktor/http/URLBuilder;Ljava/lang/String;)V", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLBuilder.kt\nio/ktor/http/URLBuilderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,372:1\n1374#2:373\n1460#2,5:374\n1563#2:379\n1634#2,3:380\n11228#3:383\n11563#3,3:384\n*S KotlinDebug\n*F\n+ 1 URLBuilder.kt\nio/ktor/http/URLBuilderKt\n*L\n244#1:373\n244#1:374,5\n245#1:379\n245#1:380,3\n273#1:383\n273#1:384,3\n*E\n"})
public final class URLBuilderKt {
    public static final int DEFAULT_PORT = 0;

    private static final <A extends Appendable> A appendTo(URLBuilder $this$appendTo, A out) {
        out.append($this$appendTo.getProtocol().getName());
        switch ($this$appendTo.getProtocol().getName()) {
            case "file": {
                URLBuilderKt.appendFile(out, $this$appendTo.getHost(), URLBuilderKt.getEncodedPath($this$appendTo));
                return out;
            }
            case "mailto": {
                URLBuilderKt.appendMailto(out, URLBuilderKt.getEncodedUserAndPassword($this$appendTo), $this$appendTo.getHost());
                return out;
            }
            case "about": {
                URLBuilderKt.appendPayload(out, $this$appendTo.getHost());
                return out;
            }
            case "tel": {
                URLBuilderKt.appendPayload(out, $this$appendTo.getHost());
                return out;
            }
            case "data": {
                URLBuilderKt.appendPayload(out, $this$appendTo.getHost());
                return out;
            }
        }
        out.append("://");
        out.append(URLBuilderKt.getAuthority($this$appendTo));
        URLUtilsKt.appendUrlFullPath(out, URLBuilderKt.getEncodedPath($this$appendTo), $this$appendTo.getEncodedParameters(), $this$appendTo.getTrailingQuery());
        if (((CharSequence)$this$appendTo.getEncodedFragment()).length() > 0) {
            out.append('#');
            out.append($this$appendTo.getEncodedFragment());
        }
        return out;
    }

    private static final void appendMailto(Appendable $this$appendMailto, String encodedUser, String host) {
        $this$appendMailto.append(":");
        $this$appendMailto.append(encodedUser);
        $this$appendMailto.append(host);
    }

    private static final void appendFile(Appendable $this$appendFile, String host, String encodedPath) {
        $this$appendFile.append("://");
        $this$appendFile.append(host);
        if (!StringsKt.startsWith$default((CharSequence)encodedPath, '/', false, 2, null)) {
            $this$appendFile.append('/');
        }
        $this$appendFile.append(encodedPath);
    }

    private static final void appendPayload(Appendable $this$appendPayload, String host) {
        $this$appendPayload.append(":");
        $this$appendPayload.append(host);
    }

    @NotNull
    public static final URLBuilder clone(@NotNull URLBuilder $this$clone) {
        Intrinsics.checkNotNullParameter($this$clone, "<this>");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), $this$clone);
    }

    @NotNull
    public static final String getEncodedUserAndPassword(@NotNull URLBuilder $this$encodedUserAndPassword) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$encodedUserAndPassword, "<this>");
        StringBuilder $this$_get_encodedUserAndPassword__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        URLUtilsKt.appendUserAndPassword($this$_get_encodedUserAndPassword__u24lambda_u240, $this$encodedUserAndPassword.getEncodedUser(), $this$encodedUserAndPassword.getEncodedPassword());
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder appendPathSegments(@NotNull URLBuilder $this$appendPathSegments, @NotNull List<String> segments, boolean encodeSlash) {
        void $this$mapTo$iv$iv;
        List list2;
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter($this$appendPathSegments, "<this>");
        Intrinsics.checkNotNullParameter(segments, "segments");
        if (!encodeSlash) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = segments;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                char[] cArray = new char[]{'/'};
                Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, cArray, false, 0, 6, null);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = segments;
        }
        List pathSegments = list2;
        Iterable $this$map$iv = pathSegments;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(CodecsKt.encodeURLPathPart((String)it));
        }
        List encodedSegments = (List)destination$iv$iv2;
        URLBuilderKt.appendEncodedPathSegments($this$appendPathSegments, encodedSegments);
        return $this$appendPathSegments;
    }

    public static /* synthetic */ URLBuilder appendPathSegments$default(URLBuilder uRLBuilder, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return URLBuilderKt.appendPathSegments(uRLBuilder, list2, bl);
    }

    @NotNull
    public static final URLBuilder appendPathSegments(@NotNull URLBuilder $this$appendPathSegments, @NotNull String[] components, boolean encodeSlash) {
        Intrinsics.checkNotNullParameter($this$appendPathSegments, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        return URLBuilderKt.appendPathSegments($this$appendPathSegments, ArraysKt.toList(components), encodeSlash);
    }

    public static /* synthetic */ URLBuilder appendPathSegments$default(URLBuilder uRLBuilder, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return URLBuilderKt.appendPathSegments(uRLBuilder, stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final void path(@NotNull URLBuilder $this$path, String ... path) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$path, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        String[] stringArray = path;
        URLBuilder uRLBuilder = $this$path;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CodecsKt.encodeURLPath$default((String)it, false, false, 3, null));
        }
        uRLBuilder.setEncodedPathSegments((List)destination$iv$iv);
    }

    @NotNull
    public static final URLBuilder appendEncodedPathSegments(@NotNull URLBuilder $this$appendEncodedPathSegments, @NotNull List<String> segments) {
        boolean startWithSlash;
        boolean endsWithSlash;
        Intrinsics.checkNotNullParameter($this$appendEncodedPathSegments, "<this>");
        Intrinsics.checkNotNullParameter(segments, "segments");
        boolean bl = $this$appendEncodedPathSegments.getEncodedPathSegments().size() > 1 && ((CharSequence)CollectionsKt.last($this$appendEncodedPathSegments.getEncodedPathSegments())).length() == 0 && !((Collection)segments).isEmpty() ? true : (endsWithSlash = false);
        boolean bl2 = segments.size() > 1 && ((CharSequence)CollectionsKt.first(segments)).length() == 0 && !((Collection)$this$appendEncodedPathSegments.getEncodedPathSegments()).isEmpty() ? true : (startWithSlash = false);
        $this$appendEncodedPathSegments.setEncodedPathSegments(endsWithSlash && startWithSlash ? CollectionsKt.plus((Collection)CollectionsKt.dropLast($this$appendEncodedPathSegments.getEncodedPathSegments(), 1), (Iterable)CollectionsKt.drop((Iterable)segments, 1)) : (endsWithSlash ? CollectionsKt.plus((Collection)CollectionsKt.dropLast($this$appendEncodedPathSegments.getEncodedPathSegments(), 1), (Iterable)segments) : (startWithSlash ? CollectionsKt.plus((Collection)$this$appendEncodedPathSegments.getEncodedPathSegments(), (Iterable)CollectionsKt.drop((Iterable)segments, 1)) : CollectionsKt.plus((Collection)$this$appendEncodedPathSegments.getEncodedPathSegments(), (Iterable)segments))));
        return $this$appendEncodedPathSegments;
    }

    @NotNull
    public static final URLBuilder appendEncodedPathSegments(@NotNull URLBuilder $this$appendEncodedPathSegments, String ... components) {
        Intrinsics.checkNotNullParameter($this$appendEncodedPathSegments, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        return URLBuilderKt.appendEncodedPathSegments($this$appendEncodedPathSegments, ArraysKt.toList(components));
    }

    @NotNull
    public static final String getAuthority(@NotNull URLBuilder $this$authority) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$authority, "<this>");
        StringBuilder $this$_get_authority__u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_authority__u24lambda_u244.append(URLBuilderKt.getEncodedUserAndPassword($this$authority));
        $this$_get_authority__u24lambda_u244.append($this$authority.getHost());
        if ($this$authority.getPort() != 0 && $this$authority.getPort() != $this$authority.getProtocol().getDefaultPort()) {
            $this$_get_authority__u24lambda_u244.append(":");
            $this$_get_authority__u24lambda_u244.append(String.valueOf($this$authority.getPort()));
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final String getEncodedPath(@NotNull URLBuilder $this$encodedPath) {
        Intrinsics.checkNotNullParameter($this$encodedPath, "<this>");
        return URLBuilderKt.joinPath($this$encodedPath.getEncodedPathSegments());
    }

    public static final void setEncodedPath(@NotNull URLBuilder $this$encodedPath, @NotNull String value) {
        List<String> list2;
        Intrinsics.checkNotNullParameter($this$encodedPath, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        if (StringsKt.isBlank(value)) {
            list2 = CollectionsKt.emptyList();
        } else if (Intrinsics.areEqual(value, "/")) {
            list2 = URLParserKt.getROOT_PATH();
        } else {
            char[] cArray = new char[]{'/'};
            list2 = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)value, cArray, false, 0, 6, null));
        }
        $this$encodedPath.setEncodedPathSegments(list2);
    }

    private static final String joinPath(List<String> $this$joinPath) {
        if ($this$joinPath.isEmpty()) {
            return "";
        }
        if ($this$joinPath.size() == 1) {
            if (((CharSequence)CollectionsKt.first($this$joinPath)).length() == 0) {
                return "/";
            }
            return CollectionsKt.first($this$joinPath);
        }
        return CollectionsKt.joinToString$default($this$joinPath, "/", null, null, 0, null, null, 62, null);
    }

    public static final void set(@NotNull URLBuilder $this$set, @Nullable String scheme, @Nullable String host, @Nullable Integer port, @Nullable String path, @NotNull Function1<? super URLBuilder, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$set, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        if (scheme != null) {
            $this$set.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
        }
        if (host != null) {
            $this$set.setHost(host);
        }
        if (port != null) {
            $this$set.setPort(port);
        }
        if (path != null) {
            URLBuilderKt.setEncodedPath($this$set, path);
        }
        block2.invoke($this$set);
    }

    public static /* synthetic */ void set$default(URLBuilder uRLBuilder, String string2, String string3, Integer n, String string4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = null;
        }
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            string4 = null;
        }
        if ((n2 & 0x10) != 0) {
            function1 = URLBuilderKt::set$lambda$5;
        }
        URLBuilderKt.set(uRLBuilder, string2, string3, n, string4, function1);
    }

    @Deprecated(message="Please use appendPathSegments method", replaceWith=@ReplaceWith(expression="this.appendPathSegments(components", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final URLBuilder pathComponents(@NotNull URLBuilder $this$pathComponents, String ... components) {
        Intrinsics.checkNotNullParameter($this$pathComponents, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        return URLBuilderKt.appendPathSegments$default($this$pathComponents, ArraysKt.toList(components), false, 2, null);
    }

    @Deprecated(message="Please use appendPathSegments method", replaceWith=@ReplaceWith(expression="this.appendPathSegments(components", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final URLBuilder pathComponents(@NotNull URLBuilder $this$pathComponents, @NotNull List<String> components) {
        Intrinsics.checkNotNullParameter($this$pathComponents, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        return URLBuilderKt.appendPathSegments$default($this$pathComponents, components, false, 2, null);
    }

    private static final Unit set$lambda$5(URLBuilder uRLBuilder) {
        Intrinsics.checkNotNullParameter(uRLBuilder, "<this>");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Appendable access$appendTo(URLBuilder $receiver, Appendable out) {
        return URLBuilderKt.appendTo($receiver, out);
    }
}

