/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CharsetKt;
import io.ktor.util.CryptoKt;
import io.ktor.util.Digest;
import io.ktor.utils.io.InternalAPI;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=5, xi=48, d1={"\u00002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0005\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0006\u001a\u0015\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001c\u0010\f\u001a\u00020\u0000*\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u0000H\u0087@\u00a2\u0006\u0004\b\f\u0010\r\u001a*\u0010\f\u001a\u00020\u0000*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\f\b\u0002\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010H\u0087@\u00a2\u0006\u0004\b\f\u0010\u0012\"\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\"\u0014\u0010\u0016\u001a\u00020\u00078\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"", "bytes", "", "hex", "([B)Ljava/lang/String;", "s", "(Ljava/lang/String;)[B", "", "size", "generateNonce", "(I)[B", "Lio/ktor/util/Digest;", "build", "(Lio/ktor/util/Digest;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "string", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "(Lio/ktor/util/Digest;Ljava/lang/String;Ljava/nio/charset/Charset;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "digits", "[C", "NONCE_SIZE_IN_BYTES", "I", "ktor-utils"}, xs="io/ktor/util/CryptoKt")
@SourceDebugExtension(value={"SMAP\nCrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crypto.kt\nio/ktor/util/CryptoKt__CryptoKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,137:1\n21#2,3:138\n*S KotlinDebug\n*F\n+ 1 Crypto.kt\nio/ktor/util/CryptoKt__CryptoKt\n*L\n67#1:138,3\n*E\n"})
final class CryptoKt__CryptoKt {
    @NotNull
    private static final char[] digits = CharsetKt.toCharArray("0123456789abcdef");

    @NotNull
    public static final String hex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        char[] result2 = new char[bytes.length * 2];
        int resultIndex = 0;
        char[] digits = CryptoKt__CryptoKt.digits;
        for (byte element : bytes) {
            int b2 = element & 0xFF;
            result2[resultIndex++] = digits[b2 >> 4];
            result2[resultIndex++] = digits[b2 & 0xF];
        }
        return kotlin.text.StringsKt.concatToString(result2);
    }

    @NotNull
    public static final byte[] hex(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        byte[] result2 = new byte[s2.length() / 2];
        int n = result2.length;
        for (int idx2 = 0; idx2 < n; ++idx2) {
            int srcIdx = idx2 * 2;
            int high = Integer.parseInt(String.valueOf(s2.charAt(srcIdx)), CharsKt.checkRadix(16)) << 4;
            int low = Integer.parseInt(String.valueOf(s2.charAt(srcIdx + 1)), CharsKt.checkRadix(16));
            result2[idx2] = (byte)(high | low);
        }
        return result2;
    }

    @NotNull
    public static final byte[] generateNonce(int size2) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$generateNonce_u24lambda_u240 = builder$iv;
        boolean bl = false;
        while (BytePacketBuilderKt.getSize($this$generateNonce_u24lambda_u240) < size2) {
            StringsKt.writeText$default($this$generateNonce_u24lambda_u240, CryptoKt.generateNonce(), 0, 0, null, 14, null);
        }
        return SourcesKt.readByteArray(builder$iv, size2);
    }

    @InternalAPI
    @Nullable
    public static final Object build(@NotNull Digest $this$build, @NotNull byte[] bytes, @NotNull Continuation<? super byte[]> $completion) {
        $this$build.plusAssign(bytes);
        return $this$build.build($completion);
    }

    @InternalAPI
    @Nullable
    public static final Object build(@NotNull Digest $this$build, @NotNull String string2, @NotNull Charset charset, @NotNull Continuation<? super byte[]> $completion) {
        $this$build.plusAssign(StringsKt.toByteArray(string2, charset));
        return $this$build.build($completion);
    }

    public static /* synthetic */ Object build$default(Digest digest, String string2, Charset charset, Continuation continuation2, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return CryptoKt.build(digest, string2, charset, continuation2);
    }
}

